/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.EventConfirmConstant;

/**
 * 通知イベント情報クラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyEventInfo
   implements java.io.Serializable
{
   private java.lang.String m_notifyId;
   private java.lang.Integer m_priority;
   private java.lang.Integer m_eventNormalFlg;
   private java.lang.Integer m_eventNormalState = new Integer(EventConfirmConstant.TYPE_UNCONFIRMED);
   private java.lang.Integer m_eventInhibitionFlg;
   private java.lang.Integer m_eventInhibitionState = new Integer(EventConfirmConstant.TYPE_CONFIRMED);
   private java.lang.Integer m_mailFlg;
   private java.lang.String m_mailAddress;
   

   public NotifyEventInfo()
   {
   }

   public NotifyEventInfo( java.lang.String notifyId,java.lang.Integer priority,java.lang.Integer eventNormalFlg,java.lang.Integer eventNormalState,java.lang.Integer eventInhibitionFlg,java.lang.Integer eventInhibitionState,java.lang.Integer mailFlg,java.lang.String mailAddress )
   {
      setNotifyId(notifyId);
      setPriority(priority);
      setEventNormalFlg(eventNormalFlg);
      setEventNormalState(eventNormalState);
      setEventInhibitionFlg(eventInhibitionFlg);
      setEventInhibitionState(eventInhibitionState);
      setMailFlg(mailFlg);
      setMailAddress(mailAddress);
   }

   public NotifyEventInfo( NotifyEventInfo otherData )
   {
      setNotifyId(otherData.getNotifyId());
      setPriority(otherData.getPriority());
      setEventNormalFlg(otherData.getEventNormalFlg());
      setEventNormalState(otherData.getEventNormalState());
      setEventInhibitionFlg(otherData.getEventInhibitionFlg());
      setEventInhibitionState(otherData.getEventInhibitionState());
      setMailFlg(otherData.getMailFlg());
      setMailAddress(otherData.getMailAddress());

   }

   public java.lang.String getNotifyId()
   {
      return this.m_notifyId;
   }
   public void setNotifyId( java.lang.String notifyId )
   {
      this.m_notifyId = notifyId;
   }

   public java.lang.Integer getPriority()
   {
      return this.m_priority;
   }
   public void setPriority( java.lang.Integer priority )
   {
      this.m_priority = priority;
   }

   public java.lang.Integer getEventNormalFlg()
   {
      return this.m_eventNormalFlg;
   }
   public void setEventNormalFlg( java.lang.Integer eventNormalFlg )
   {
      this.m_eventNormalFlg = eventNormalFlg;
   }

   public java.lang.Integer getEventNormalState()
   {
      return this.m_eventNormalState;
   }
   public void setEventNormalState( java.lang.Integer eventNormalState )
   {
      this.m_eventNormalState = eventNormalState;
   }

   public java.lang.Integer getEventInhibitionFlg()
   {
      return this.m_eventInhibitionFlg;
   }
   public void setEventInhibitionFlg( java.lang.Integer eventInhibitionFlg )
   {
      this.m_eventInhibitionFlg = eventInhibitionFlg;
   }

   public java.lang.Integer getEventInhibitionState()
   {
      return this.m_eventInhibitionState;
   }
   public void setEventInhibitionState( java.lang.Integer eventInhibitionState )
   {
      this.m_eventInhibitionState = eventInhibitionState;
   }

   public java.lang.Integer getMailFlg()
   {
      return this.m_mailFlg;
   }
   public void setMailFlg( java.lang.Integer mailFlg )
   {
      this.m_mailFlg = mailFlg;
   }

   public java.lang.String getMailAddress()
   {
      return this.m_mailAddress;
   }
   public void setMailAddress( java.lang.String mailAddress )
   {
      this.m_mailAddress = mailAddress;
   }
}
