/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;

/**
 * 文字列監視判定情報クラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorStringValueInfo
	extends MonitorJudgementInfo
{
	private static final long serialVersionUID = -72068372783747219L;
	
	/** 識別キー */
	protected String m_identifier; 
	
	/** 順序 */
	protected int m_orderNo = Integer.MAX_VALUE; 
	
	/** 説明 */
	protected String m_description; 
	
	/** 処理タイプ */
	protected int m_processType = ProcessConstant.TYPE_YES; 
	
	/** パターンマッチ表現 */
	protected String m_pattern; 
	
	/** 通知ID */
	protected String m_notifyId; 
	
	/** 有効フラグ */
	protected boolean m_validFlg = ValidConstant.BOOLEAN_VALID;
	
	
	/**
	 * コンストラクタ
	 */
	public MonitorStringValueInfo() {
		super();
	}
	
	/**
	 * コンストラクタ
	 * 
	 * @param monitorTypeId
	 * @param monitorId
	 * @param orderNo
	 * @param description
	 * @param processType
	 * @param pattern
	 * @param priority
	 * @param messageId
	 * @param message
	 * @param notifyId
	 * @param jobRun
	 * @param jobId
	 * @param jobInhibitionFlg
	 * @param jobFailurePriority
	 * @param validFlg
	 */
	public MonitorStringValueInfo(
			String monitorTypeId, 
			String monitorId, 
			int orderNo, 
			String description, 
			int processType, 
			String pattern, 
			int priority, 
			String messageId, 
			String message, 
			String notifyId, 
			int jobRun, 
			String jobId, 
			int jobInhibitionFlg, 
			int jobFailurePriority, 
			boolean validFlg) {
		
		setMonitorTypeId(monitorTypeId);
		setMonitorId(monitorId);
		setOrderNo(orderNo);
		setDescription(description);
		setProcessType(processType);
		setPattern(pattern);
		setPriority(priority);
		setMessageId(messageId);
		setMessage(message);
		setNotifyId(notifyId);
		setJobRun(jobRun);
		setJobId(jobId);
		setJobInhibitionFlg(jobInhibitionFlg);
		setJobFailurePriority(jobFailurePriority);
		setValidFlg(validFlg);
	}
	
	/**
	 * コンストラクタ
	 * 
	 * @param otherData
	 */
	public MonitorStringValueInfo(MonitorStringValueInfo otherData) {
		
		setIdentifier(otherData.getIdentifier());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setMonitorId(otherData.getMonitorId());
		setOrderNo(otherData.getOrderNo());
		setDescription(otherData.getDescription());
		setProcessType(otherData.getProcessType());
		setPattern(otherData.getPattern());
		setPriority(otherData.getPriority());
		setMessageId(otherData.getMessageId());
		setMessage(otherData.getMessage());
		setNotifyId(otherData.getNotifyId());
		setJobRun(otherData.getJobRun());
		setJobId(otherData.getJobId());
		setJobInhibitionFlg(otherData.getJobInhibitionFlg());
		setJobFailurePriority(otherData.getJobFailurePriority());
		setValidFlg(otherData.isValidFlg());
	}
	
	/**
	 * @return m_description を戻します。
	 */
	public String getDescription() {
		return m_description;
	}
	
	/**
	 * @param description 設定する m_description。
	 */
	public void setDescription(String description) {
		this.m_description = description;
	}
	
	/**
	 * @return m_identifier を戻します。
	 */
	public String getIdentifier() {
		return m_identifier;
	}
	
	/**
	 * @param identifier 設定する m_identifier。
	 */
	public void setIdentifier(String identifier) {
		this.m_identifier = identifier;
	}
	
	/**
	 * @return m_notifyId を戻します。
	 */
	public String getNotifyId() {
		return m_notifyId;
	}
	
	/**
	 * @param notifyId 設定する m_notifyId。
	 */
	public void setNotifyId(String notifyId) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * @return m_orderNo を戻します。
	 */
	public int getOrderNo() {
		return m_orderNo;
	}
	
	/**
	 * @param orderNo 設定する m_orderNo。
	 */
	public void setOrderNo(int orderNo) {
		this.m_orderNo = orderNo;
	}
	
	/**
	 * @return m_pattern を戻します。
	 */
	public String getPattern() {
		return m_pattern;
	}
	
	/**
	 * @param pattern 設定する m_pattern。
	 */
	public void setPattern(String pattern) {
		this.m_pattern = pattern;
	}
	
	/**
	 * @return m_processType を戻します。
	 */
	public int getProcessType() {
		return m_processType;
	}
	
	/**
	 * @param processType 設定する m_processType。
	 */
	public void setProcessType(int processType) {
		this.m_processType = processType;
	}
	
	/**
	 * @return m_validFlg を戻します。
	 */
	public boolean isValidFlg() {
		return m_validFlg;
	}
	
	/**
	 * @param validFlg 設定する m_validFlg。
	 */
	public void setValidFlg(boolean validFlg) {
		this.m_validFlg = validFlg;
	}
}
