/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * 判定情報クラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public abstract class MonitorJudgementInfo
	extends java.lang.Object
	implements java.io.Serializable
{
	private static final long serialVersionUID = 2684510388370616270L;
	
	/** 監視対象ID */
	protected String m_monitorTypeId;
	
	/** 監視項目ID */
	protected String m_monitorId;
	
	/** 重要度 */
	protected int m_priority;
	
	/** メッセージID */
	protected String m_messageId;
	
	/** メッセージ */
	protected String m_message;
	
	/** ジョブ実行 */
	protected int m_jobRun = YesNoConstant.TYPE_NO;
	
	/** ジョブID */
	protected String m_jobId;
	
	/** ジョブ実行 通知抑制連動 */
	protected int m_jobInhibitionFlg = YesNoConstant.TYPE_NO;
	
	/** ジョブ呼び出し失敗時重要度 */
	protected int m_jobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
	
	
	/**
	 * @return jobFailurePriority を戻します。
	 */
	public int getJobFailurePriority() {
		return m_jobFailurePriority;
	}
	
	/**
	 * @param jobFailurePriority 設定する jobFailurePriority。
	 */
	public void setJobFailurePriority(int jobFailurePriority) {
		this.m_jobFailurePriority = jobFailurePriority;
	}
	
	/**
	 * @return jobId を戻します。
	 */
	public String getJobId() {
		return m_jobId;
	}
	
	/**
	 * @param jobId 設定する jobId。
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	
	/**
	 * @return jobInhibitionFlg を戻します。
	 */
	public int getJobInhibitionFlg() {
		return m_jobInhibitionFlg;
	}
	
	/**
	 * @param jobInhibitionFlg 設定する jobInhibitionFlg。
	 */
	public void setJobInhibitionFlg(int jobInhibitionFlg) {
		this.m_jobInhibitionFlg = jobInhibitionFlg;
	}
	
	/**
	 * @return jobRun を戻します。
	 */
	public int getJobRun() {
		return m_jobRun;
	}
	
	/**
	 * @param jobRun 設定する jobRun。
	 */
	public void setJobRun(int jobRun) {
		this.m_jobRun = jobRun;
	}
	
	/**
	 * @return message を戻します。
	 */
	public String getMessage() {
		return m_message;
	}
	
	/**
	 * @param message 設定する message。
	 */
	public void setMessage(String message) {
		this.m_message = message;
	}
	
	/**
	 * @return messageId を戻します。
	 */
	public String getMessageId() {
		return m_messageId;
	}
	
	/**
	 * @param messageId 設定する messageId。
	 */
	public void setMessageId(String messageId) {
		this.m_messageId = messageId;
	}
	
	/**
	 * @return monitorId を戻します。
	 */
	public String getMonitorId() {
		return m_monitorId;
	}
	
	/**
	 * @param monitorId 設定する monitorId。
	 */
	public void setMonitorId(String monitorId) {
		this.m_monitorId = monitorId;
	}
	
	/**
	 * @return monitorTypeId を戻します。
	 */
	public String getMonitorTypeId() {
		return m_monitorTypeId;
	}
	
	/**
	 * @param monitorTypeId 設定する monitorTypeId。
	 */
	public void setMonitorTypeId(String monitorTypeId) {
		this.m_monitorTypeId = monitorTypeId;
	}
	
	/**
	 * @return priority を戻します。
	 */
	public int getPriority() {
		return m_priority;
	}
	
	/**
	 * @param priority 設定する priority。
	 */
	public void setPriority(int priority) {
		this.m_priority = priority;
	}
}
