/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * 監視情報クラスです。
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorInfo
	extends Object
	implements java.io.Serializable
{
	private static final long serialVersionUID = 8016002145318844928L;
	
	protected String m_application;
	protected String m_calendarId;
	protected String m_description;
	protected String m_determinationId;
	protected String m_scope;
	protected String m_facilityId;
	protected int m_failurePriority = PriorityConstant.TYPE_UNKNOWN;
	protected int m_monitorBlock = MonitorBlockConstant.TYPE_ALL;
	protected String m_monitorId;
	protected String m_monitorTypeId;
	protected String m_notifyId;
	protected int m_runInterval = RunIntervalConstant.TYPE_MIN_01;
	protected Timestamp m_regDate;
	protected Timestamp m_updateDate;
	protected int m_valid = ValidConstant.TYPE_VALID;
	
	/** 判定情報 */
	protected ArrayList m_judgementInfo;
	/** 監視チェック情報 */
	protected MonitorCheckInfo m_checkInfo;
	
	/** 監視判定タイプ @since 2.1.0 */
	protected int m_monitorType;
	/** タイムアウト @since 2.1.0 */
	protected int m_timeout;
	/** ジョブ実行 @since 2.1.0 */
	protected int m_jobRun = YesNoConstant.TYPE_NO;
	
	/** 値取得の失敗時のメッセージID @since 2.1.0 */
	protected String m_failureMessageId;
	/** 値取得の失敗時のメッセージ @since 2.1.0 */
	protected String m_failureMessage;
	
	/** 値取得の失敗時のジョブ実行 @since 2.1.0 */
	protected int m_failureJobRun = YesNoConstant.TYPE_NO;
	/** 値取得の失敗時のジョブID @since 2.1.0 */
	protected String m_failureJobId;
	/** 値取得の失敗時のジョブ実行 通知抑制連動 @since 2.1.0 */
	protected int m_failureJobInhibitionFlg = YesNoConstant.TYPE_NO;
	/** 値取得の失敗時のジョブ呼び出し失敗時重要度 @since 2.1.0 */
	protected int m_failureJobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
	
	/** 新規作成ユーザ @since 2.1.0 */
	protected String m_regUser;
	/** 最終変更ユーザ @since 2.1.0 */
	protected String m_updateUser;
	
	
	public MonitorInfo() {
		super();
	}
	
	public MonitorInfo( String application,
			String calendarId,
			String description,
			String determinationId,
			String scope,
			String facilityId,
			int failurePriority,
			int jobRun,
			int monitorBlock,
			String monitorId,
			String monitorTypeId,
			int monitorType,
			String notifyId,
			Timestamp regDate,
			String regUser,
			int runInterval,
			int timeout,
			String failureMessageId, 
			String failureMessage,
			Integer failureJobRun,
			String failureJobId,
			Integer failureJobInhibitionFlg,
			Integer failureJobFailurePriority,
			Timestamp updateDate,
			String updateUser,
			int valid,
			java.util.ArrayList judgementInfo,
			MonitorCheckInfo checkInfo)
	{
		setApplication(application);
		setCalendarId(calendarId);
		setDescription(description);
		setDeterminationId(determinationId);
		setScope(scope);
		setFacilityId(facilityId);
		setFailurePriority(failurePriority);
		setJobRun(jobRun);
		setMonitorBlock(monitorBlock);
		setMonitorId(monitorId);
		setMonitorTypeId(monitorTypeId);
		setMonitorType(monitorType);
		setNotifyId(notifyId);
		setRegDate(regDate);
		setRegUser(regUser);
		setRunInterval(runInterval);
		setTimeout(timeout);
		setFailureMessageId(failureMessageId);
		setFailureMessage(failureMessage);
		setFailureJobRun(failureJobRun);
		setFailureJobId(failureJobId);
		setFailureJobInhibitionFlg(failureJobInhibitionFlg);
		setFailureJobFailurePriority(failureJobFailurePriority);
		setUpdateDate(updateDate);
		setUpdateUser(updateUser);
		setValid(valid);
		setJudgementInfo(judgementInfo);
		setCheckInfo(checkInfo);
	}
	
	public MonitorInfo( MonitorInfo otherData )
	{
		setApplication(otherData.getApplication());
		setCalendarId(otherData.getCalendarId());
		setDescription(otherData.getDescription());
		setDeterminationId(otherData.getDeterminationId());
		setScope(otherData.getScope());
		setFacilityId(otherData.getFacilityId());
		setFailurePriority(otherData.getFailurePriority());
		setJobRun(otherData.getJobRun());
		setMonitorBlock(otherData.getMonitorBlock());
		setMonitorId(otherData.getMonitorId());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setMonitorType(otherData.getMonitorType());
		setNotifyId(otherData.getNotifyId());
		setRegDate(otherData.getRegDate());
		setRegUser(otherData.getRegUser());
		setRunInterval(otherData.getRunInterval());
		setFailureMessageId(otherData.getFailureMessageId());
		setFailureMessage(otherData.getFailureMessage());
		setFailureJobRun(otherData.getFailureJobRun());
		setFailureJobId(otherData.getFailureJobId());
		setFailureJobInhibitionFlg(otherData.getFailureJobInhibitionFlg());
		setFailureJobFailurePriority(otherData.getFailureJobFailurePriority());
		setUpdateDate(otherData.getUpdateDate());
		setUpdateUser(otherData.getUpdateUser());
		setValid(otherData.getValid());
		setJudgementInfo(otherData.getJudgementInfo());
		setCheckInfo(otherData.getCheckInfo());
	}
	
	public String getApplication()
	{
		return this.m_application;
	}
	public void setApplication( String application )
	{
		this.m_application = application;
	}
	
	public String getCalendarId()
	{
		return this.m_calendarId;
	}
	public void setCalendarId( String calendarId )
	{
		this.m_calendarId = calendarId;
	}
	
	public String getDescription()
	{
		return this.m_description;
	}
	public void setDescription( String description )
	{
		this.m_description = description;
	}
	
	public String getDeterminationId()
	{
		return this.m_determinationId;
	}
	public void setDeterminationId( String determinationId )
	{
		this.m_determinationId = determinationId;
	}
	
	public String getFacilityId()
	{
		return this.m_facilityId;
	}
	public void setFacilityId( String facilityId )
	{
		this.m_facilityId = facilityId;
	}
	
	public int getFailurePriority()
	{
		return this.m_failurePriority;
	}
	public void setFailurePriority( int failurePriority )
	{
		this.m_failurePriority = failurePriority;
	}
	
	public int getMonitorBlock()
	{
		return this.m_monitorBlock;
	}
	public void setMonitorBlock( int monitorBlock )
	{
		this.m_monitorBlock = monitorBlock;
	}
	
	public String getMonitorId()
	{
		return this.m_monitorId;
	}
	public void setMonitorId( String monitorId )
	{
		this.m_monitorId = monitorId;
	}
	
	public String getMonitorTypeId()
	{
		return this.m_monitorTypeId;
	}
	public void setMonitorTypeId( String monitorTypeId )
	{
		this.m_monitorTypeId = monitorTypeId;
	}
	
	public String getNotifyId()
	{
		return this.m_notifyId;
	}
	public void setNotifyId( String notifyId )
	{
		this.m_notifyId = notifyId;
	}
	
	public Timestamp getRegDate()
	{
		return this.m_regDate;
	}
	public void setRegDate( Timestamp regDate )
	{
		this.m_regDate = regDate;
	}
	
	public int getRunInterval()
	{
		return this.m_runInterval;
	}
	public void setRunInterval( int runInterval )
	{
		this.m_runInterval = runInterval;
	}
	
	public String getScope() {
		return m_scope;
	}
	public void setScope(String scope) {
		this.m_scope = scope;
	}
	
	public Timestamp getUpdateDate()
	{
		return this.m_updateDate;
	}
	public void setUpdateDate( Timestamp updateDate )
	{
		this.m_updateDate = updateDate;
	}
	
	public int getValid() {
		return m_valid;
	}
	public void setValid(int valid) {
		this.m_valid = valid;
	}
	
	public java.util.ArrayList getJudgementInfo() {
		return this.m_judgementInfo;
	}
	
	public void setJudgementInfo(java.util.ArrayList judgementInfo) {
		this.m_judgementInfo = judgementInfo;
	}
	
	public MonitorCheckInfo getCheckInfo() {
		return this.m_checkInfo;
	}
	
	public void setCheckInfo(MonitorCheckInfo checkInfo) {
		this.m_checkInfo = checkInfo;
	}
	
	public String getRegUser() {
		return m_regUser;
	}
	
	public void setRegUser(String user) {
		m_regUser = user;
	}
	
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	public void setUpdateUser(String user) {
		m_updateUser = user;
	}
	
	public int getJobRun() {
		return m_jobRun;
	}
	
	public void setJobRun(int run) {
		m_jobRun = run;
	}
	
	public int getFailureJobFailurePriority() {
		return m_failureJobFailurePriority;
	}
	public void setFailureJobFailurePriority(int jobFailurePriority) {
		m_failureJobFailurePriority = jobFailurePriority;
	}

	public String getFailureJobId() {
		return m_failureJobId;
	}
	public void setFailureJobId(String jobId) {
		m_failureJobId = jobId;
	}

	public int getFailureJobInhibitionFlg() {
		return m_failureJobInhibitionFlg;
	}
	public void setFailureJobInhibitionFlg(int jobInhibitionFlg) {
		m_failureJobInhibitionFlg = jobInhibitionFlg;
	}

	public int getFailureJobRun() {
		return m_failureJobRun;
	}
	public void setFailureJobRun(int jobRun) {
		m_failureJobRun = jobRun;
	}

	public String getFailureMessage() {
		return m_failureMessage;
	}
	public void setFailureMessage(String message) {
		m_failureMessage = message;
	}

	public String getFailureMessageId() {
		return m_failureMessageId;
	}
	public void setFailureMessageId(String messageId) {
		m_failureMessageId = messageId;
	}
	
	public int getMonitorType() {
		return m_monitorType;
	}
	
	public void setMonitorType(int type) {
		m_monitorType = type;
	}

	public int getTimeout() {
		return m_timeout;
	}
	public void setTimeout(int m_timeout) {
		this.m_timeout = m_timeout;
	}
}
