/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * ステータス期限切れ制御定数クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusExpirationConstant {
	
    /** 有効期限切れ(ステータス情報の状態の種別) */
    public static final int TYPE_EXPIRATION = 10;

    /** 削除(削除/更新の種別) */
    public static final int TYPE_DELETE = 11;
	
    /** 更新(削除/更新の種別) */
    public static final int TYPE_UPDATE = 12;
    
    /** 危険(重要度の種別) */
    public static final int TYPE_CRITICAL = PriorityConstant.TYPE_CRITICAL;

    /** 警告(重要度の種別) */
    public static final int TYPE_WARNING = PriorityConstant.TYPE_WARNING;

    /** 通知(重要度の種別) */
    public static final int TYPE_INFO = PriorityConstant.TYPE_INFO;

    /** 不明(重要度の種別) */
    public static final int TYPE_UNKNOWN = PriorityConstant.TYPE_UNKNOWN;

    /** なし(重要度の種別) */
    public static final int TYPE_NONE = PriorityConstant.TYPE_NONE;

    /** 有効期限切れ(ステータス情報の状態の種別) */
    public static final String STRING_EXPIRATION = Messages.getString("expiration");

    /** 削除(削除/更新の種別) */
    public static final String STRING_DELETE = Messages.getString("delete");

    /** 更新(削除/更新の種別) */
    public static final String STRING_UPDATE = Messages.getString("update");
    
    /** 危険(重要度の種別) */
    public static final String STRING_CRITICAL = PriorityConstant.STRING_CRITICAL;

    /** 警告(重要度の種別) */
    public static final String STRING_WARNING = PriorityConstant.STRING_WARNING;

    /** 通知(重要度の種別) */
    public static final String STRING_INFO = PriorityConstant.STRING_INFO;

    /** 不明(重要度の種別) */
    public static final String STRING_UNKNOWN = PriorityConstant.STRING_UNKNOWN;

    /** なし(重要度の種別) */
    public static final String STRING_NONE =  PriorityConstant.STRING_NONE;
    

    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_DELETE) {
            return STRING_DELETE;
        } else if (type == TYPE_UPDATE) {
            return STRING_UPDATE;
        }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_DELETE)) {
            return TYPE_DELETE;
        } else if (string.equals(STRING_UPDATE)) {
            return TYPE_UPDATE;
        }
        return -1;
    }
}