/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 確認/未確認定数クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventConfirmConstant {
    /** 確認 */
    public static final int TYPE_CONFIRMED = ConfirmConstant.TYPE_CONFIRMED;

    /** 未確認 */
    public static final int TYPE_UNCONFIRMED = ConfirmConstant.TYPE_UNCONFIRMED;
    
    /** 破棄 */
    public static final int TYPE_DESTRUCTION = 2;

    /** 確認 */
    public static final String STRING_CONFIRMED = Messages
            .getString("notify.event.confirmed");

    /** 未確認 */
    public static final String STRING_UNCONFIRMED = Messages
            .getString("notify.event.unconfirmed");
    
    /** 破棄 */
    public static final String STRING_DESTRUCTION = Messages
            .getString("notify.event.destruction");

    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_CONFIRMED) {
            return STRING_CONFIRMED;
        } else if (type == TYPE_UNCONFIRMED) {
            return STRING_UNCONFIRMED;
	    } else if (type == TYPE_DESTRUCTION) {
	        return STRING_DESTRUCTION;
	    }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_CONFIRMED)) {
            return TYPE_CONFIRMED;
        } else if (string.equals(STRING_UNCONFIRMED)) {
            return TYPE_UNCONFIRMED;
        } else if (string.equals(STRING_DESTRUCTION)) {
            return TYPE_DESTRUCTION;
        }
        return -1;
    }

}