/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util.apllog;

import java.io.Serializable;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Queue送信クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SendQueue {
    protected String m_queueName;
	static Log log = LogFactory.getLog(SendQueue.class);
    
    /**
     * コンストラクタ
     * 
     * @param queueName
     * @throws NamingException
     * @throws JMSException
     */
    public SendQueue(String queueName){
        m_queueName = queueName;
    }
    
    /**
     * メッセージ送信処理
     * 
     * @param info
     * @throws JMSException
     * @throws NamingException
     */
    public boolean put(Serializable info) {
        //Queueへ送信の初期化処理

        QueueSender sender = null;
        QueueSession session = null;
        QueueConnection connection = null;
        InitialContext context = null;

        try {
            context = new InitialContext();
            QueueConnectionFactory connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            connection = connectionFactory.createQueueConnection();
            session = connection.createQueueSession( false, Session.AUTO_ACKNOWLEDGE );
            Queue queue = (Queue)context.lookup(m_queueName);


            sender = session.createSender(queue);
            
            //送信メッセージ作成
            ObjectMessage message = session.createObjectMessage(info);
            
            //メッセージ送信
            sender.send(message);

        } catch (Exception e) {
            log.error(e);
            return false;
        }finally{
            //後処理
            try {
                if(sender != null){ 
                    sender.close();
                }
            } catch (JMSException e) {}
	        try {
                if(session != null){ 
                    session.close();
                }
            } catch (JMSException e) {}
	        try {
                if(connection != null){ 
                    connection.close();
                }
            } catch (JMSException e) {}
	        try {
                if(context != null){ 
                    context.close();
                }
            } catch (NamingException e) {}
        }
        
        return true;
    }
    

}
