/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.util.Locale;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * ユーザフィルタ用プロパティ作成クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class UserFilterProperty extends RoleConstant{
	/** UID */
	public static final String UID = "uid";
	/** 名前 */
	public static final String NAME = "namae";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	
	/** アクセス権限 */
	public static final String ACCESS = "access";

	/**
	 * ノードフィルタ用プロパティを返します。
	 * 
	 * @param local
	 * @return ノードフィルタ用プロパティ
	 */
	public Property getProperty(Locale local) {
	    //UID
		Property uid =
			new Property(UID, Messages.getString("user.id", local), PropertyConstant.EDITOR_TEXT);
		//名前
		Property name =
			new Property(NAME, Messages.getString("name", local), PropertyConstant.EDITOR_TEXT);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", local), PropertyConstant.EDITOR_TEXT);
		
		//アクセス権限
		Property access =
			new Property(ACCESS, Messages.getString("access.permission", local), PropertyConstant.EDITOR_TEXT);
		//リポジトリ参照
		Property repositoryRead =
			new Property(REPOSITORY_READ, Messages.getString("repository.read", local), PropertyConstant.EDITOR_BOOL);
		//リポジトリ設定
		Property repositoryWrite =
			new Property(REPOSITORY_WRITE, Messages.getString("repository.write", local), PropertyConstant.EDITOR_BOOL);
		//アクセス参照
		Property accessRead =
			new Property(ACCESSCONTROL_READ, Messages.getString("accesscontrol.read", local), PropertyConstant.EDITOR_BOOL);
		//アクセス設定
		Property accessWrite =
			new Property(ACCESSCONTROL_WRITE, Messages.getString("accesscontrol.write", local), PropertyConstant.EDITOR_BOOL);
		//状態監視参照
		Property monitorRead =
			new Property(MONITOR_READ, Messages.getString("monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//状態監視設定
		Property monitorWrite =
			new Property(MONITOR_WRITE, Messages.getString("monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ジョブ管理参照
		Property jobManagementRead =
			new Property(JOBMANAGEMENT_READ, Messages.getString("jobmanagement.read", local), PropertyConstant.EDITOR_BOOL);
		//ジョブ設定
		Property jobManagementWrite =
			new Property(JOBMANAGEMENT_WRITE, Messages.getString("jobmanagement.write", local), PropertyConstant.EDITOR_BOOL);
		//ジョブ実行
		Property jobManagementExecute =
			new Property(JOBMANAGEMENT_EXECUTE, Messages.getString("jobmanagement.execute", local), PropertyConstant.EDITOR_BOOL);
		//性能管理参照
		Property performanceRead =
			new Property(PERFORMANCE_READ, Messages.getString("performance.read", local), PropertyConstant.EDITOR_BOOL);
		//性能管理設定
		Property performanceWrite =
			new Property(PERFORMANCE_WRITE, Messages.getString("performance.write", local), PropertyConstant.EDITOR_BOOL);
		//性能管理実行
		Property performanceExecute =
			new Property(PERFORMANCE_EXECUTE, Messages.getString("performance.execute", local), PropertyConstant.EDITOR_BOOL);
		//一括制御参照
		Property collectiverunRead =
			new Property(COLLECTIVERUN_READ, Messages.getString("collectiverun.read", local), PropertyConstant.EDITOR_BOOL);
		//一括制御設定
		Property collectiverunWrite =
			new Property(COLLECTIVERUN_WRITE, Messages.getString("collectiverun.write", local), PropertyConstant.EDITOR_BOOL);
		//一括制御実行
		Property collectiverunExecute =
			new Property(COLLECTIVERUN_EXECUTE, Messages.getString("collectiverun.execute", local), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視参照
		Property syslogngMonitorRead =
			new Property(SYSLOGNG_MONITOR_READ, Messages.getString("syslogng.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視設定
		Property syslogngMonitorWrite =
			new Property(SYSLOGNG_MONITOR_WRITE, Messages.getString("syslogng.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//Ping監視参照
		Property pingMonitorRead =
			new Property(PING_MONITOR_READ, Messages.getString("ping.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//Ping監視設定
		Property pingMonitorWrite =
			new Property(PING_MONITOR_WRITE, Messages.getString("ping.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//プロセス監視参照
		Property processMonitorRead =
			new Property(PROCESS_MONITOR_READ, Messages.getString("process.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//プロセス監視設定
		Property processMonitorWrite =
			new Property(PROCESS_MONITOR_WRITE, Messages.getString("process.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SNMP監視参照
		Property snmpMonitorRead =
			new Property(SNMP_MONITOR_READ, Messages.getString("snmp.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SNMP監視設定
		Property snmpMonitorWrite =
			new Property(SNMP_MONITOR_WRITE, Messages.getString("snmp.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視参照
		Property snmptrapMonitorRead =
			new Property(SNMPTRAP_MONITOR_READ, Messages.getString("snmptrap.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視設定
		Property snmptrapMonitorWrite =
			new Property(SNMPTRAP_MONITOR_WRITE, Messages.getString("snmptrap.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//SQL監視参照
		Property sqlMonitorRead =
			new Property(SQL_MONITOR_READ, Messages.getString("sql.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//SQL監視設定
		Property sqlMonitorWrite =
			new Property(SQL_MONITOR_WRITE, Messages.getString("sql.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//エージェント監視参照
		Property agentMonitorRead =
			new Property(AGENT_MONITOR_READ, Messages.getString("agent.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//エージェント監視設定
		Property agentMonitorWrite =
			new Property(AGENT_MONITOR_WRITE, Messages.getString("agent.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//HTTP監視参照
		Property httpMonitorRead =
			new Property(HTTP_MONITOR_READ, Messages.getString("http.monitor.read", local), PropertyConstant.EDITOR_BOOL);
		//HTTP監視設定
		Property httpMonitorWrite =
			new Property(HTTP_MONITOR_WRITE, Messages.getString("http.monitor.write", local), PropertyConstant.EDITOR_BOOL);
		//ログ転送参照
		Property logTransferRead =
			new Property(LOG_TRANSFER_READ, Messages.getString("logtransfer.read", local), PropertyConstant.EDITOR_BOOL);
		//ログ転送設定
		Property logTransferWrite =
			new Property(LOG_TRANSFER_WRITE, Messages.getString("logtransfer.write", local), PropertyConstant.EDITOR_BOOL);
		//カレンダ参照
		Property calendarRead =
			new Property(CALENDAR_READ, Messages.getString("calendar.read", local), PropertyConstant.EDITOR_BOOL);
		//カレンダ設定
		Property calendarWrite =
			new Property(CALENDAR_WRITE, Messages.getString("calendar.write", local), PropertyConstant.EDITOR_BOOL);
		//通知参照
		Property notifyRead =
			new Property(NOTIFY_READ, Messages.getString("notify.id.read", local), PropertyConstant.EDITOR_BOOL);
		//通知設定
		Property notifyWrite =
			new Property(NOTIFY_WRITE, Messages.getString("notify.id.write", local), PropertyConstant.EDITOR_BOOL);
		//重要度判定参照
		Property priorityJudgmentRead =
			new Property(PRIORITY_JUDGMENT_READ, Messages.getString("priority.judgment.read", local), PropertyConstant.EDITOR_BOOL);
		//重要度判定設定
		Property priorityJudgmentWrite =
			new Property(PRIORITY_JUDGMENT_WRITE, Messages.getString("priority.judgment.write", local), PropertyConstant.EDITOR_BOOL);
		//障害検知参照
		Property troubleDetectionRead =
			new Property(TROUBLE_DETECTION_READ, Messages.getString("trouble.detection.read", local), PropertyConstant.EDITOR_BOOL);
		//障害検知設定
		Property troubleDetectionWrite =
			new Property(TROUBLE_DETECTION_WRITE, Messages.getString("trouble.detection.write", local), PropertyConstant.EDITOR_BOOL);
		
		
		//値を初期化
		uid.setValue("");
		name.setValue("");
		description.setValue("");
		
		access.setValue("");
		repositoryRead.setValue(new Boolean(false));
		repositoryWrite.setValue(new Boolean(false));
		accessRead.setValue(new Boolean(false));
		accessWrite.setValue(new Boolean(false));
		monitorRead.setValue(new Boolean(false));
		monitorWrite.setValue(new Boolean(false));
		jobManagementRead.setValue(new Boolean(false));
		jobManagementWrite.setValue(new Boolean(false));
		jobManagementExecute.setValue(new Boolean(false));
		performanceRead.setValue(new Boolean(false));
		performanceWrite.setValue(new Boolean(false));
		performanceExecute.setValue(new Boolean(false));
		collectiverunRead.setValue(new Boolean(false));
		collectiverunWrite.setValue(new Boolean(false));
		collectiverunExecute.setValue(new Boolean(false));
		syslogngMonitorRead.setValue(new Boolean(false));
		syslogngMonitorWrite.setValue(new Boolean(false));
		pingMonitorRead.setValue(new Boolean(false));
		pingMonitorWrite.setValue(new Boolean(false));
		processMonitorRead.setValue(new Boolean(false));
		processMonitorWrite.setValue(new Boolean(false));
		snmpMonitorRead.setValue(new Boolean(false));
		snmpMonitorWrite.setValue(new Boolean(false));
		snmptrapMonitorRead.setValue(new Boolean(false));
		snmptrapMonitorWrite.setValue(new Boolean(false));
		sqlMonitorRead.setValue(new Boolean(false));
		sqlMonitorWrite.setValue(new Boolean(false));
		agentMonitorRead.setValue(new Boolean(false));
		agentMonitorWrite.setValue(new Boolean(false));
		httpMonitorRead.setValue(new Boolean(false));
		httpMonitorWrite.setValue(new Boolean(false));
		logTransferRead.setValue(new Boolean(false));
		logTransferWrite.setValue(new Boolean(false));
		calendarRead.setValue(new Boolean(false));
		calendarWrite.setValue(new Boolean(false));
		notifyRead.setValue(new Boolean(false));
		notifyWrite.setValue(new Boolean(false));
		priorityJudgmentRead.setValue(new Boolean(false));
		priorityJudgmentWrite.setValue(new Boolean(false));
		troubleDetectionRead.setValue(new Boolean(false));
		troubleDetectionWrite.setValue(new Boolean(false));
		
		//変更可及びコピー可を設定
		uid.setModify(PropertyConstant.MODIFY_OK);
		name.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		repositoryRead.setModify(PropertyConstant.MODIFY_OK);
		repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
		accessRead.setModify(PropertyConstant.MODIFY_OK);
		accessWrite.setModify(PropertyConstant.MODIFY_OK);
		monitorRead.setModify(PropertyConstant.MODIFY_OK);
		monitorWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
		jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		performanceRead.setModify(PropertyConstant.MODIFY_OK);
		performanceWrite.setModify(PropertyConstant.MODIFY_OK);
		performanceExecute.setModify(PropertyConstant.MODIFY_OK);
		collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
		collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
		collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
		syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		logTransferRead.setModify(PropertyConstant.MODIFY_OK);
		logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
		calendarRead.setModify(PropertyConstant.MODIFY_OK);
		calendarWrite.setModify(PropertyConstant.MODIFY_OK);
		notifyRead.setModify(PropertyConstant.MODIFY_OK);
		notifyWrite.setModify(PropertyConstant.MODIFY_OK);
		priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
		priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
		troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
		troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(access);
		
		// アクセス権限ツリー
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorRead);
		access.addChildren(monitorWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceWrite);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(syslogngMonitorRead);
		access.addChildren(syslogngMonitorWrite);
		access.addChildren(pingMonitorRead);
		access.addChildren(pingMonitorWrite);
		access.addChildren(processMonitorRead);
		access.addChildren(processMonitorWrite);
		access.addChildren(snmpMonitorRead);
		access.addChildren(snmpMonitorWrite);
		access.addChildren(snmptrapMonitorRead);
		access.addChildren(snmptrapMonitorWrite);
		access.addChildren(sqlMonitorRead);
		access.addChildren(sqlMonitorWrite);
		access.addChildren(agentMonitorRead);
		access.addChildren(agentMonitorWrite);
		access.addChildren(httpMonitorRead);
		access.addChildren(httpMonitorWrite);
		access.addChildren(logTransferRead);
		access.addChildren(logTransferWrite);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(priorityJudgmentRead);
		access.addChildren(priorityJudgmentWrite);
		
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			access.addChildren(troubleDetectionRead);
			access.addChildren(troubleDetectionWrite);
		}
		
		return property;
	}
}
