/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.ejb.entity.AccessLockLocal;
import com.clustercontrol.accesscontrol.ejb.entity.AccessLockUtil;

/**
 * アクセスロッククラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class AccessLock {
	protected static Log m_log = LogFactory.getLog(AccessLock.class);
	protected static String m_message = null;
	
	public static final String ACCESS = "ACCESS";
	public static final String CALENDER = "CALENDER";
	public static final String CRUN = "CRUN";
	public static final String JOB = "JOB";
	public static final String MONITOR = "MONITOR";
	public static final String MONITOR_AGENT = "MONITOR_AGENT";
	public static final String MONITOR_PING = "MONITOR_PING";
	public static final String MONITOR_PROCESS = "MONITOR_PROCESS";
	public static final String MONITOR_SNMP = "MONITOR_SNMP";
	public static final String MONITOR_SQL = "MONITOR_SQL";
	public static final String MONITOR_SYSLOG = "MONITOR_SYSLOG";
	public static final String NOTIFY = "NOTIFY";
	public static final String PERFORMANCE = "PERFORMANCE";
	public static final String REPOSITORY = "REPOSITORY";
	public static final String PRIORITY_JUDGMENT = "PRIORITY_JUDGMENT";
	public static final String LOG_TRANSFER = "LOG_TRANSFER";
	public static final String MONITOR_SNMPTRAP = "MONITOR_SNMPTRAP";
	
	public AccessLock(){
		if(m_message == null){
			try {
			    Properties properties = new Properties();
				String homedir = System.getProperty("jboss.server.home.dir");
				String propertyFile = homedir + File.separator + "conf" + File.separator + "forest.properties";
				
				// プロパティファイルからキーと値のリストを読み込みます
				properties.load(new FileInputStream(propertyFile));
				
				m_message = properties.getProperty("lock.timeout.message", ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*");

			} catch (Exception e) {
				m_message = ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*";
			}
		}
	}
	
    /**
     * ロック
     * 
     * @param id
     * @return
     * @throws NamingException
     * @throws FinderException
     */
    public static AccessLockLocal lock(String id) {
    	AccessLockLocal acc = null;
    	while(true){
	    	try {
				acc = AccessLockUtil.getLocalHome().findByLockIdForUpdate(id);
				break;
			} catch (FinderException e) {
				String msg = e.getMessage();
				if(msg != null && msg.matches(m_message)){
					m_log.debug("lock() : Lock Timeout");
				}
				else{
					m_log.debug("lock() : " + e.getMessage());
					break;
				}
			} catch (NamingException e) {
				m_log.debug("lock() : " + e.getMessage());
				break;
			}
    	}
    	return acc;
    }
}
