/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.accesscontrol.bean.UserListTableDefine;
import com.clustercontrol.accesscontrol.factory.ModifyUser;
import com.clustercontrol.accesscontrol.factory.SelectUser;
import com.clustercontrol.accesscontrol.factory.UserFilterProperty;
import com.clustercontrol.accesscontrol.factory.UserProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="AccessController"	
 *           jndi-name="AccessController"
 *           type="Stateless" 
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *     
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class AccessControllerBean implements javax.ejb.SessionBean {
	protected static Log m_log = LogFactory.getLog( AccessControllerBean.class ); 
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public static final int ALL = 0;
	public static final int ONE_LEVEL = 1;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * ユーザ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getUserListTableDefine(Locale local) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(UserListTableDefine.UID, 
				new TableColumnInfo(Messages.getString("user.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(UserListTableDefine.NAME, 
				new TableColumnInfo(Messages.getString("name", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(UserListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(UserListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(UserListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(UserListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(UserListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", local), TableColumnInfo.NONE, 100, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ユーザ一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="AccessControlRead"
     *     method-intf="Remote"
     *     
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getUserList() throws FinderException, NamingException {

		//ファシリティツリーを取得
		SelectUser select = new SelectUser();
		ArrayList list = select.getUserList();

		return list;
	}
	
	/**
	 * ユーザ一覧取得
	 * 
	 * Propertyの検索条件に該当するユーザ一覧を取得する
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlRead"
     *     method-intf="Remote"
     *     
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param property
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getUserList(Property property) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectUser select = new SelectUser();
		ArrayList list = select.getUserList(property);

		return list;
	}
	
	/**
	 * ユーザフィルタ用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlRead"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param local
	 * @return
	 */
	public Property getUserFilterProperty(Locale local) {
		UserFilterProperty user = new UserFilterProperty();
		return user.getProperty(local);
	}
	
	/**
	 * ユーザ用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlRead"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param uid
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getUserProperty(String uid, int mode, Locale local) throws FinderException, NamingException {
		UserProperty user = new UserProperty();
		return user.getProperty(uid, mode, local);
	}
	
	/**
	 * ユーザ追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 * @throws ParseException
	 */
	public void addUser(Property property) throws NamingException, CreateException, FinderException, ParseException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyUser modify = new ModifyUser();
		modify.addUser(property, pri.getName());
	}
	
	/**
	 * ユーザ変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public void modifyUser(Property property) throws NamingException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyUser modify = new ModifyUser();
		modify.modifyUser(property, pri.getName());
	}
	
	/**
	 * ユーザ削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteUser(String uid) throws NamingException, RemoveException, FinderException  {
		ModifyUser modify = new ModifyUser();
		modify.deleteUser(uid);
	}
	
	/**
	 * パスワード変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AccessControlWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @param uid
	 * @param password
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void changePassword(String uid, String password) throws NamingException, RemoveException, FinderException  {
		ModifyUser modify = new ModifyUser();
		modify.modifyPassword(uid, password);
	}
	
	/**
	 * パスワード変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @version 2.1.0
	 * @since 2.0.0
	 * 
	 * @param roleName
	 * @return
	 * @throws NamingException
	 */
	public boolean isPermission(String roleName) throws NamingException {
		return m_context.isCallerInRole(roleName);
	}
	
	/**
	 * ユーザ名取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @version 2.1.0
	 * @since 2.0.0
	 * 
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public String getUserName() throws NamingException, FinderException {
		
		Principal pri = m_context.getCallerPrincipal();
		
		SelectUser select = new SelectUser();
		return select.getUserName(pri.getName());
	}
}
