/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.entity;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>FacilityBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="User"
 *	jndi-name="User"
 *	type="BMP"
 *
 * @ejb.dao class="com.clustercontrol.accesscontrol.dao.UserDAO"
 * impl-class="com.clustercontrol.accesscontrol.dao.UserDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * <!-- end-xdoclet-defintion -->
 * @generated
 **/
public abstract class UserBean implements javax.ejb.EntityBean {
	public String dn;
	public String uid;
	public String cn;
	public String sn;
	public String password;
	public String description;
	public String creatorsName;
	public Date createTimestamp;
	public String modifiersName;
	public Date modifyTimestamp;
	
	/**
	 * @ejb.persistence
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return Returns the dn.
	 */
	public String getDn() {
		return dn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param dn The dn to set.
	 */
	public void setDn(String dn) {
		this.dn = dn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the uid.
	 */
	public String getUid() {
		return uid;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param uid The uid to set.
	 */
	public void setUid(String uid) {
		this.uid = uid;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the cn.
	 */
	public String getCn() {
		return cn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param cn The cn to set.
	 */
	public void setCn(String cn) {
		this.cn = cn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the sn.
	 */
	public String getSn() {
		return sn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param sn The sn to set.
	 */
	public void setSn(String sn) {
		this.sn = sn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the createTimestamp.
	 */
	public Date getCreateTimestamp() {
		return createTimestamp;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param createTimestamp The createTimestamp to set.
	 */
	public void setCreateTimestamp(Date createTimestamp) {
		this.createTimestamp = createTimestamp;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the creatorsName.
	 */
	public String getCreatorsName() {
		return creatorsName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param creatorsName The creatorsName to set.
	 */
	public void setCreatorsName(String creatorsName) {
		this.creatorsName = creatorsName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the modifiersName.
	 */
	public String getModifiersName() {
		return modifiersName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param modifiersName The modifiersName to set.
	 */
	public void setModifiersName(String modifiersName) {
		this.modifiersName = modifiersName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the modifyTimestamp.
	 */
	public Date getModifyTimestamp() {
		return modifyTimestamp;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param modifyTimestamp The modifyTimestamp to set.
	 */
	public void setModifyTimestamp(Date modifyTimestamp) {
		this.modifyTimestamp = modifyTimestamp;
	}
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public UserPK ejbCreate(String uid) throws javax.ejb.CreateException {
		setUid(uid);
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {

	}

	public UserPK ejbFindByPrimaryKey(UserPK pk) throws FinderException {
		return null;
	}
	
	public UserPK ejbFindByUid(String uid) throws FinderException {
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindUser(
			String uid, 
			String name, 
			String description, 
			List accessList) throws FinderException{ 
		return null; 
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public Collection getRoles() throws FinderException{ 
		Collection collection = null;
		try {
			collection = RoleUtil.getLocalHome().findByMember(getDn());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
}
