/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.jfree.chart.plot.PlotOrientation;

public class JRXmlWriter {
    private JRReport report = null;
    private String encoding = null;
    private JRXmlWriteHelper writer;
    private Map fontsMap = new HashMap();
    private Map stylesMap = new HashMap();
    static /* synthetic */ Class class$org$jfree$data$time$Day;

    protected JRXmlWriter(JRReport report, String encoding) {
        this.report = report;
        this.encoding = encoding;
    }

    public static String writeReport(JRReport report, String encoding) {
        JRXmlWriter writer = new JRXmlWriter(report, encoding);
        StringWriter buffer = new StringWriter();
        try {
            writer.writeReport(buffer);
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error writing report design.", e);
        }
        return buffer.toString();
    }

    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFileName);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            JRXmlWriter writer = new JRXmlWriter(report, encoding);
            writer.writeReport(out);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            JRXmlWriter writer = new JRXmlWriter(report, encoding);
            writer.writeReport(out);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    protected void writeReport(Writer out) throws IOException {
        JRDataset[] datasets;
        JRStyle[] styles;
        JRReportFont[] fonts;
        this.writer = new JRXmlWriteHelper(out);
        this.writer.writeProlog(this.encoding);
        this.writer.writePublicDoctype("jasperReport", "-//JasperReports//DTD Report Design//EN", "http://jasperreports.sourceforge.net/dtds/jasperreport.dtd");
        this.writer.startElement("jasperReport");
        this.writer.addAttribute("name", this.report.getName());
        this.writer.addAttribute("language", this.report.getLanguage(), "java");
        this.writer.addAttribute("columnCount", this.report.getColumnCount(), 1);
        this.writer.addAttribute("printOrder", this.report.getPrintOrder(), JRXmlConstants.getPrintOrderMap(), (byte)1);
        this.writer.addAttribute("pageWidth", this.report.getPageWidth());
        this.writer.addAttribute("pageHeight", this.report.getPageHeight());
        this.writer.addAttribute("orientation", this.report.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.writer.addAttribute("whenNoDataType", this.report.getWhenNoDataType(), JRXmlConstants.getWhenNoDataTypeMap(), (byte)1);
        this.writer.addAttribute("columnWidth", this.report.getColumnWidth());
        this.writer.addAttribute("columnSpacing", this.report.getColumnSpacing(), 0);
        this.writer.addAttribute("leftMargin", this.report.getLeftMargin());
        this.writer.addAttribute("rightMargin", this.report.getRightMargin());
        this.writer.addAttribute("topMargin", this.report.getTopMargin());
        this.writer.addAttribute("bottomMargin", this.report.getBottomMargin());
        this.writer.addAttribute("isTitleNewPage", this.report.isTitleNewPage(), false);
        this.writer.addAttribute("isSummaryNewPage", this.report.isSummaryNewPage(), false);
        this.writer.addAttribute("isFloatColumnFooter", this.report.isFloatColumnFooter(), false);
        this.writer.addAttribute("scriptletClass", this.report.getScriptletClass());
        this.writer.addAttribute("resourceBundle", this.report.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", this.report.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writer.addAttribute("isIgnorePagination", this.report.isIgnorePagination(), false);
        this.writeProperties(this.report.getPropertiesMap());
        String[] imports = this.report.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.writer.startElement("import");
                this.writer.addEncodedAttribute("value", value);
                this.writer.closeElement();
            }
        }
        if ((fonts = this.report.getFonts()) != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.writeReportFont(fonts[i]);
            }
        }
        if ((styles = this.report.getStyles()) != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.stylesMap.put(styles[i].getName(), styles[i]);
                this.writeStyle(styles[i]);
            }
        }
        if ((datasets = this.report.getDatasets()) != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                this.writeDataset(datasets[i]);
            }
        }
        this.writeDatasetContents(this.report.getMainDataset());
        if (this.report.getBackground() != null) {
            this.writer.startElement("background");
            this.writeBand(this.report.getBackground());
            this.writer.closeElement();
        }
        if (this.report.getTitle() != null) {
            this.writer.startElement("title");
            this.writeBand(this.report.getTitle());
            this.writer.closeElement();
        }
        if (this.report.getPageHeader() != null) {
            this.writer.startElement("pageHeader");
            this.writeBand(this.report.getPageHeader());
            this.writer.closeElement();
        }
        if (this.report.getColumnHeader() != null) {
            this.writer.startElement("columnHeader");
            this.writeBand(this.report.getColumnHeader());
            this.writer.closeElement();
        }
        if (this.report.getDetail() != null) {
            this.writer.startElement("detail");
            this.writeBand(this.report.getDetail());
            this.writer.closeElement();
        }
        if (this.report.getColumnFooter() != null) {
            this.writer.startElement("columnFooter");
            this.writeBand(this.report.getColumnFooter());
            this.writer.closeElement();
        }
        if (this.report.getPageFooter() != null) {
            this.writer.startElement("pageFooter");
            this.writeBand(this.report.getPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getLastPageFooter() != null) {
            this.writer.startElement("lastPageFooter");
            this.writeBand(this.report.getLastPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getSummary() != null) {
            this.writer.startElement("summary");
            this.writeBand(this.report.getSummary());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        out.flush();
    }

    private void writeProperties(JRPropertiesMap propertiesMap) throws IOException {
        String[] propertyNames = propertiesMap.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String value = propertiesMap.getProperty(propertyNames[i]);
                if (value == null) continue;
                this.writer.startElement("property");
                this.writer.addAttribute("name", propertyNames[i]);
                this.writer.addEncodedAttribute("value", value);
                this.writer.closeElement();
            }
        }
    }

    private void writeReportFont(JRReportFont font) throws IOException {
        this.writer.startElement("reportFont");
        this.writer.addAttribute("name", font.getName());
        this.writer.addAttribute("isDefault", font.isDefault());
        this.writer.addAttribute("fontName", font.getFontName());
        this.writer.addAttribute("size", font.getFontSize());
        this.writer.addAttribute("isBold", font.isBold());
        this.writer.addAttribute("isItalic", font.isItalic());
        this.writer.addAttribute("isUnderline", font.isUnderline());
        this.writer.addAttribute("isStrikeThrough", font.isStrikeThrough());
        this.writer.addAttribute("pdfFontName", font.getPdfFontName());
        this.writer.addAttribute("pdfEncoding", font.getPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", font.isPdfEmbedded());
        this.writer.closeElement();
    }

    private void writeStyle(JRStyle style) throws IOException {
        this.writer.startElement("style");
        this.writer.addAttribute("name", style.getName());
        this.writer.addAttribute("isDefault", style.isDefault());
        if (style.getStyle() != null) {
            JRStyle baseStyle = (JRStyle)this.stylesMap.get(style.getStyle().getName());
            if (baseStyle != null) {
                this.writer.addAttribute("style", style.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + style.getStyle().getName());
            }
        }
        this.writer.addAttribute("mode", style.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("forecolor", style.getOwnForecolor());
        this.writer.addAttribute("backcolor", style.getOwnBackcolor());
        this.writer.addAttribute("pen", style.getOwnPen(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("fill", style.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.addAttribute("radius", style.getOwnRadius());
        this.writer.addAttribute("scaleImage", style.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", style.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", style.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", style.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", style.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", style.isOwnStyledText());
        this.writer.addAttribute("pattern", style.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", style.isOwnBlankWhenNull());
        this.writer.addAttribute("border", style.getOwnBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("borderColor", style.getOwnBorderColor());
        this.writer.addAttribute("padding", style.getOwnPadding());
        this.writer.addAttribute("topBorder", style.getOwnTopBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("topBorderColor", style.getOwnTopBorderColor());
        this.writer.addAttribute("topPadding", style.getOwnTopPadding());
        this.writer.addAttribute("leftBorder", style.getOwnLeftBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("leftBorderColor", style.getOwnLeftBorderColor());
        this.writer.addAttribute("leftPadding", style.getOwnLeftPadding());
        this.writer.addAttribute("bottomBorder", style.getOwnBottomBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("bottomBorderColor", style.getOwnBottomBorderColor());
        this.writer.addAttribute("bottomPadding", style.getOwnBottomPadding());
        this.writer.addAttribute("rightBorder", style.getOwnRightBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("rightBorderColor", style.getOwnRightBorderColor());
        this.writer.addAttribute("rightPadding", style.getOwnRightPadding());
        this.writer.addAttribute("fontName", style.getOwnFontName());
        this.writer.addAttribute("fontSize", style.getOwnFontSize());
        this.writer.addAttribute("isBold", style.isOwnBold());
        this.writer.addAttribute("isItalic", style.isOwnItalic());
        this.writer.addAttribute("isUnderline", style.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.writer.addAttribute("pdfFontName", style.getOwnPdfFontName());
        this.writer.addAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (!(style instanceof JRConditionalStyle) && conditionalStyles != null) {
            for (int i = 0; i < conditionalStyles.length; ++i) {
                this.writeConditionalStyle(conditionalStyles[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeConditionalStyle(JRConditionalStyle style) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", style.getConditionExpression(), false);
        this.writeStyle(style);
        this.writer.closeElement();
    }

    private void writeParameter(JRParameter parameter) throws IOException {
        this.writer.startElement("parameter");
        this.writer.addAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName());
        this.writer.addAttribute("isForPrompting", parameter.isForPrompting(), true);
        this.writer.writeCDATAElement("parameterDescription", parameter.getDescription());
        this.writer.writeExpression("defaultValueExpression", parameter.getDefaultValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeQuery(JRQuery query) throws IOException {
        this.writer.startElement("queryString");
        this.writer.addAttribute("language", query.getLanguage(), "sql");
        this.writer.writeCDATA(query.getText());
        this.writer.closeElement();
    }

    private void writeField(JRField field) throws IOException {
        this.writer.startElement("field");
        this.writer.addAttribute("name", field.getName());
        this.writer.addAttribute("class", field.getValueClassName());
        this.writer.writeCDATAElement("fieldDescription", field.getDescription());
        this.writer.closeElement();
    }

    private void writeVariable(JRVariable variable) throws IOException {
        this.writer.startElement("variable");
        this.writer.addAttribute("name", variable.getName());
        this.writer.addAttribute("class", variable.getValueClassName());
        this.writer.addAttribute("resetType", variable.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (variable.getResetGroup() != null) {
            this.writer.addAttribute("resetGroup", variable.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", variable.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (variable.getIncrementGroup() != null) {
            this.writer.addAttribute("incrementGroup", variable.getIncrementGroup().getName());
        }
        this.writer.addAttribute("calculation", variable.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", variable.getIncrementerFactoryClassName());
        this.writer.writeExpression("variableExpression", variable.getExpression(), false);
        this.writer.writeExpression("initialValueExpression", variable.getInitialValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeGroup(JRGroup group) throws IOException {
        this.writer.startElement("group");
        this.writer.addAttribute("name", group.getName());
        this.writer.addAttribute("isStartNewColumn", group.isStartNewColumn(), false);
        this.writer.addAttribute("isStartNewPage", group.isStartNewPage(), false);
        this.writer.addAttribute("isResetPageNumber", group.isResetPageNumber(), false);
        this.writer.addAttribute("isReprintHeaderOnEachPage", group.isReprintHeaderOnEachPage(), false);
        this.writer.addAttributePositive("minHeightToStartNewPage", group.getMinHeightToStartNewPage());
        this.writer.writeExpression("groupExpression", group.getExpression(), false);
        if (group.getGroupHeader() != null) {
            this.writer.startElement("groupHeader");
            this.writeBand(group.getGroupHeader());
            this.writer.closeElement();
        }
        if (group.getGroupFooter() != null) {
            this.writer.startElement("groupFooter");
            this.writeBand(group.getGroupFooter());
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }

    private void writeBand(JRBand band) throws IOException {
        this.writer.startElement("band");
        this.writer.addAttributePositive("height", band.getHeight());
        this.writer.addAttribute("isSplitAllowed", band.isSplitAllowed(), true);
        this.writer.writeExpression("printWhenExpression", band.getPrintWhenExpression(), false);
        List children = band.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    public void writeElementGroup(JRElementGroup elementGroup) throws IOException {
        this.writer.startElement("elementGroup");
        List children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                JRChild child = (JRChild)children.get(i);
                child.writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    public void writeLine(JRLine line) throws IOException {
        this.writer.startElement("line");
        this.writer.addAttribute("direction", line.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.writeReportElement(line);
        this.writeGraphicElement(line);
        this.writer.closeElement();
    }

    private void writeReportElement(JRElement element) throws IOException {
        this.writer.startElement("reportElement");
        this.writer.addAttribute("key", element.getKey());
        JRStyle style = element.getStyle();
        if (style != null) {
            this.writer.addAttribute("style", style.getName());
        }
        this.writer.addAttribute("positionType", element.getPositionType(), JRXmlConstants.getPositionTypeMap(), (byte)2);
        this.writer.addAttribute("stretchType", element.getStretchType(), JRXmlConstants.getStretchTypeMap(), (byte)0);
        this.writer.addAttribute("isPrintRepeatedValues", element.isPrintRepeatedValues(), true);
        this.writer.addAttribute("mode", element.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("x", element.getX());
        this.writer.addAttribute("y", element.getY());
        this.writer.addAttribute("width", element.getWidth());
        this.writer.addAttribute("height", element.getHeight());
        this.writer.addAttribute("isRemoveLineWhenBlank", element.isRemoveLineWhenBlank(), false);
        this.writer.addAttribute("isPrintInFirstWholeBand", element.isPrintInFirstWholeBand(), false);
        this.writer.addAttribute("isPrintWhenDetailOverflows", element.isPrintWhenDetailOverflows(), false);
        if (element.getPrintWhenGroupChanges() != null) {
            this.writer.addAttribute("printWhenGroupChanges", element.getPrintWhenGroupChanges().getName());
        }
        this.writer.addAttribute("forecolor", element.getOwnForecolor());
        this.writer.addAttribute("backcolor", element.getOwnBackcolor());
        this.writer.writeExpression("printWhenExpression", element.getPrintWhenExpression(), false);
        this.writer.closeElement();
    }

    private void writeGraphicElement(JRGraphicElement element) throws IOException {
        this.writer.startElement("graphicElement");
        this.writer.addAttribute("pen", element.getOwnPen(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("fill", element.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.closeElement();
    }

    public void writeRectangle(JRRectangle rectangle) throws IOException {
        this.writer.startElement("rectangle");
        this.writer.addAttribute("radius", rectangle.getOwnRadius());
        this.writeReportElement(rectangle);
        this.writeGraphicElement(rectangle);
        this.writer.closeElement();
    }

    public void writeEllipse(JREllipse ellipse) throws IOException {
        this.writer.startElement("ellipse");
        this.writeReportElement(ellipse);
        this.writeGraphicElement(ellipse);
        this.writer.closeElement();
    }

    public void writeImage(JRImage image) throws IOException {
        this.writer.startElement("image");
        this.writer.addAttribute("scaleImage", image.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", image.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", image.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("isUsingCache", image.isOwnUsingCache());
        this.writer.addAttribute("isLazy", image.isLazy(), false);
        this.writer.addAttribute("onErrorType", image.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.writer.addAttribute("evaluationTime", image.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (image.getEvaluationGroup() != null) {
            this.writer.addAttribute("evaluationGroup", image.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("hyperlinkType", image.getHyperlinkType(), JRXmlConstants.getHyperlinkTypeMap(), (byte)1);
        this.writer.addAttribute("hyperlinkTarget", image.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.writeReportElement(image);
        this.writeBox(image);
        this.writeGraphicElement(image);
        this.writer.writeExpression("imageExpression", image.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", image.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", image.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", image.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", image.getHyperlinkPageExpression(), false);
        this.writer.closeElement();
    }

    private void writeBox(JRBox box) throws IOException {
        if (box != null) {
            this.writer.startElement("box");
            this.writer.addAttribute("border", box.getOwnBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("borderColor", box.getOwnBorderColor());
            this.writer.addAttribute("padding", box.getOwnPadding());
            this.writer.addAttribute("topBorder", box.getOwnTopBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("topBorderColor", box.getOwnTopBorderColor());
            this.writer.addAttribute("topPadding", box.getOwnTopPadding());
            this.writer.addAttribute("leftBorder", box.getOwnLeftBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("leftBorderColor", box.getOwnLeftBorderColor());
            this.writer.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.writer.addAttribute("bottomBorder", box.getOwnBottomBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("bottomBorderColor", box.getOwnBottomBorderColor());
            this.writer.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.writer.addAttribute("rightBorder", box.getOwnRightBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("rightBorderColor", box.getOwnRightBorderColor());
            this.writer.addAttribute("rightPadding", box.getOwnRightPadding());
            this.writer.closeElement(true);
        }
    }

    public void writeStaticText(JRStaticText staticText) throws IOException {
        this.writer.startElement("staticText");
        this.writeReportElement(staticText);
        this.writeBox(staticText);
        this.writeTextElement(staticText);
        this.writer.writeCDATAElement("text", staticText.getText());
        this.writer.closeElement();
    }

    private void writeTextElement(JRTextElement textElement) throws IOException {
        this.writer.startElement("textElement");
        this.writer.addAttribute("textAlignment", textElement.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("verticalAlignment", textElement.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", textElement.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", textElement.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", textElement.isOwnStyledText());
        this.writeFont(textElement);
        this.writer.closeElement();
    }

    private void writeFont(JRFont font) throws IOException {
        if (font != null) {
            this.writer.startElement("font");
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    this.writer.addAttribute("reportFont", font.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            this.writer.addAttribute("fontName", font.getOwnFontName());
            this.writer.addAttribute("size", font.getOwnFontSize());
            this.writer.addAttribute("isBold", font.isOwnBold());
            this.writer.addAttribute("isItalic", font.isOwnItalic());
            this.writer.addAttribute("isUnderline", font.isOwnUnderline());
            this.writer.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            this.writer.addAttribute("pdfFontName", font.getOwnPdfFontName());
            this.writer.addAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.writer.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            this.writer.closeElement(true);
        }
    }

    public void writeTextField(JRTextField textField) throws IOException {
        this.writer.startElement("textField");
        this.writer.addAttribute("isStretchWithOverflow", textField.isStretchWithOverflow(), false);
        this.writer.addAttribute("evaluationTime", textField.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (textField.getEvaluationGroup() != null) {
            this.writer.addAttribute("evaluationGroup", textField.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("pattern", textField.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", textField.isOwnBlankWhenNull());
        this.writer.addAttribute("hyperlinkType", textField.getHyperlinkType(), JRXmlConstants.getHyperlinkTypeMap(), (byte)1);
        this.writer.addAttribute("hyperlinkTarget", textField.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", textField.getBookmarkLevel(), 0);
        this.writeReportElement(textField);
        this.writeBox(textField);
        this.writeTextElement(textField);
        this.writer.writeExpression("textFieldExpression", textField.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", textField.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", textField.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", textField.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", textField.getHyperlinkPageExpression(), false);
        this.writer.closeElement();
    }

    public void writeSubreport(JRSubreport subreport) throws IOException {
        this.writer.startElement("subreport");
        this.writer.addAttribute("isUsingCache", subreport.isOwnUsingCache());
        this.writeReportElement(subreport);
        this.writer.writeExpression("parametersMapExpression", subreport.getParametersMapExpression(), false);
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeSubreportParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", subreport.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", subreport.getDataSourceExpression(), false);
        JRSubreportReturnValue[] returnValues = subreport.getReturnValues();
        if (returnValues != null && returnValues.length > 0) {
            for (int i = 0; i < returnValues.length; ++i) {
                this.writeSubreportReturnValue(returnValues[i]);
            }
        }
        this.writer.writeExpression("subreportExpression", subreport.getExpression(), true);
        this.writer.closeElement();
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) throws IOException {
        this.writer.startElement("subreportParameter");
        this.writer.addAttribute("name", subreportParameter.getName());
        this.writer.writeExpression("subreportParameterExpression", subreportParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeDatasetParameter(JRDatasetParameter datasetParameter) throws IOException {
        this.writer.startElement("datasetParameter");
        this.writer.addAttribute("name", datasetParameter.getName());
        this.writer.writeExpression("datasetParameterExpression", datasetParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeChart(JRChart chart) throws IOException {
        this.writer.startElement("chart");
        this.writer.addAttribute("isShowLegend", chart.isShowLegend(), true);
        this.writer.addAttribute("evaluationTime", chart.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (chart.getEvaluationTime() == 5) {
            this.writer.addAttribute("evaluationGroup", chart.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("hyperlinkType", chart.getHyperlinkType(), JRXmlConstants.getHyperlinkTypeMap(), (byte)1);
        this.writer.addAttribute("hyperlinkTarget", chart.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", chart.getBookmarkLevel(), 0);
        this.writer.addAttribute("customizerClass", chart.getCustomizerClass());
        this.writeReportElement(chart);
        this.writeBox(chart);
        this.writer.startElement("chartTitle");
        this.writer.addAttribute("position", chart.getTitlePosition(), JRXmlConstants.getChartTitlePositionMap(), (byte)1);
        this.writer.addAttribute("color", chart.getTitleColor(), Color.black);
        this.writeFont(chart.getTitleFont());
        if (chart.getTitleExpression() != null) {
            this.writer.writeExpression("titleExpression", chart.getTitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartSubtitle");
        this.writer.addAttribute("color", chart.getSubtitleColor());
        this.writeFont(chart.getSubtitleFont());
        if (chart.getSubtitleExpression() != null) {
            this.writer.writeExpression("subtitleExpression", chart.getSubtitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.writeExpression("anchorNameExpression", chart.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", chart.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", chart.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", chart.getHyperlinkPageExpression(), false);
        this.writer.closeElement();
    }

    private void writeElementDataset(JRElementDataset dataset) throws IOException {
        JRDatasetRun datasetRun;
        this.writer.startElement("dataset");
        this.writer.addAttribute("resetType", dataset.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (dataset.getResetType() == 4) {
            this.writer.addAttribute("resetGroup", dataset.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", dataset.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (dataset.getIncrementType() == 4) {
            this.writer.addAttribute("incrementGroup", dataset.getIncrementGroup().getName());
        }
        if ((datasetRun = dataset.getDatasetRun()) != null) {
            this.writeDatasetRun(datasetRun);
        }
        this.writer.closeElement(true);
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset) throws IOException {
        this.writer.startElement("categoryDataset");
        this.writeElementDataset(dataset);
        JRCategorySeries[] categorySeries = dataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int i = 0; i < categorySeries.length; ++i) {
                this.writeCategorySeries(categorySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset) throws IOException {
        this.writer.startElement("timeSeriesDataset");
        if (dataset.getTimePeriod() != null && !(class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = JRXmlWriter.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day).getName().equals(dataset.getTimePeriod().getName())) {
            this.writer.addAttribute("timePeriod", JRXmlConstants.getTimePeriodName(dataset.getTimePeriod()));
        }
        this.writeElementDataset(dataset);
        JRTimeSeries[] timeSeries = dataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            for (int i = 0; i < timeSeries.length; ++i) {
                this.writeTimeSeries(timeSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset) throws IOException {
        this.writer.startElement("timePeriodDataset");
        this.writeElementDataset(dataset);
        JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                this.writeTimePeriodSeries(timePeriodSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries categorySeries) throws IOException {
        this.writer.startElement("categorySeries");
        this.writer.writeExpression("seriesExpression", categorySeries.getSeriesExpression(), false);
        this.writer.writeExpression("categoryExpression", categorySeries.getCategoryExpression(), false);
        this.writer.writeExpression("valueExpression", categorySeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", categorySeries.getLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeXyzDataset(JRXyzDataset dataset) throws IOException {
        this.writer.startElement("xyzDataset");
        this.writeElementDataset(dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null && series.length > 0) {
            for (int i = 0; i < series.length; ++i) {
                this.writeXyzSeries(series[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeXyzSeries(JRXyzSeries series) throws IOException {
        this.writer.startElement("xyzSeries");
        this.writer.writeExpression("seriesExpression", series.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", series.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", series.getYValueExpression(), false);
        this.writer.writeExpression("zValueExpression", series.getZValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeXySeries(JRXySeries xySeries) throws IOException {
        this.writer.startElement("xySeries");
        this.writer.writeExpression("seriesExpression", xySeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", xySeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", xySeries.getYValueExpression(), false);
        this.writer.writeExpression("labelExpression", xySeries.getLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeXyDataset(JRXyDataset dataset) throws IOException {
        this.writer.startElement("xyDataset");
        this.writeElementDataset(dataset);
        JRXySeries[] xySeries = dataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            for (int i = 0; i < xySeries.length; ++i) {
                this.writeXySeries(xySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeries(JRTimeSeries timeSeries) throws IOException {
        this.writer.startElement("timeSeries");
        this.writer.writeExpression("seriesExpression", timeSeries.getSeriesExpression(), false);
        this.writer.writeExpression("timePeriodExpression", timeSeries.getTimePeriodExpression(), false);
        this.writer.writeExpression("valueExpression", timeSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", timeSeries.getLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) throws IOException {
        this.writer.startElement("timePeriodSeries");
        this.writer.writeExpression("seriesExpression", timePeriodSeries.getSeriesExpression(), false);
        this.writer.writeExpression("startDateExpression", timePeriodSeries.getStartDateExpression(), false);
        this.writer.writeExpression("endDateExpression", timePeriodSeries.getEndDateExpression(), false);
        this.writer.writeExpression("valueExpression", timePeriodSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", timePeriodSeries.getLabelExpression(), false);
        this.writer.closeElement();
    }

    public void writePieDataset(JRPieDataset dataset) throws IOException {
        this.writer.startElement("pieDataset");
        this.writeElementDataset(dataset);
        this.writer.writeExpression("keyExpression", dataset.getKeyExpression(), false);
        this.writer.writeExpression("valueExpression", dataset.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", dataset.getLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writePlot(JRChartPlot plot) throws IOException {
        this.writer.startElement("plot");
        this.writer.addAttribute("backcolor", plot.getBackcolor());
        this.writer.addAttribute("orientation", plot.getOrientation(), JRXmlConstants.getPlotOrientationMap(), PlotOrientation.VERTICAL);
        this.writer.addAttribute("backgroundAlpha", plot.getBackgroundAlpha(), 1.0f);
        this.writer.addAttribute("foregroundAlpha", plot.getForegroundAlpha(), 1.0f);
        this.writer.closeElement();
    }

    public void writePieChart(JRChart chart) throws IOException {
        this.writer.startElement("pieChart");
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        this.writer.startElement("piePlot");
        this.writePlot(chart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writePie3DChart(JRChart chart) throws IOException {
        this.writer.startElement("pie3DChart");
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
        this.writer.startElement("pie3DPlot");
        this.writer.addAttribute("depthFactor", plot.getDepthFactor(), 0.2);
        this.writePlot(chart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeBarPlot(JRBarPlot plot) throws IOException {
        this.writer.startElement("barPlot");
        this.writer.addAttribute("isShowLabels", plot.isShowLabels(), false);
        this.writer.addAttribute("isShowTickLabels", plot.isShowTickLabels(), true);
        this.writer.addAttribute("isShowTickMarks", plot.isShowTickMarks(), true);
        this.writePlot(plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeBubblePlot(JRBubblePlot plot) throws IOException {
        this.writer.startElement("bubblePlot");
        this.writer.addAttribute("scaleType", plot.getScaleType(), JRXmlConstants.getScaleTypeMap());
        this.writePlot(plot);
        this.writer.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writer.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeLinePlot(JRLinePlot plot) throws IOException {
        this.writer.startElement("linePlot");
        this.writer.addAttribute("isShowLines", plot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", plot.isShowShapes(), true);
        this.writePlot(plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot) throws IOException {
        this.writer.startElement("timeSeriesPlot");
        this.writer.addAttribute("isShowLines", plot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", plot.isShowShapes(), true);
        this.writePlot(plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    public void writeBar3DPlot(JRBar3DPlot plot) throws IOException {
        this.writer.startElement("bar3DPlot");
        this.writer.addAttribute("isShowLabels", plot.isShowLabels(), false);
        this.writer.addAttribute("xOffset", plot.getXOffset(), 12.0);
        this.writer.addAttribute("yOffset", plot.getYOffset(), 8.0);
        this.writePlot(plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    public void writeBarChart(JRChart chart) throws IOException {
        this.writer.startElement("barChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("bar3DChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBubbleChart(JRChart chart) throws IOException {
        this.writer.startElement("bubbleChart");
        this.writeChart(chart);
        this.writeXyzDataset((JRXyzDataset)chart.getDataset());
        this.writeBubblePlot((JRBubblePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBarChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBarChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBar3DChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeLineChart(JRChart chart) throws IOException {
        this.writer.startElement("lineChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeTimeSeriesChart(JRChart chart) throws IOException {
        this.writer.startElement("timeSeriesChart");
        this.writeChart(chart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeHighLowDataset(JRHighLowDataset dataset) throws IOException {
        this.writer.startElement("highLowDataset");
        this.writeElementDataset(dataset);
        this.writer.writeExpression("seriesExpression", dataset.getSeriesExpression(), false);
        this.writer.writeExpression("dateExpression", dataset.getDateExpression(), false);
        this.writer.writeExpression("highExpression", dataset.getHighExpression(), false);
        this.writer.writeExpression("lowExpression", dataset.getLowExpression(), false);
        this.writer.writeExpression("openExpression", dataset.getOpenExpression(), false);
        this.writer.writeExpression("closeExpression", dataset.getCloseExpression(), false);
        this.writer.writeExpression("volumeExpression", dataset.getVolumeExpression(), false);
        this.writer.closeElement();
    }

    public void writeHighLowChart(JRChart chart) throws IOException {
        this.writer.startElement("highLowChart");
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
        this.writer.startElement("highLowPlot");
        this.writer.addAttribute("isShowOpenTicks", plot.isShowOpenTicks(), true);
        this.writer.addAttribute("isShowCloseTicks", plot.isShowCloseTicks(), true);
        this.writePlot(plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeCandlestickChart(JRChart chart) throws IOException {
        this.writer.startElement("candlestickChart");
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
        this.writer.startElement("candlestickPlot");
        this.writer.addAttribute("isShowVolume", plot.isShowVolume(), true);
        this.writePlot(plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeAreaPlot(JRAreaPlot plot) throws IOException {
        this.writer.startElement("areaPlot");
        this.writePlot(plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    public void writeAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("areaChart");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    private void writeScatterPlot(JRScatterPlot plot) throws IOException {
        this.writer.startElement("scatterPlot");
        this.writer.addAttribute("isShowLines", plot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", plot.isShowShapes(), true);
        this.writePlot(plot);
        this.writer.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writer.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writer.closeElement();
    }

    public void writeScatterChart(JRChart chart) throws IOException {
        this.writer.startElement("scatterChart");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeScatterPlot((JRScatterPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("xyAreaChart");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyBarChart(JRChart chart) throws IOException {
        this.writer.startElement("xyBarChart");
        this.writeChart(chart);
        JRChartDataset dataset = chart.getDataset();
        if (dataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset);
        } else if (dataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)dataset);
        } else if (dataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)dataset);
        }
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyLineChart(JRChart chart) throws IOException {
        this.writer.startElement("xyLineChart");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeChartTag(JRChart chart) throws IOException {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart);
                break;
            }
            case 3: {
                this.writeBarChart(chart);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart);
                break;
            }
            case 7: {
                this.writeLineChart(chart);
                break;
            }
            case 9: {
                this.writePieChart(chart);
                break;
            }
            case 8: {
                this.writePie3DChart(chart);
                break;
            }
            case 10: {
                this.writeScatterChart(chart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addAttribute("subreportVariable", returnValue.getSubreportVariable());
        this.writer.addAttribute("toVariable", returnValue.getToVariable());
        this.writer.addAttribute("calculation", returnValue.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", returnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    public void writeCrosstab(JRCrosstab crosstab) throws IOException {
        this.writer.startElement("crosstab");
        this.writer.addAttribute("isRepeatColumnHeaders", crosstab.isRepeatColumnHeaders(), true);
        this.writer.addAttribute("isRepeatRowHeaders", crosstab.isRepeatRowHeaders(), true);
        this.writer.addAttribute("columnBreakOffset", crosstab.getColumnBreakOffset(), 10);
        this.writeReportElement(crosstab);
        JRCrosstabParameter[] parameters = crosstab.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeCrosstabParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("parametersMapExpression", crosstab.getParametersMapExpression(), false);
        this.writeCrosstabDataset(crosstab);
        this.writeCrosstabHeaderCell(crosstab);
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        for (int i = 0; i < rowGroups.length; ++i) {
            this.writeCrosstabRowGroup(rowGroups[i]);
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        for (int i = 0; i < columnGroups.length; ++i) {
            this.writeCrosstabColumnGroup(columnGroups[i]);
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            this.writeCrosstabMeasure(measures[i]);
        }
        if (crosstab instanceof JRDesignCrosstab) {
            List cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
            Iterator it = cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                this.writeCrosstabCell(cell);
            }
        } else {
            JRCrosstabCell[][] cells = crosstab.getCells();
            HashSet<JRCrosstabCell> cellsSet = new HashSet<JRCrosstabCell>();
            for (int i = cells.length - 1; i >= 0; --i) {
                for (int j = cells[i].length - 1; j >= 0; --j) {
                    JRCrosstabCell cell = cells[i][j];
                    if (cell == null || !cellsSet.add(cell)) continue;
                    this.writeCrosstabCell(cell);
                }
            }
        }
        this.writeCrosstabWhenNoDataCell(crosstab);
        this.writer.closeElement();
    }

    private void writeCrosstabDataset(JRCrosstab crosstab) throws IOException {
        JRCrosstabDataset dataset = crosstab.getDataset();
        this.writer.startElement("crosstabDataset");
        this.writer.addAttribute("isDataPreSorted", dataset.isDataPreSorted(), false);
        this.writeElementDataset(dataset);
        this.writer.closeElement(true);
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab crosstab) throws IOException {
        JRCellContents whenNoDataCell = crosstab.getWhenNoDataCell();
        if (whenNoDataCell != null) {
            this.writer.startElement("whenNoDataCell");
            this.writeCellContents(whenNoDataCell);
            this.writer.closeElement();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab crosstab) throws IOException {
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            this.writer.startElement("crosstabHeaderCell");
            this.writeCellContents(headerCell);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup group) throws IOException {
        this.writer.startElement("rowGroup");
        this.writer.addAttribute("name", group.getName());
        this.writer.addAttribute("width", group.getWidth());
        this.writer.addAttribute("totalPosition", group.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", group.getPosition(), JRXmlConstants.getCrosstabRowPositionMap(), (byte)1);
        this.writeBucket(group.getBucket());
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabRowHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalRowHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup group) throws IOException {
        this.writer.startElement("columnGroup");
        this.writer.addAttribute("name", group.getName());
        this.writer.addAttribute("height", group.getHeight());
        this.writer.addAttribute("totalPosition", group.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", group.getPosition(), JRXmlConstants.getCrosstabColumnPositionMap(), (byte)1);
        this.writeBucket(group.getBucket());
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabColumnHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalColumnHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeBucket(JRCrosstabBucket bucket) throws IOException {
        this.writer.startElement("bucket");
        this.writer.addAttribute("order", bucket.getOrder(), JRXmlConstants.getCrosstabBucketOrderMap(), (byte)1);
        this.writer.writeExpression("bucketExpression", bucket.getExpression(), true);
        this.writer.writeExpression("comparatorExpression", bucket.getComparatorExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure measure) throws IOException {
        this.writer.startElement("measure");
        this.writer.addAttribute("name", measure.getName());
        this.writer.addAttribute("class", measure.getValueClassName());
        this.writer.addAttribute("calculation", measure.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("percentageOf", measure.getPercentageOfType(), JRXmlConstants.getCrosstabPercentageMap(), (byte)0);
        this.writer.addAttribute("percentageCalculatorClass", measure.getPercentageCalculatorClassName());
        this.writer.writeExpression("measureExpression", measure.getValueExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabCell(JRCrosstabCell cell) throws IOException {
        this.writer.startElement("crosstabCell");
        this.writer.addAttribute("width", cell.getWidth());
        this.writer.addAttribute("height", cell.getHeight());
        this.writer.addAttribute("rowTotalGroup", cell.getRowTotalGroup());
        this.writer.addAttribute("columnTotalGroup", cell.getColumnTotalGroup());
        this.writeCellContents(cell.getContents());
        this.writer.closeElement();
    }

    protected void writeCellContents(JRCellContents contents) throws IOException {
        if (contents != null) {
            this.writer.startElement("cellContents");
            this.writer.addAttribute("backcolor", contents.getBackcolor());
            this.writer.addAttribute("mode", contents.getMode(), JRXmlConstants.getModeMap());
            JRStyle style = contents.getStyle();
            if (style != null) {
                this.writer.addAttribute("style", style.getName());
            }
            this.writeBox(contents.getBox());
            List children = contents.getChildren();
            if (children != null) {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    JRChild element = (JRChild)it.next();
                    element.writeXml(this);
                }
            }
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter parameter) throws IOException {
        this.writer.startElement("crosstabParameter");
        this.writer.addAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName(), "java.lang.String");
        this.writer.writeExpression("parameterValueExpression", parameter.getExpression(), false);
        this.writer.closeElement();
    }

    public void writeDataset(JRDataset dataset) throws IOException {
        this.writer.startElement("subDataset");
        this.writer.addAttribute("name", dataset.getName());
        this.writer.addAttribute("scriptletClass", dataset.getScriptletClass());
        this.writer.addAttribute("resourceBundle", dataset.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", dataset.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writeProperties(dataset.getPropertiesMap());
        this.writeDatasetContents(dataset);
        this.writer.closeElement();
    }

    protected void writeDatasetContents(JRDataset dataset) throws IOException {
        JRGroup[] groups;
        JRVariable[] variables;
        JRField[] fields;
        JRParameter[] parameters = dataset.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i]);
            }
        }
        if (dataset.getQuery() != null) {
            this.writeQuery(dataset.getQuery());
        }
        if ((fields = dataset.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i]);
            }
        }
        if ((variables = dataset.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i]);
            }
        }
        if ((groups = dataset.getGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                this.writeGroup(groups[i]);
            }
        }
    }

    protected void writeDatasetRun(JRDatasetRun datasetRun) throws IOException {
        this.writer.startElement("datasetRun");
        this.writer.addAttribute("subDataset", datasetRun.getDatasetName());
        this.writer.writeExpression("parametersMapExpression", datasetRun.getParametersMapExpression(), false);
        JRDatasetParameter[] parameters = datasetRun.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeDatasetParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", datasetRun.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", datasetRun.getDataSourceExpression(), false);
        this.writer.closeElement();
    }

    public void writeFrame(JRFrame frame) throws IOException {
        this.writer.startElement("frame");
        this.writeReportElement(frame);
        this.writeBox(frame);
        List children = frame.getChildren();
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                JRChild element = (JRChild)it.next();
                element.writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

