/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Table
extends Rectangle
implements Element,
MarkupAttributes {
    private int columns;
    private Point curPosition = new Point(0, 0);
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float widthPercentage = 80.0f;
    private String absWidth = "";
    private float[] widths;
    boolean mDebug = false;
    boolean mTableInserted = false;
    boolean mAutoFillEmptyCells = false;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    protected Hashtable alternatingRowAttributes = null;
    protected boolean convert2pdfptable = false;
    private static DecimalFormat widthFormat = new DecimalFormat("0.00");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Table(int columns) throws BadElementException {
        this(columns, 1);
    }

    public Table(int columns, int rows) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        if (columns <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = columns;
        int i = 0;
        while (i < rows) {
            this.rows.add(new Row(columns));
            ++i;
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[columns];
        float width = 100.0f / (float)columns;
        int i2 = 0;
        while (i2 < columns) {
            this.widths[i2] = width;
            ++i2;
        }
    }

    public Table(Properties attributes) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        int blue;
        int green;
        int red;
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        String value = (String)attributes.remove("columns");
        if (value == null) {
            this.columns = 1;
        } else {
            this.columns = Integer.parseInt(value);
            if (this.columns <= 0) {
                this.columns = 1;
            }
        }
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, this.curPosition.y);
        value = (String)attributes.remove("lastHeaderRow");
        if (value != null) {
            this.setLastHeaderRow(Integer.parseInt(value));
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
        if ((value = (String)attributes.remove("cellspacing")) != null) {
            this.setSpacing(Float.valueOf(String.valueOf(value) + "f").floatValue());
        }
        if ((value = (String)attributes.remove("cellpadding")) != null) {
            this.setPadding(Float.valueOf(String.valueOf(value) + "f").floatValue());
        }
        if ((value = (String)attributes.remove("offset")) != null) {
            this.setOffset(Float.valueOf(String.valueOf(value) + "f").floatValue());
        }
        if ((value = (String)attributes.remove("width")) != null) {
            if (value.endsWith("%")) {
                this.setWidth(Float.valueOf(String.valueOf(value.substring(0, value.length() - 1)) + "f").floatValue());
            } else {
                this.setAbsWidth(value);
            }
        }
        this.widths = new float[this.columns];
        int i = 0;
        while (i < this.columns) {
            this.widths[i] = 0.0f;
            ++i;
        }
        value = (String)attributes.remove("widths");
        if (value != null) {
            StringTokenizer widthTokens = new StringTokenizer(value, ";");
            int i2 = 0;
            while (widthTokens.hasMoreTokens()) {
                value = widthTokens.nextToken();
                this.widths[i2] = Float.valueOf(String.valueOf(value) + "f").floatValue();
                ++i2;
            }
            this.columns = i2;
        }
        if ((value = (String)attributes.remove("tablefitspage")) != null) {
            this.tableFitsPage = new Boolean(value);
        }
        if ((value = (String)attributes.remove("cellsfitpage")) != null) {
            this.cellsFitPage = new Boolean(value);
        }
        if ((value = (String)attributes.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.valueOf(String.valueOf(value) + "f").floatValue());
        }
        int border = 0;
        value = (String)attributes.remove("left");
        if (value != null && new Boolean(value).booleanValue()) {
            border |= 4;
        }
        if ((value = (String)attributes.remove("right")) != null && new Boolean(value).booleanValue()) {
            border |= 8;
        }
        if ((value = (String)attributes.remove("top")) != null && new Boolean(value).booleanValue()) {
            border |= 1;
        }
        if ((value = (String)attributes.remove("bottom")) != null && new Boolean(value).booleanValue()) {
            border |= 2;
        }
        this.setBorder(border);
        String r = (String)attributes.remove("red");
        String g = (String)attributes.remove("green");
        String b = (String)attributes.remove("blue");
        if (r != null || g != null || b != null) {
            red = 0;
            green = 0;
            blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            this.setBorderColor(new Color(red, green, blue));
        } else {
            value = attributes.getProperty("bordercolor");
            if (value != null) {
                this.setBorderColor(MarkupParser.decodeColor(value));
            }
        }
        r = (String)attributes.remove("bgred");
        g = (String)attributes.remove("bggreen");
        b = (String)attributes.remove("bgblue");
        if (r != null || g != null || b != null) {
            red = 0;
            green = 0;
            blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            this.setBackgroundColor(new Color(red, green, blue));
        } else {
            value = (String)attributes.remove("backgroundcolor");
            if (value != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(value));
            }
        }
        value = (String)attributes.remove("grayfill");
        if (value != null) {
            this.setGrayFill(Float.valueOf(String.valueOf(value) + "f").floatValue());
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public void setDebug(boolean aDebug) {
        this.mDebug = aDebug;
    }

    public void setDefaultLayout(Cell value) {
        this.defaultLayout = value;
    }

    public void setAutoFillEmptyCells(boolean aDoAutoFill) {
        this.mAutoFillEmptyCells = aDoAutoFill;
    }

    public void setTableFitsPage(boolean fitPage) {
        this.tableFitsPage = fitPage;
        if (fitPage) {
            this.setCellsFitPage(true);
        }
    }

    public void setCellsFitPage(boolean fitPage) {
        this.cellsFitPage = fitPage;
    }

    public boolean hasToFitPageTable() {
        return this.tableFitsPage;
    }

    public boolean hasToFitPageCells() {
        return this.cellsFitPage;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getOffset() {
        return this.offset;
    }

    public int type() {
        return 22;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void addCell(Cell aCell, int row, int column) throws BadElementException {
        this.addCell(aCell, new Point(row, column));
    }

    public void addCell(Cell aCell, Point aLocation) throws BadElementException {
        if (aCell == null) {
            throw new NullPointerException("addCell - cell has null-value");
        }
        if (aLocation == null) {
            throw new NullPointerException("addCell - point has null-value");
        }
        if (aCell.isTable()) {
            this.insertTable((Table)aCell.getElements().next(), aLocation);
        }
        if (this.mDebug) {
            if (aLocation.x < 0) {
                throw new BadElementException("row coordinate of location must be >= 0");
            }
            if (aLocation.y <= 0 && aLocation.y > this.columns) {
                throw new BadElementException("column coordinate of location must be >= 0 and < nr of columns");
            }
            if (!this.isValidLocation(aCell, aLocation)) {
                throw new BadElementException("Adding a cell at the location (" + aLocation.x + "," + aLocation.y + ") with a colspan of " + aCell.colspan() + " and a rowspan of " + aCell.rowspan() + " is illegal (beyond boundaries/overlapping).");
            }
        }
        if (aCell.border() == -1) {
            aCell.setBorder(this.defaultLayout.border());
        }
        aCell.fill();
        this.placeCell(this.rows, aCell, aLocation);
        this.setCurrentLocationToNextValidPosition(aLocation);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase content) throws BadElementException {
        this.addCell(content, this.curPosition);
    }

    public void addCell(Phrase content, Point location) throws BadElementException {
        Cell cell = new Cell(content);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setGrayFill(this.defaultLayout.grayFill());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell, location);
    }

    public void addCell(String content) throws BadElementException {
        this.addCell(new Phrase(content), this.curPosition);
    }

    public void addCell(String content, Point location) throws BadElementException {
        this.addCell(new Phrase(content), location);
    }

    public void insertTable(Table aTable) {
        if (aTable == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(aTable, this.curPosition);
    }

    public void insertTable(Table aTable, int row, int column) {
        if (aTable == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(aTable, new Point(row, column));
    }

    public void insertTable(Table aTable, Point aLocation) {
        if (aTable == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        if (aLocation == null) {
            throw new NullPointerException("insertTable - point has null-value");
        }
        this.mTableInserted = true;
        aTable.complete();
        if (this.mDebug && aLocation.y > this.columns) {
            System.err.println("insertTable -- wrong columnposition(" + aLocation.y + ") of location; max =" + this.columns);
        }
        int rowCount = aLocation.x + 1 - this.rows.size();
        int i = 0;
        if (rowCount > 0) {
            while (i < rowCount) {
                this.rows.add(new Row(this.columns));
                ++i;
            }
        }
        ((Row)this.rows.get(aLocation.x)).setElement(aTable, aLocation.y);
        this.setCurrentLocationToNextValidPosition(aLocation);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.mAutoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
        if (this.alternatingRowAttributes != null) {
            Properties even = new Properties();
            Properties odd = new Properties();
            Iterator iterator = this.alternatingRowAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                String name = String.valueOf(iterator.next());
                String[] value = (String[])this.alternatingRowAttributes.get(name);
                even.setProperty(name, value[0]);
                odd.setProperty(name, value[1]);
            }
            int i = this.lastHeaderRow + 1;
            while (i < this.rows.size()) {
                Row row = (Row)this.rows.get(i);
                row.setMarkupAttributes(i % 2 == 0 ? even : odd);
                ++i;
            }
        }
    }

    public void setDefaultCellBorder(int value) {
        this.defaultLayout.setBorder(value);
    }

    public void setDefaultCellBorderWidth(float value) {
        this.defaultLayout.setBorderWidth(value);
    }

    public void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public void setDefaultCellGrayFill(float value) {
        if (value >= 0.0f && value <= 1.0f) {
            this.defaultLayout.setGrayFill(value);
        }
    }

    public void setDefaultHorizontalAlignment(int value) {
        this.defaultLayout.setHorizontalAlignment(value);
    }

    public void setDefaultVerticalAlignment(int value) {
        this.defaultLayout.setVerticalAlignment(value);
    }

    public void setDefaultRowspan(int value) {
        this.defaultLayout.setRowspan(value);
    }

    public void setDefaultColspan(int value) {
        this.defaultLayout.setColspan(value);
    }

    private void assumeTableDefaults(Cell aCell) {
        if (aCell.border() == -1) {
            aCell.setBorder(this.defaultLayout.border());
        }
        if (aCell.borderWidth() == -1.0f) {
            aCell.setBorderWidth(this.defaultLayout.borderWidth());
        }
        if (aCell.borderColor() == null) {
            aCell.setBorderColor(this.defaultLayout.borderColor());
        }
        if (aCell.backgroundColor() == null) {
            aCell.setBackgroundColor(this.defaultLayout.backgroundColor());
        }
        if (aCell.grayFill() == -1.0f) {
            aCell.setGrayFill(this.defaultLayout.grayFill());
        }
        if (aCell.horizontalAlignment() == -1) {
            aCell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        }
        if (aCell.verticalAlignment() == -1) {
            aCell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        }
    }

    public void deleteColumn(int column) throws BadElementException {
        float[] newWidths = new float[--this.columns];
        int i = 0;
        while (i < column) {
            newWidths[i] = this.widths[i];
            ++i;
        }
        i = column;
        while (i < this.columns) {
            newWidths[i] = this.widths[i + 1];
            ++i;
        }
        this.setWidths(newWidths);
        i = 0;
        while (i < this.columns) {
            newWidths[i] = this.widths[i];
            ++i;
        }
        this.widths = newWidths;
        int size = this.rows.size();
        int i2 = 0;
        while (i2 < size) {
            Row row = (Row)this.rows.get(i2);
            row.deleteColumn(column);
            this.rows.set(i2, row);
            ++i2;
        }
        if (column == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return false;
        }
        this.rows.remove(row);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public void deleteAllRows() {
        this.rows.clear();
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, 0);
        this.lastHeaderRow = -1;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int value) {
        this.lastHeaderRow = value;
    }

    public void setAlignment(int value) {
        this.alignment = value;
    }

    public void setAlignment(String alignment) {
        if ("Left".equalsIgnoreCase(alignment)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(alignment)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    public void setSpaceInsideCell(float value) {
        this.cellpadding = value;
    }

    public void setSpaceBetweenCells(float value) {
        this.cellspacing = value;
    }

    public void setPadding(float value) {
        this.cellpadding = value;
    }

    public void setSpacing(float value) {
        this.cellspacing = value;
    }

    public void setCellpadding(float value) {
        this.cellspacing = value;
    }

    public void setCellspacing(float value) {
        this.cellpadding = value;
    }

    public void setWidth(float width) {
        this.widthPercentage = width;
    }

    public void setAbsWidth(String width) {
        this.absWidth = width;
    }

    public void setWidths(float[] widths) throws BadElementException {
        if (widths.length != this.columns) {
            throw new BadElementException("Wrong number of columns.");
        }
        float hundredPercent = 0.0f;
        int i = 0;
        while (i < this.columns) {
            hundredPercent += widths[i];
            ++i;
        }
        this.widths[this.columns - 1] = 100.0f;
        int i2 = 0;
        while (i2 < this.columns - 1) {
            float width;
            this.widths[i2] = width = 100.0f * widths[i2] / hundredPercent;
            int n = this.columns - 1;
            this.widths[n] = this.widths[n] - width;
            ++i2;
        }
    }

    public void setWidths(int[] widths) throws DocumentException {
        float[] tb = new float[widths.length];
        int k = 0;
        while (k < widths.length) {
            tb[k] = widths[k];
            ++k;
        }
        this.setWidths(tb);
    }

    public int columns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float widthPercentage() {
        return this.widthPercentage;
    }

    public String absWidth() {
        return this.absWidth;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public int lastHeaderRow() {
        return this.lastHeaderRow;
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.rows.size());
    }

    public Object getElement(int row, int column) {
        return ((Row)this.rows.get(row)).getCell(column);
    }

    private void mergeInsertedTables() {
        int i = 0;
        int j = 0;
        float[] lNewWidths = null;
        int[] lDummyWidths = new int[this.columns];
        float[][] lDummyColumnWidths = new float[this.columns][];
        int[] lDummyHeights = new int[this.rows.size()];
        ArrayList<Row> newRows = null;
        boolean isTable = false;
        int lTotalRows = 0;
        int lTotalColumns = 0;
        int lNewMaxRows = 0;
        int lNewMaxColumns = 0;
        Table lDummyTable = null;
        j = 0;
        while (j < this.columns) {
            lNewMaxColumns = 1;
            float[] tmpWidths = null;
            i = 0;
            while (i < this.rows.size()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.lowagie.text.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(((Row)this.rows.get(i)).getCell(j))) {
                    isTable = true;
                    lDummyTable = (Table)((Row)this.rows.get(i)).getCell(j);
                    if (tmpWidths == null) {
                        tmpWidths = lDummyTable.widths;
                        lNewMaxColumns = tmpWidths.length;
                    } else {
                        int cols = lDummyTable.getDimension().width;
                        float[] tmpWidthsN = new float[cols * tmpWidths.length];
                        float tpW = 0.0f;
                        float btW = 0.0f;
                        float totW = 0.0f;
                        int tpI = 0;
                        int btI = 0;
                        int totI = 0;
                        tpW += tmpWidths[0];
                        btW += lDummyTable.widths[0];
                        while (tpI < tmpWidths.length && btI < cols) {
                            if (btW > tpW) {
                                tmpWidthsN[totI] = tpW - totW;
                                if (++tpI < tmpWidths.length) {
                                    tpW += tmpWidths[tpI];
                                }
                            } else {
                                tmpWidthsN[totI] = btW - totW;
                                ++btI;
                                if ((double)Math.abs(btW - tpW) < 1.0E-4 && ++tpI < tmpWidths.length) {
                                    tpW += tmpWidths[tpI];
                                }
                                if (btI < cols) {
                                    btW += lDummyTable.widths[btI];
                                }
                            }
                            totW += tmpWidthsN[totI];
                            ++totI;
                        }
                        tmpWidths = new float[totI];
                        System.arraycopy(tmpWidthsN, 0, tmpWidths, 0, totI);
                        lNewMaxColumns = totI;
                    }
                }
                ++i;
            }
            lDummyColumnWidths[j] = tmpWidths;
            lTotalColumns += lNewMaxColumns;
            lDummyWidths[j] = lNewMaxColumns;
            ++j;
        }
        i = 0;
        while (i < this.rows.size()) {
            lNewMaxRows = 1;
            j = 0;
            while (j < this.columns) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.lowagie.text.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(((Row)this.rows.get(i)).getCell(j))) {
                    isTable = true;
                    lDummyTable = (Table)((Row)this.rows.get(i)).getCell(j);
                    if (lDummyTable.getDimension().height > lNewMaxRows) {
                        lNewMaxRows = lDummyTable.getDimension().height;
                    }
                }
                ++j;
            }
            lTotalRows += lNewMaxRows;
            lDummyHeights[i] = lNewMaxRows;
            ++i;
        }
        if (lTotalColumns != this.columns || lTotalRows != this.rows.size() || isTable) {
            lNewWidths = new float[lTotalColumns];
            int lDummy = 0;
            int tel = 0;
            while (tel < this.widths.length) {
                if (lDummyWidths[tel] != 1) {
                    int tel2 = 0;
                    while (tel2 < lDummyWidths[tel]) {
                        lNewWidths[lDummy] = this.widths[tel] * lDummyColumnWidths[tel][tel2] / 100.0f;
                        ++lDummy;
                        ++tel2;
                    }
                } else {
                    lNewWidths[lDummy] = this.widths[tel];
                    ++lDummy;
                }
                ++tel;
            }
            newRows = new ArrayList<Row>(lTotalRows);
            i = 0;
            while (i < lTotalRows) {
                newRows.add(new Row(lTotalColumns));
                ++i;
            }
            int lDummyRow = 0;
            int lDummyColumn = 0;
            Object lDummyElement = null;
            i = 0;
            while (i < this.rows.size()) {
                lDummyColumn = 0;
                lNewMaxRows = 1;
                j = 0;
                while (j < this.columns) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("com.lowagie.text.Table");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isInstance(((Row)this.rows.get(i)).getCell(j))) {
                        lDummyTable = (Table)((Row)this.rows.get(i)).getCell(j);
                        int[] colMap = new int[lDummyTable.widths.length + 1];
                        int cb = 0;
                        int ct = 0;
                        while (cb < lDummyTable.widths.length) {
                            colMap[cb] = lDummyColumn + ct;
                            float wb = lDummyTable.widths[cb];
                            float wt = 0.0f;
                            while (ct < lDummyWidths[j]) {
                                if (Math.abs(Table.convertWidth(wb) - Table.convertWidth(wt += lDummyColumnWidths[j][ct++])) < 1.0E-4) break;
                            }
                            ++cb;
                        }
                        colMap[cb] = lDummyColumn + ct;
                        int k = 0;
                        while (k < lDummyTable.getDimension().height) {
                            int l = 0;
                            while (l < lDummyTable.getDimension().width) {
                                int yy = l;
                                lDummyElement = lDummyTable.getElement(k, l);
                                if (lDummyElement != null) {
                                    int col = lDummyColumn + l;
                                    Class<?> clazz2 = class$1;
                                    if (clazz2 == null) {
                                        try {
                                            clazz2 = Class.forName("com.lowagie.text.Cell");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz2.isInstance(lDummyElement)) {
                                        Cell lDummyC = (Cell)lDummyElement;
                                        col = colMap[l];
                                        int ot = colMap[l + lDummyC.colspan()];
                                        lDummyC.setColspan(ot - col);
                                    }
                                    ((Row)newRows.get(k + lDummyRow)).addElement(lDummyElement, col);
                                }
                                ++l;
                            }
                            ++k;
                        }
                    } else {
                        Object aElement = this.getElement(i, j);
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("com.lowagie.text.Cell");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3.isInstance(aElement)) {
                            ((Cell)aElement).setRowspan(((Cell)((Row)this.rows.get(i)).getCell(j)).rowspan() + lDummyHeights[i] - 1);
                            ((Cell)aElement).setColspan(((Cell)((Row)this.rows.get(i)).getCell(j)).colspan() + lDummyWidths[j] - 1);
                            this.placeCell(newRows, (Cell)aElement, new Point(lDummyRow, lDummyColumn));
                        }
                    }
                    lDummyColumn += lDummyWidths[j];
                    ++j;
                }
                lDummyRow += lDummyHeights[i];
                ++i;
            }
            this.columns = lTotalColumns;
            this.rows = newRows;
            this.widths = lNewWidths;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            int i = 0;
            while (i < this.rows.size()) {
                int j = 0;
                while (j < this.columns) {
                    if (!((Row)this.rows.get(i)).isReserved(j)) {
                        this.addCell(this.defaultLayout, new Point(i, j));
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (BadElementException bee) {
            throw new ExceptionConverter(bee);
        }
    }

    private boolean isValidLocation(Cell aCell, Point aLocation) {
        if (aLocation.x < this.rows.size()) {
            if (aLocation.y + aCell.colspan() > this.columns) {
                return false;
            }
            int difx = this.rows.size() - aLocation.x > aCell.rowspan() ? aCell.rowspan() : this.rows.size() - aLocation.x;
            int dify = this.columns - aLocation.y > aCell.colspan() ? aCell.colspan() : this.columns - aLocation.y;
            int i = aLocation.x;
            while (i < aLocation.x + difx) {
                int j = aLocation.y;
                while (j < aLocation.y + dify) {
                    if (((Row)this.rows.get(i)).isReserved(j)) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (aLocation.y + aCell.colspan() > this.columns) {
            return false;
        }
        return true;
    }

    private void placeCell(ArrayList someRows, Cell aCell, Point aPosition) {
        int i;
        Row row = null;
        int lColumns = ((Row)someRows.get(0)).columns();
        int rowCount = aPosition.x + aCell.rowspan() - someRows.size();
        this.assumeTableDefaults(aCell);
        if (aPosition.x + aCell.rowspan() > someRows.size()) {
            i = 0;
            while (i < rowCount) {
                row = new Row(lColumns);
                someRows.add(row);
                ++i;
            }
        }
        i = aPosition.x + 1;
        while (i < aPosition.x + aCell.rowspan()) {
            if (!((Row)someRows.get(i)).reserve(aPosition.y, aCell.colspan())) {
                throw new RuntimeException("addCell - error in reserve");
            }
            ++i;
        }
        row = (Row)someRows.get(aPosition.x);
        row.addElement(aCell, aPosition.y);
    }

    public void addColumns(int aColumns) {
        int j;
        ArrayList<Row> newRows = new ArrayList<Row>(this.rows.size());
        int newColumns = this.columns + aColumns;
        int i = 0;
        while (i < this.rows.size()) {
            Row row = new Row(newColumns);
            j = 0;
            while (j < this.columns) {
                row.setElement(((Row)this.rows.get(i)).getCell(j), j);
                ++j;
            }
            j = this.columns;
            while (j < newColumns && i < this.curPosition.x) {
                row.setElement(this.defaultLayout, j);
                ++j;
            }
            newRows.add(row);
            ++i;
        }
        float[] newWidths = new float[newColumns];
        j = 0;
        while (j < this.columns) {
            newWidths[j] = this.widths[j];
            ++j;
        }
        j = this.columns;
        while (j < newColumns) {
            newWidths[j] = 0.0f;
            ++j;
        }
        this.columns = newColumns;
        this.widths = newWidths;
        this.rows = newRows;
    }

    public float[] getWidths(float left, float totalWidth) {
        float[] w = new float[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                w[0] = left;
                break;
            }
            case 2: {
                w[0] = left + totalWidth * (100.0f - this.widthPercentage) / 100.0f;
                break;
            }
            default: {
                w[0] = left + totalWidth * (100.0f - this.widthPercentage) / 200.0f;
            }
        }
        totalWidth = totalWidth * this.widthPercentage / 100.0f;
        int i = 1;
        while (i < this.columns) {
            w[i] = w[i - 1] + this.widths[i - 1] * totalWidth / 100.0f;
            ++i;
        }
        w[this.columns] = w[0] + totalWidth;
        return w;
    }

    private void setCurrentLocationToNextValidPosition(Point aLocation) {
        int i = aLocation.x;
        int j = aLocation.y;
        do {
            if (j + 1 == this.columns) {
                ++i;
                j = 0;
                continue;
            }
            ++j;
        } while (i < this.rows.size() && j < this.columns && ((Row)this.rows.get(i)).isReserved(j));
        this.curPosition = new Point(i, j);
    }

    public static boolean isTag(String tag) {
        return "table".equals(tag);
    }

    public void setAlternatingRowAttribute(String name, String value0, String value1) {
        String[] value;
        if (value0 == null || value1 == null) {
            throw new NullPointerException("MarkupTable#setAlternatingRowAttribute(): null values are not permitted.");
        }
        if (this.alternatingRowAttributes == null) {
            this.alternatingRowAttributes = new Hashtable();
        }
        if ((value = (String[])this.alternatingRowAttributes.get(name)) == null) {
            value = new String[]{value0, value1};
        }
        this.alternatingRowAttributes.put(name, value);
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float top(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public void setTop(int value) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setBottom(int value) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setLeft(int value) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setRight(int value) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public int getNextRow() {
        return this.curPosition.x;
    }

    public int getNextColumn() {
        return this.curPosition.y;
    }

    private static final double convertWidth(double val) {
        if (val == 0.0) {
            return 0.0;
        }
        try {
            String tmp = widthFormat.format(val);
            Number result = widthFormat.parse(tmp);
            return result.doubleValue();
        }
        catch (ParseException pe) {
            throw new RuntimeException("Could not convert double to width for val:" + val);
        }
    }

    public PdfPTable createPdfPTable() throws BadElementException {
        if (!this.convert2pdfptable) {
            throw new BadElementException("No error, just an old style table");
        }
        this.setAutoFillEmptyCells(true);
        this.complete();
        PdfPTable pdfptable = new PdfPTable(this.widths);
        pdfptable.setTableEvent(SimpleTable.getDimensionlessInstance(this, this.cellspacing));
        pdfptable.setHeaderRows(this.lastHeaderRow + 1);
        pdfptable.setSplitLate(this.cellsFitPage);
        if (!Float.isNaN(this.offset)) {
            pdfptable.setSpacingBefore(this.offset);
        }
        pdfptable.setHorizontalAlignment(this.alignment);
        if (this.absWidth.length() > 0) {
            try {
                pdfptable.setTotalWidth(Float.parseFloat(this.absWidth));
            }
            catch (Exception e1) {
                try {
                    pdfptable.setTotalWidth(Integer.parseInt(this.absWidth));
                }
                catch (Exception e2) {
                    pdfptable.setWidthPercentage(this.widthPercentage);
                }
            }
        } else {
            pdfptable.setWidthPercentage(this.widthPercentage);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            int i = 0;
            while (i < row.columns()) {
                Element cell = (Element)row.getCell(i);
                if (cell != null) {
                    PdfPCell pcell;
                    if (cell instanceof Table) {
                        pcell = new PdfPCell(((Table)cell).createPdfPTable());
                    } else if (cell instanceof Cell) {
                        pcell = ((Cell)cell).createPdfPCell();
                        pcell.setPadding(this.cellpadding + this.cellspacing / 2.0f);
                        pcell.setCellEvent(SimpleCell.getDimensionlessInstance((Cell)cell, this.cellspacing));
                    } else {
                        pcell = new PdfPCell();
                    }
                    pdfptable.addCell(pcell);
                }
                ++i;
            }
        }
        return pdfptable;
    }

    public boolean isConvert2pdfptable() {
        return this.convert2pdfptable;
    }

    public void setConvert2pdfptable(boolean convert2pdfptable) {
        this.convert2pdfptable = convert2pdfptable;
    }
}

