/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.syslogng.factory.ModifyMonitorRule;
import com.clustercontrol.syslogng.factory.SelectMonitorRule;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SyslogNGControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(SyslogNGControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getLogFilterListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"order", (Locale)locale), -1, 50, 131072));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"process", (Locale)locale), 10, 50, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 200, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"calendar", (Locale)locale), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 130, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 130, 16384));
        return tableDefine;
    }

    public ArrayList getFilterInfoList() throws CreateException, FinderException, NamingException {
        SelectMonitorRule select = new SelectMonitorRule();
        return select.getFilterInfoList();
    }

    public boolean createMonitorRuleList(ArrayList filterInfo) throws CreateException, RemoveException, FinderException, NamingException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorRule modify = new ModifyMonitorRule();
        modify.deleteMonitorRule();
        return modify.createMonitorRule(filterInfo, pri.getName());
    }
}

