/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.view;

import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.AutoUpdateView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ScopeListBaseView
extends AutoUpdateView {
    private SashForm treeSash = null;
    private FacilityTreeComposite scopeTreeComposite = null;
    private Composite baseComposite = null;
    private Composite listComposite = null;
    private Label pathLabel = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.treeSash = new SashForm(parent, 256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.treeSash.setLayoutData((Object)gridData);
        this.scopeTreeComposite = new FacilityTreeComposite((Composite)this.treeSash, 0);
        this.baseComposite = new Composite((Composite)this.treeSash, 0);
        this.pathLabel = new Label(this.baseComposite, 0);
        this.pathLabel.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        this.listComposite = this.createListContents(this.baseComposite);
        this.treeSash.setWeights(new int[]{30, 70});
        this.scopeTreeComposite.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FacilityTreeItem selectItem = (FacilityTreeItem)selection.getFirstElement();
                if (selectItem instanceof FacilityTreeItem) {
                    FacilityPath path = new FacilityPath(ClusterControlUIPlugin.getDefault().getSeparator());
                    ScopeListBaseView.this.pathLabel.setText(String.valueOf(Messages.getString((String)"scope")) + " : " + path.getPath(selectItem));
                    ScopeListBaseView.this.baseComposite.layout(true, true);
                    ScopeListBaseView.this.doSelectTreeItem(selectItem);
                }
            }
        });
    }

    protected abstract Composite createListContents(Composite var1);

    protected void doSelectTreeItem(FacilityTreeItem item) {
    }

    public SashForm getTreeSash() {
        return this.treeSash;
    }

    public FacilityTreeComposite getScopeTreeComposite() {
        return this.scopeTreeComposite;
    }

    public Composite getBaseComposite() {
        return this.baseComposite;
    }

    public Composite getListComposite() {
        return this.listComposite;
    }

    public Label getPathLabel() {
        return this.pathLabel;
    }

    public void show() {
        this.treeSash.setMaximizedControl(null);
    }

    public void hide() {
        this.treeSash.setMaximizedControl((Control)this.baseComposite);
    }
}

