/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JobTreeDialog
extends CommonDialog {
    private JobTreeComposite treeComposite = null;
    private boolean m_treeOnly = false;
    private String m_parentJobId = null;
    private String m_jobId = null;

    public JobTreeDialog(Shell parent) {
        super(parent);
        this.m_treeOnly = false;
    }

    public JobTreeDialog(Shell parent, boolean treeOnly) {
        super(parent);
        this.m_treeOnly = treeOnly;
    }

    public JobTreeDialog(Shell parent, String parentJobId, String jobId) {
        super(parent);
        this.m_treeOnly = true;
        this.m_parentJobId = parentJobId;
        this.m_jobId = jobId;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void customizeDialog(Composite parent) {
        parent.getShell().setText(Messages.getString((String)"select.job"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.treeComposite = this.m_jobId == null ? new JobTreeComposite(parent, 0, this.m_treeOnly) : new JobTreeComposite(parent, 0, this.m_parentJobId, this.m_jobId);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.treeComposite.setLayoutData(gridData);
        this.treeComposite.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JobTreeDialog.this.okPressed();
            }
        });
    }

    public JobTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        JobTreeItem item = this.getSelectItem();
        if (item instanceof JobTreeItem) {
            if (item.getData().getType() == -1) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.1"));
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.1"));
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

