/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetCalendarIdList;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ControlComposite
extends Composite {
    protected Button m_waitCondition = null;
    protected Button m_skipCondition = null;
    protected Group m_skipEndConditionGroup = null;
    protected Text m_skipEndValue = null;
    protected Button m_calendarCondition = null;
    protected Group m_calendarConditionGroup = null;
    protected Combo m_calendarId = null;
    protected Text m_calendarEndValue = null;
    protected JobWaitRuleInfo m_waitRule = null;
    protected Shell m_shell = null;

    public ControlComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_calendarCondition = new Button(composite, 32);
        this.m_calendarCondition.setText(Messages.getString((String)"calendar"));
        this.m_calendarCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_calendarCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_calendarConditionGroup.setEnabled(true);
                    ControlComposite.this.m_calendarId.setEnabled(true);
                    ControlComposite.this.m_calendarEndValue.setEnabled(true);
                } else {
                    ControlComposite.this.m_calendarConditionGroup.setEnabled(false);
                    ControlComposite.this.m_calendarId.setEnabled(false);
                    ControlComposite.this.m_calendarEndValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_calendarConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_calendarConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_calendarConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label calendarIdTitle = new Label(composite, 16384);
        calendarIdTitle.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        calendarIdTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_calendarId = new Combo(composite, 16392);
        this.m_calendarId.setLayoutData((Object)new RowData(100, 20));
        ArrayList idList = new GetCalendarIdList().getCalendarIdList();
        if (idList != null) {
            int i = 0;
            while (i < idList.size()) {
                this.m_calendarId.add((String)idList.get(i));
                ++i;
            }
        }
        composite = new Composite((Composite)this.m_calendarConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label calendarEndValueTitle = new Label(composite, 16384);
        calendarEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        calendarEndValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_calendarEndValue = new Text(composite, 2048);
        this.m_calendarEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_calendarEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener());
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Label dummy4 = new Label(composite, 0);
        dummy4.setLayoutData((Object)new RowData(190, 15));
        this.m_waitCondition = new Button(composite, 32);
        this.m_waitCondition.setText(Messages.getString((String)"reserve"));
        this.m_waitCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_waitCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_skipCondition.setSelection(false);
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(false);
                    ControlComposite.this.m_skipEndValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_skipCondition = new Button(composite, 32);
        this.m_skipCondition.setText(Messages.getString((String)"skip"));
        this.m_skipCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_skipCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(true);
                    ControlComposite.this.m_skipEndValue.setEnabled(true);
                    ControlComposite.this.m_waitCondition.setSelection(false);
                } else {
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(false);
                    ControlComposite.this.m_skipEndValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_skipEndConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_skipEndConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_skipEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label skipEndValueTitle = new Label(composite, 16384);
        skipEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        skipEndValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_skipEndValue = new Text(composite, 2048);
        this.m_skipEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_skipEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener());
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule instanceof JobWaitRuleInfo) {
            this.m_calendarCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getCalendar()));
            if (this.m_waitRule.getCalendarId() != null && this.m_waitRule.getCalendarId().length() > 0) {
                this.m_calendarId.select(0);
                int i = 0;
                while (i < this.m_calendarId.getItemCount()) {
                    if (this.m_waitRule.getCalendarId().equals(this.m_calendarId.getItem(i))) {
                        this.m_calendarId.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.m_calendarEndValue.setText(String.valueOf(this.m_waitRule.getCalendarEndValue()));
            this.m_waitCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getSuspend()));
            this.m_skipCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getSkip()));
            this.m_skipEndValue.setText(String.valueOf(this.m_waitRule.getSkipEndValue()));
        } else {
            this.m_calendarCondition.setSelection(false);
            this.m_calendarEndValue.setText(String.valueOf(0));
            this.m_waitCondition.setSelection(false);
            this.m_skipCondition.setSelection(false);
            this.m_skipEndValue.setText(String.valueOf(0));
        }
        if (this.m_calendarCondition.getSelection()) {
            this.m_calendarConditionGroup.setEnabled(true);
            this.m_calendarId.setEnabled(true);
            this.m_calendarEndValue.setEnabled(true);
        } else {
            this.m_calendarConditionGroup.setEnabled(false);
            this.m_calendarId.setEnabled(false);
            this.m_calendarEndValue.setEnabled(false);
        }
        if (this.m_waitCondition.getSelection()) {
            this.m_skipCondition.setSelection(false);
        }
        if (this.m_skipCondition.getSelection()) {
            this.m_skipEndConditionGroup.setEnabled(true);
            this.m_skipEndValue.setEnabled(true);
            this.m_waitCondition.setSelection(false);
        } else {
            this.m_skipEndConditionGroup.setEnabled(false);
            this.m_skipEndValue.setEnabled(false);
        }
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        block9: {
            ValidateResult result;
            block8: {
                result = null;
                if (this.m_waitRule == null) {
                    this.m_waitRule = new JobWaitRuleInfo();
                }
                this.m_waitRule.setCalendar(YesNoConstant.booleanToType((boolean)this.m_calendarCondition.getSelection()));
                if (this.m_calendarId.getText().length() > 0) {
                    this.m_waitRule.setCalendarId(this.m_calendarId.getText());
                } else if (this.m_waitRule.getCalendar() == 1) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.calendar.22"));
                    return result;
                }
                try {
                    this.m_waitRule.setCalendarEndValue(Integer.parseInt(this.m_calendarEndValue.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.m_waitRule.getCalendar() != 1) break block8;
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.21"));
                    return result;
                }
            }
            this.m_waitRule.setSuspend(YesNoConstant.booleanToType((boolean)this.m_waitCondition.getSelection()));
            this.m_waitRule.setSkip(YesNoConstant.booleanToType((boolean)this.m_skipCondition.getSelection()));
            try {
                this.m_waitRule.setSkipEndValue(Integer.parseInt(this.m_skipEndValue.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getSkip() != 1) break block9;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }
}

