/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.action.ModifySystemNotify;
import com.clustercontrol.troubledetection.composite.MonitorComposite;
import com.clustercontrol.troubledetection.composite.NotifyComposite;
import com.clustercontrol.util.Messages;

/**
 * 㳲饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TroubleDetectionDialog extends CommonDialog {
    
	protected MonitorComposite m_monitorComposite = null;
    
    protected NotifyComposite m_notifyComposite = null;

    protected TabFolder m_tabFolder = null;
    
    protected Shell m_shell = null;
    
    protected boolean m_readOnly = false;

    public TroubleDetectionDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.window.Window#getInitialSize()
     */
    protected Point getInitialSize() {
        return new Point(750, 720);
    }

    /* (non-Javadoc)
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();

        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        parent.setLayout(layout);

        parent.getShell().setText(
        		Messages.getString("dialog.trouble.detection"));

        m_tabFolder = new TabFolder(parent, SWT.NONE);
        
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_tabFolder.setLayoutData(gridData);
        
        //ƻ
        m_monitorComposite = new MonitorComposite(m_tabFolder, SWT.NONE);
        TabItem tabItem1 = new TabItem(m_tabFolder, SWT.NONE);
        tabItem1.setText(Messages.getString("end.status"));
        tabItem1.setControl(m_monitorComposite);

        //
        m_notifyComposite = new NotifyComposite(m_tabFolder, SWT.NONE);
        TabItem tabItem2 = new TabItem(m_tabFolder, SWT.NONE);
        tabItem2.setText(Messages.getString("notifications"));
        tabItem2.setControl(m_notifyComposite);

        m_tabFolder.setSelection(0);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData(gridData);
        
        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);
    }

    /* (non-Javadoc)
     * @see com.clustercontrol.dialog.CommonDialog#getOkButtonText()
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /* (non-Javadoc)
     * @see com.clustercontrol.dialog.CommonDialog#getCancelButtonText()
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /* (non-Javadoc)
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {

        //
        NotifyInfo info = m_notifyComposite.createInputData();
        if (info != null) {
        	boolean result = new ModifySystemNotify().modify(info);
            String[] args = { info.getNotifyId() };
            if(result){
                MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                box.setText(Messages.getString("successful"));
                box.setMessage(Messages.getString("message.notify.3",args));
                box.open();
            }
            else{
                MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.notify.4",args));
                box.open();
            }
        }
        else {
            return m_notifyComposite.getValidateResult();
        }

        return null;
    }
}