/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.output;

import java.sql.Timestamp;
import java.util.Calendar;

import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * ơϥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputStatus {
	private static Log log = LogFactory.getLog( OutputStatus.class );

	/**
	 * ơϽ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public boolean outputStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) {
		log.debug("outputStatusInfo start : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());

		boolean result = false;
		
		if(logOutput.isStatusInfoFlg())
		{
			StatusInfoLocal statusInfo = null;
			boolean insertFlg = false;
			
			try
			{
				// ƥƥθ
				StatusInfoPK pk = new StatusInfoPK(logOutput.getMonitorId(), logOutput.getPluginId(),logOutput.getFacilityId());
				statusInfo = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
			}
			catch(FinderException e)
			{
				// ˹פCMPƥƥ¸ߤʤ
				insertFlg = true;
			}
			catch (Exception e)
			{
				log.error("outputStatusInfo():" + e.getMessage());
				//˹פCMPƥƥ¸ߤʤ
				insertFlg = true;
			}
			
			try
			{
				// ƥƥ
				if(insertFlg)
				{
					log.debug("outputStatusInfo insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
					
					insertStatusInfo(logOutput, outputDate);
					result = true;
				}
				//ƥƥι
				else
				{
					log.debug("outputStatusInfo update : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
					
					updateStatusInfo(statusInfo, logOutput, outputDate);
					result = true;
				}
			}
			catch(Exception e)
			{
				log.error("outputStatusInfo():" + e.getMessage());
			}
		}
		
		log.debug("outputStatusInfo end : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
		
		return result;
	}
	
	/**
	 * ơ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public void  insertStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) throws Exception {
	
		try
		{
			// ͭե饰
			Integer expirationFlg = getExpirationFlg(logOutput);
			// ͭ
			Timestamp expirationDate = null;
			
			// ͭ
			if(expirationFlg != null){
		        expirationDate = getExpirationDate(logOutput, outputDate);
			}
			
			StatusInfoUtil.getLocalHome().create(
					logOutput.getFacilityId(),
					logOutput.getMonitorId(),
					logOutput.getPluginId(),
					logOutput.getApplication(),
					logOutput.getMessageId(),
					logOutput.getMessage(),
					new Integer(logOutput.getPriority()),
					new java.sql.Timestamp(logOutput.getGenerationDate().getTime()),
					outputDate,
					expirationFlg,
					expirationDate);
		}
		catch(Exception e)
		{
			throw e;
		}
	}
	
	/**
	 * ơ󹹿
	 * 
	 * @param statusInfo
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public void updateStatusInfo(StatusInfoLocal statusInfo, LogOutputInfo logOutput, Timestamp outputDate) throws Exception{
	
		if(statusInfo != null)
		{
			try
			{
				// ͭե饰
				Integer expirationFlg = getExpirationFlg(logOutput);
				// ͭ
				Timestamp expirationDate = null;
				// ͭ
				if(expirationFlg != null){
			        expirationDate = getExpirationDate(logOutput, outputDate);
				}
				
				statusInfo.setApplication(logOutput.getApplication());
				statusInfo.setMessageId(logOutput.getMessageId());
				statusInfo.setMessage(logOutput.getMessage());
				statusInfo.setPriority(new Integer(logOutput.getPriority()));
//				statusInfo.setGenerationDate(new java.sql.Timestamp(logOutput.getGenerationDate().getTime()));
				statusInfo.setOutputDate(outputDate);
				statusInfo.setExpirationFlg(expirationFlg);
				statusInfo.setExpirationDate(expirationDate);
			}
			catch(Exception e)
			{
				throw e;
			}
		}
	}
	
	/**
	 * ͭե饰֤ޤ
	 * 
	 * @param logOutput
	 * @return
	 */
	private Integer getExpirationFlg(LogOutputInfo logOutput){

		// ͭե饰
		Integer expirationFlg = null;

		if(logOutput != null)
		{
			if(StatusExpirationConstant.TYPE_DELETE  == logOutput.getStatusInvalidFlg()){
				expirationFlg = new Integer(logOutput.getStatusInvalidFlg());
			}
			if(StatusExpirationConstant.TYPE_UPDATE  == logOutput.getStatusInvalidFlg()){
				// ַͭвΰƤʤݤΥå֤ϡ
				// ִν٤ꤹ
				expirationFlg = new Integer(logOutput.getStatusUpdatePriority());	
			}
		}
		return expirationFlg;
	}
	
	/**
	 * ֤ͭޤ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	private Timestamp getExpirationDate(LogOutputInfo logOutput, Timestamp outputDate){

		// ͭ
		Timestamp expirationDate = null;

		if(logOutput != null)
		{
			if(logOutput.getStatusValidPeriod() > 0){
				Calendar cal = null;
				cal = Calendar.getInstance();
				cal.setTime(outputDate);
		        cal.add(Calendar.MINUTE, logOutput.getStatusValidPeriod());
		        expirationDate = new Timestamp(cal.getTimeInMillis());
			}
		}
		return expirationDate;
	}
}
