/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.util.Date;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * OpenLDAPƻ륯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorLdap extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorLdap.class);
	
	/**
	 * ƻ¹
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean providerServer = false;
		boolean consumerServer = false;
		
		try {
			//ץХLDAPѤΥƥȤκ
			InitialContext iniCtx = new InitialContext();
			
			@SuppressWarnings("unused")
			DirContext dirCtx = 
				(InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
			
			providerServer = true;
			
		} catch (NamingException e) {
			log.error("run() : LDAP Connection Error : " + e.getMessage());
		}
		
		try {
			//󥷥塼LDAPѤΥƥȤκ
			InitialContext iniCtx = new InitialContext();
			
			@SuppressWarnings("unused")
			DirContext dirCtx = 
				(InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
			
			consumerServer = true;
			
		} catch (NamingException e) {
			log.error("run() : LDAP Connection Error : " + e.getMessage());
		}
		
		//
		logout(providerServer, consumerServer);
		
		log.debug("run() end :");
	}
	
	/**
	 * 
	 * 
	 * @param providerServer
	 * @param consumerServer
	 */
	protected void logout(boolean providerServer, boolean consumerServer) {
		
		String application = NotifyMessages.getString("ldap.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//ץХ󥷥塼ޥ
		if(providerServer && consumerServer){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("LDAP01");
			//åID
			info.setMessageId("001");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("ldap01.001.message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.001.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.001.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץХа۾󥷥塼ޥ
		else if(!providerServer && consumerServer){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("LDAP01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getLdapProvider()};
			info.setMessage(NotifyMessages.getString("ldap01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.002.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץХ󥷥塼ޥа۾
		else if(providerServer && !consumerServer){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("LDAP01");
			//åID
			info.setMessageId("003");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessage(NotifyMessages.getString("ldap01.003.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.003.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.003.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץХа۾󥷥塼ޥа۾
		else if(!providerServer && !consumerServer){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("LDAP01");
			//åID
			info.setMessageId("004");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("ldap01.004.message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.004.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.004.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * 
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("ldap.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//ξ
		LogOutputInfo info = new LogOutputInfo();
		//ץ饰ID
		info.setPluginId(PLUGIN_ID);
		//ץꥱ
		info.setApplication(application);
		//ƻID
		info.setMonitorId(monitorId);
		//åID
		info.setMessageId(messageId);
		//åꥸʥå
		if(key.equals("ldap02.001")){
			info.setMessage(NotifyMessages.getString(key + ".message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
		}
		else if(key.equals("ldap02.002")){
			String[] args1 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else if(key.equals("ldap03.001")){
			info.setMessage(NotifyMessages.getString(key + ".message"));
			String[] args = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
		}
		else if(key.equals("ldap03.002")){
			String[] args1 = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else{
			info.setMessage(NotifyMessages.getString(key + ".message"));
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		}
		//եƥID
		info.setFacilityId(FACILITY_ID);
		//
		info.setScopeText("");
		//
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//ȯ
		info.setGenerationDate(new Date());
		
		//
		output.outputLog(notifyInfo, info);
	}
}
