/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.io.IOException;
import java.util.Date;
import java.util.Vector;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * JBossƻ륯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorJboss extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorJboss.class);

	protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	protected static final String OBJECT_NAME = "jboss:service=HinemosPartition";
	protected static final String OPERATION_NAME = "getCurrentView";
	
	/**
	 * ƻ¹
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean server1 = false;
		boolean server2 = false;
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
	        
	        //̤JBossΥѡƥؤλäå
	        if(returnObject instanceof Vector){
	        	Vector returnVector = (Vector)returnObject;
	        	
	        	for(int i = 0; i < returnVector.size(); i++){
	        		//host:port
	        		String work = (String)returnVector.get(i);
	        		String node[] = work.split(":");
	        		
	        		//JBoss1IP
	        		if(node[0].equals(this.troubleDetectionInfo.getJbossServer1())){
	        			server1 = true;
	        		}
	        		//JBoss2IP
	        		else if(node[0].equals(this.troubleDetectionInfo.getJbossServer2())){
	        			server2 = true;
	        		}
	        	}
	        }
		} catch (NamingException e) {
			log.error("run() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.error("run() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.error("run() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.error("run() : " + e.getMessage());
		} catch (MBeanException e) {
			log.error("run() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.error("run() : " + e.getMessage());
		} catch (IOException e) {
			log.error("run() : " + e.getMessage());
		}
		
        //
        logout(server1, server2);
        
		log.debug("run() end :");
	}
	
	/**
	 * 
	 * 
	 * @param server1
	 * @param server2
	 */
	protected void logout(boolean server1, boolean server2) {
		
		String application = NotifyMessages.getString("jboss.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//12
		if(server1 && server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("JBOSS01");
			//åID
			info.setMessageId("001");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("jboss01.001.message"));
			String[] args = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.001.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//01
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.001.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//12۾
		else if(server1 && !server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("JBOSS01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getJbossServer2()};
			info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//01
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//1۾2
		else if(!server1 && server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("JBOSS01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getJbossServer1()};
			info.setMessage(NotifyMessages.getString("jboss01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessageOrg(NotifyMessages.getString("jboss01.002.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//01
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("jboss01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * 
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("jboss.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);

		//ξ
		LogOutputInfo info = new LogOutputInfo();
		//ץ饰ID
		info.setPluginId(PLUGIN_ID);
		//ץꥱ
		info.setApplication(application);
		//ƻID
		info.setMonitorId(monitorId);
		//åID
		info.setMessageId(messageId);
		//åꥸʥå
		if(key.equals("jboss02.001")){
			String[] args1 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer1(), 
					this.troubleDetectionInfo.getJbossServer2()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else if(key.equals("jboss03.001")){
			String[] args1 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getJbossServer2(), 
					this.troubleDetectionInfo.getJbossServer1()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else{
			info.setMessage(NotifyMessages.getString(key + ".message"));
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		}
		//եƥID
		info.setFacilityId(FACILITY_ID);
		//
		info.setScopeText("");
		//
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//ȯ
		info.setGenerationDate(new Date());
		
		//
		output.outputLog(notifyInfo, info);
	}
}
