/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.postgresforest.jdbc3.Jdbc3Connection;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * PostgresFprestƻ륯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorForest extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorForest.class);
	
	/**
	 * ƻ¹
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		Connection conn = null;
		ResultSet rs = null;
		
		boolean server1 = false;
		boolean server2 = false;
		
		try {
			InitialContext iniCtx = new InitialContext();
			
			DataSource ds = (DataSource)iniCtx.lookup("java:/HinemosDS");
			conn = ds.getConnection();
			Jdbc3Connection forestConn = 
				(Jdbc3Connection)((WrappedConnection)conn).getUnderlyingConnection();
			rs = forestConn.getGscMetaData().getServer();
			
			while(rs.next()){
				String server = rs.getString(2);
				int status = rs.getInt(3);
				if(server.matches(".*" + this.troubleDetectionInfo.getForest1() + ".*")){
					if(status == 1){
						server1 = true;
					}
				}
				else if(server.matches(".*" + this.troubleDetectionInfo.getForest2() + ".*")){
					if(status == 1){
						server2 = true;
					}
				}
			}
			rs.close();
			
		} catch (NamingException e) {
			log.error("run() : PostgresForest Connection Error : " + e.getMessage());
		} catch (SQLException e) {
			log.error("run() : PostgresForest Connection Error : " + e.getMessage());
		} finally {
			// ͥ󡢷̥åȤΥ
			try {
				if (rs != null) {
					rs.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e) {
				log.error("run() Error : " + e.getMessage());
			}
		}

		//
		logout(server1, server2);
		
		log.debug("run() end :");
	}
	
	/**
	 * 
	 * 
	 * @param server1
	 * @param server2
	 */
	protected void logout(boolean server1, boolean server2) {
		
		String application = NotifyMessages.getString("hinemosdb.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//12
		if(server1 && server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("HINEMOSDB01");
			//åID
			info.setMessageId("001");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("hinemosdb01.001.message"));
			String[] args = {this.troubleDetectionInfo.getForest1(), 
					this.troubleDetectionInfo.getForest2()};
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.001.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.001.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//12۾
		else if(server1 && !server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("HINEMOSDB01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args = {this.troubleDetectionInfo.getForest2()};
			info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//1۾2
		else if(!server1 && server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("HINEMOSDB01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args = {this.troubleDetectionInfo.getForest1()};
			info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//1۾2۾
		else if(!server1 && !server2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("HINEMOSDB01");
			//åID
			info.setMessageId("003");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("hinemosdb01.003.message"));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.003.org.message"));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.003.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * 
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("hinemosdb.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);

		//ξ
		LogOutputInfo info = new LogOutputInfo();
		//ץ饰ID
		info.setPluginId(PLUGIN_ID);
		//ץꥱ
		info.setApplication(application);
		//ƻID
		info.setMonitorId(monitorId);
		//åID
		info.setMessageId(messageId);
		//åꥸʥå
		info.setMessage(NotifyMessages.getString(key + ".message"));
		info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		//եƥID
		info.setFacilityId(FACILITY_ID);
		//
		info.setScopeText("");
		//
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//ȯ
		info.setGenerationDate(new Date());
		
		//
		output.outputLog(notifyInfo, info);
	}
}
