/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;

/**
 * ƻ쥯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public abstract class MonitorBase {
	protected TroubleDetectionInfo troubleDetectionInfo = null;
	protected NotifyInfo notifyInfo = null;
	
    private static final String PRIORITY_INFO = "info";
    private static final String PRIORITY_WARNING = "warning";
    private static final String PRIORITY_CRITICAL = "critical";
    
    protected static final String PLUGIN_ID = "SYSMON";
    protected static final String FACILITY_ID = "SYSTEM";
    
	/**
	 * ƻ¹
	 */
	public abstract void run();
	
	/**
	 * 㳲ξ
	 * 
	 * @param info
	 */
	public void setTroubleDetectionInfo(TroubleDetectionInfo info) {
		troubleDetectionInfo = info;
	}
	
	/**
	 * ξ
	 * 
	 * @param info
	 */
	public void setNotifyInfo(NotifyInfo info) {
		notifyInfo = info;
	}
	
	/**
	 * ټ
	 * 
	 * @param priorityString
	 */
	protected int getPriority(String priorityString) {
		
		//ʸ󤫤٤
		if(PRIORITY_INFO.equalsIgnoreCase(priorityString)) {
			return PriorityConstant.TYPE_INFO;
		}
		else if(PRIORITY_WARNING.equalsIgnoreCase(priorityString)) {
			return PriorityConstant.TYPE_WARNING;
		}
		else if(PRIORITY_CRITICAL.equalsIgnoreCase(priorityString)) {
			return PriorityConstant.TYPE_CRITICAL;
		}
		
		return PriorityConstant.TYPE_UNKNOWN;
	}
}
