/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.syslogng.action.GetLogFilterListTableDefine;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;

/**
 * Ρɰݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogListComposite extends Composite {

    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private LogFilterInfoTableViewer tableViewer = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public LogListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new LogFilterInfoTableViewer(table);
        this.tableViewer.createTableColumn(GetLogFilterListTableDefine.get());

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        // syslog-ng
        LogManager.getInstance().initialize();
        this.update();
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public LogFilterInfoTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * 򤵤Ƥ륢ƥ֤ޤ
     * <p>
     * 
     * 򤵤Ƥʤϡnull֤ޤ
     * 
     * @return 򥢥ƥ
     */
    public LogFilterInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection) this.tableViewer
                .getSelection();

        if (selection == null) {
            return null;
        } else {
            return (LogFilterInfo) selection.getFirstElement();
        }
    }

    /**
     * ݥåȤ򹹿ޤ
     * <p>
     * 
     * 郎ꤵƤ硢ξ˥ҥåȤΡɤΰ ɽޤ <br>
     * 郎ꤵƤʤϡΡɤɽޤ
     */
    public void update() {
        // ǡ
        Object[] list = LogManager.getInstance().get();

        // ơ֥빹
        this.tableViewer.setInput(list);
    }
    
    /**
     * 򤵤줿ԤΥID
     * 
     * @return 
     */
    public ArrayList<LogFilterInfo> getSelectionData() {
    	
    	ArrayList<LogFilterInfo> data = new ArrayList<LogFilterInfo>();
    	
    	//򤵤줿ƥ
    	StructuredSelection selection = 
    		(StructuredSelection)tableViewer.getSelection();
    	List list = (List)selection.toList();
    	
    	if (list != null) {
    		for(int index = 0; index < list.size(); index++){
    			
    			LogFilterInfo info = (LogFilterInfo)list.get(index);
    			if (info instanceof LogFilterInfo) {
    				data.add(info);
    			}
    		}
    	}
    	
    	return data;
    }
}