/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;

/**
 * å.
 * åꡢե륿󥰽Ԥ å
 *  
 * @version 2.1.0.0
 * @since
 */
public class LogManager extends Thread {

	private final static String TXT_FILE_PATH = "msg.file.txt.path";

	private final static String TXT_FILE_SUFFIX = "msg.file.txt.syffix";
	
	private final static String MULTI_ID = "multi.id";

	private FileUtil m_fileUtil;

	private EJBContoroler m_ejbControl;
	
	private UpdateRepositoryInfoReceiveTopic m_updateRepository;

	/** å塼 */
	private LinkedList<Object> m_msgList = new LinkedList<Object>();

	/** ե륿 */
	private ArrayList m_filterList = null;

	/** Ե֥ե饰 */
	private boolean m_waiting = false;

	/** å顼ե饰 */
	private boolean m_processErr = true;
	
	/** ¿ŲID */
	private String m_multiId = null;

	//
	private Log log = LogFactory.getLog(this.getClass());

	/**
	 * @param props
	 */
	public LogManager(Properties props) {
		setName("LogManager");

		String filePath = props.getProperty(TXT_FILE_PATH, ".");
		String msgSuffix = props.getProperty(TXT_FILE_SUFFIX, ".txt");

		m_fileUtil = new FileUtil(filePath, msgSuffix);

		m_ejbControl = new EJBContoroler(this, props);
		
		m_updateRepository = new UpdateRepositoryInfoReceiveTopic(m_ejbControl, props);
		
		m_multiId = props.getProperty(MULTI_ID, null);
		
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {

		log.debug("Thread Start!!");

		while (true) {

			Object msg = null;

			//׵Ԥ
			synchronized (this) {

			    msg = getMsg();
				if (msg == null) {
					//åʤΤǽԤ
					log.debug(getName() + ": Waiting for processing...");
					m_waiting = true;
					try {
						wait();
					} catch (InterruptedException e) {
						break;
					}

					m_waiting = false;
					continue;
				}

			}


			//å
			if (msg instanceof String) {
				log.debug("proccess msg:" + msg);
				//å夬ǤʤȤϥեؽ
				if (m_filterList == null) {
					log.debug("file output msg:" + msg);
					m_fileUtil.write((String) msg);
					m_processErr = true;
					continue;
				}

				//å
				proccess((String) msg);

			//ե륿
			} else if (msg instanceof ArrayList) {
				
				log.debug("ե륿:");

				//ե륿Ǽ
				m_filterList = (ArrayList) msg;

				//顼֤ξ硢
				if(m_processErr){
					//ե˽ϤƤåޤ롣
					processRetry();
					m_processErr = false;
				}
			}

		}

		//λ
		terminate();

		log.debug("Thread End!!");

	}

	/**
	 * å.
	 * syslogåӥե륿
	 * @param o
	 * @return
	 */
	public void add(Object obj) {

	    boolean notifyFlg = false;
	    
	    synchronized (m_msgList) {
			if (m_msgList.size() == 0) {
			    notifyFlg = true;
			}

			
			//å
			if (obj instanceof String) {
				//å
				m_msgList.add(obj);
			} else if (obj instanceof ArrayList) {
				//ե륿(QueƬɲ)
				m_msgList.add(0, obj);

			}

		}

		if ( notifyFlg && isWaiting() ) {
			//åɤ˽ϻؼ
			synchronized (this) {
				this.notify();
			}
		}
		
	}

	/**
	 * åФ åѤQue1åФ åʤȤnull֤
	 * 
	 * @return
	 */
	protected Object getMsg() {
		synchronized (m_msgList) {
			try {
				return m_msgList.removeFirst();

			} catch (NoSuchElementException e) {
				return null;
			}

		}
	}

	/**
	 * @return waiting ᤷޤ
	 */
	synchronized public boolean isWaiting() {
		return m_waiting;
	}

	/**
	 * åϽϽ
	 * @param msg
	 */
	protected void proccess(String msg) {

		//åѡ
		MessageInfo logmsg = MessageParser.parse(msg);
		if (logmsg == null) {
			return;
		}
		//ե륿ΥꥹȤǽ֤˥ե륿
		for (Iterator iter = m_filterList.iterator(); iter.hasNext();) {

			//
			//եƥIDоݥΡɤɤå
			//
			LogFilterRepositoryInfo filterRepInfo = (LogFilterRepositoryInfo) iter
					.next();
			String facilityID = filterRepInfo.contains(logmsg.getHostName());
			if (facilityID == null) {
				continue;
			}

			//
			//åǥޥå
			//
			LogFilterInfo filterInfo = filterRepInfo.getFilter();
			String pattern = filterInfo.getPattern();

			try {
                if (logmsg.getMessage().matches(pattern)) {
                	//ޥå硢
                	//ʤʤСλ
                	if (filterInfo.getProcessType() == ProcessConstant.TYPE_YES) {

                		log.debug("Process:" + filterInfo.getDescription() + ":"
                				+ msg);
                		
                		// ưɤ
                		if(filterInfo.getCalendarId() == null || 
                				m_ejbControl.isRun(filterInfo.getCalendarId(), logmsg.getGenerationDate())){
                			
                			//
                    		//å
                    		//
                			

                    		//å
                    		LogOutputNotifyInfo logOutput = makeMessage(msg, logmsg,
                    				filterRepInfo, facilityID);


                    		//å
                    		m_ejbControl.sendMsg(logOutput);
                		}
                		
                	} else {

                		log.debug("Non Process:" + filterInfo.getDescription()
                				+ ":" + msg);
                	}

                	return;
                }
            } catch (Exception e) {
                log.error("ե륿郎̵;"+filterInfo.getDescription(),e);
            }
		}

		log.debug("ե륿ʤ:" + msg);
		return;

	}

	/**
	 * ϥå֥Ⱥ
	 * @param msg
	 * @param logmsg
	 * @param filterRepInfo
	 * @param facilityID
	 * @return
	 * @version 2.1.0
	 * @since 1.0.0
	 */
	private LogOutputNotifyInfo makeMessage(String msg, MessageInfo logmsg,
			LogFilterRepositoryInfo filterRepInfo, String facilityID) {

		
		log.debug("Make ObjectMsg");

		
		LogFilterInfo filterInfo = filterRepInfo.getFilter();

//		LogOutputInfo logOutput = new LogOutputInfo();
		LogOutputNotifyInfo logOutput = new LogOutputNotifyInfo();
		
		logOutput.setPluginId("SLOGNG");
		logOutput.setMonitorId(filterInfo.getMonitorId());
		logOutput.setFacilityId(facilityID);
		logOutput.setScopeText(filterRepInfo.getNodeName(facilityID));
		logOutput.setApplication(filterInfo.getApplication());
		logOutput.setMessageId(filterInfo.getMessageId());
		logOutput.setMessage(filterInfo.getMessage());
		logOutput.setMessageOrg(msg);
		logOutput.setPriority(filterInfo.getPriority());
//		logOutput.setConfirmFlg( ConfirmConstant.booleanToType(filterInfo.isConfirmFlg()) );
		logOutput.setGenerationDate(logmsg.getGenerationDate());

		logOutput.setNotifyId(filterInfo.getNotifyId());
		if(m_multiId != null && !"".equals(m_multiId)){
			logOutput.setMultiId(m_multiId);	
		}
		
		if(filterInfo.getJobRun() == YesNoConstant.TYPE_YES){
			LogOutputJobRunInfo jobRunInfo = new LogOutputJobRunInfo();
			jobRunInfo.setJobRun(filterInfo.getJobRun());
			jobRunInfo.setJobId(filterInfo.getJobId());
			jobRunInfo.setJobInhibitionFlg(filterInfo.getJobInhibitionFlg());
			jobRunInfo.setJobFailurePriority(filterInfo.getJobFailurePriority());
			logOutput.setJobRun(jobRunInfo);
		}

//		logOutput.setEventLogFlg(filterInfo.isNotifyFlg());
//		logOutput.setStatusInfoFlg(false);
		
//		int exflg =  filterInfo.getExclusionFlg();
//		switch (exflg) {
//		case ExclusionConstant.TYPE_FREQUENCY:
//			
//			logOutput.setExcludePeriod(0);
//			logOutput.setExcludeNumber(filterInfo.getExclusionFrequency());
//			break;
//		case ExclusionConstant.TYPE_PERIOD:
//			
//			logOutput.setExcludePeriod(filterInfo.getExclusionPeriod());
//			logOutput.setExcludeNumber(0);
//			break;
//
//		default:
//			logOutput.setExcludePeriod(0);
//			logOutput.setExcludeNumber(0);
//			break;
//		}

//		if (filterInfo.isMailFlg()) {
//			String address = filterInfo.getMailAddress();
//			StringTokenizer t = new StringTokenizer(address, ";");
//			ArrayList addressList = new ArrayList();
//			while (t.hasMoreTokens()) {
//				addressList.add(t.nextToken());
//
//			}
//			logOutput.setAddress((String[]) addressList.toArray(new String[0]));
//		}
		return logOutput;
	}

	/**s
	 * å
	 *  
	 */
	synchronized private void processRetry() {

		log.info("åƽ!");

		//ե
		Collection col = m_fileUtil.getFileList();

		for (Iterator iter = col.iterator(); iter.hasNext();) {
			File file = (File) iter.next();
			//եɤ߹
			String msg = m_fileUtil.readTxtFile(file);

			//
			proccess(msg);
			//ե
			file.delete();
		}

	}
	/**
	 * ³νλ
	 *  
	 */
	private void terminate() {

		m_ejbControl.terminate();
		
		m_updateRepository.terminate();
	}

}
