/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * syslogžᥤ󥯥饹
 * ɸϤǥåꡢ饹Ϥ
 * 
 * @version $Revision: 1.10 $
 * @since
 */
public class LogForward {

	private LogManager m_manageLog;

	//
	static Log log = LogFactory.getLog(LogForward.class);

	/**
	 * 
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		log.debug("Start");

		LogForward logForward = new LogForward(args[0]);

		try {
			logForward.forward();
		} catch (Exception e) {
			log.error(e);
		}

		System.exit(0);

		log.debug("End");
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @throws Exception
	 */
	LogForward(String propFileName) throws Exception {

	
		//ץѥƥեɤ߹
		Properties props = new Properties();
		props.load(new FileInputStream(propFileName));

		m_manageLog = new LogManager(props);

		//åɤ򳫻
		m_manageLog.start();
		//åԵԤ
		while (true) {
			if (m_manageLog.isWaiting())
				break;
		}
		
		//λƤӽФ
    	Runtime.getRuntime().addShutdownHook(new Thread() {
    	    public void run() { m_manageLog.interrupt(); }
    	});
		
	}

	/**
	 * å
	 * 
	 * @param msg
	 */
	private void put(String msg) {

		if (msg == null || msg.equals(""))
			return;

		log.debug("put Message:" + msg);

		m_manageLog.add(msg);

	}

	/**
	 * åž
	 * 
	 * @throws Exception
	 */
	public void forward() throws Exception {

		log.debug("Read InputStaream");

		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		while (true) { /* ɸԤ */
			try {
				//1Լå
				put(br.readLine());
			} catch (IOException e) {
				log.error(e);
				break;
			}
		}
		m_manageLog.interrupt();
	}

}
