/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * եϥ饹.
 * Ŭåӥϥå֥ȤΥեؤ
 * @version 1.0.0
 * @since 1.0.0
 */
public class FileUtil {



	private String m_filePath = ".";
	
	private String m_fileSuffix = ".txt";
	
	
	//
	static Log log = LogFactory.getLog(FileUtil.class);

	private SimpleDateFormat m_dtFmt = new SimpleDateFormat("yyyyMMddHHmmss");

	private DecimalFormat m_numFmt = new DecimalFormat("-000");

	/**
	 * 󥹥ȥ饯
	 */
	public FileUtil(String Path, String Suffix) {

		m_filePath = Path;
		m_fileSuffix = Suffix;

	}

	/**
	 * åϡʥե
	 * 
	 * @param msg
	 */
	public void write(Object msg) {
		//ե̾
		File fi = getFileName();

		// FileOutputStream饹λȷѿ
		// ǺäƤΤfinallyclose()᥽åɤƤ֤Ǥ
		FileOutputStream fileOutputStream = null;
		try {

			// եѤΥȥ꡼Ǥ
			fileOutputStream = new FileOutputStream(fi);

			// 񤭹९饹ObjectOutputStream饹ޤ
			ObjectOutputStream objectOutputStream = new ObjectOutputStream(
					fileOutputStream);

			// ǡ񤭹ߤޤ
			objectOutputStream.writeObject(msg);
			objectOutputStream.flush();

		} catch (IOException e) {
			log.error(msg, e);
		} finally {
			try {
				if (fileOutputStream != null) {
					fileOutputStream.close();
				}
			} catch (Exception e) {
			}
		}
	}

	/**
	 * åϡʥե
	 * 
	 * @param msg
	 */
	public void write(String msg) {
		//ե̾
		File fi = getFileName();

		BufferedWriter writer = null;

		//ե
		try {

			writer = new BufferedWriter(new FileWriter(fi));

			writer.write(msg, 0, msg.length());

		} catch (IOException e) {
			log.error(msg, e);
		} finally {
			try {
				if (writer != null) {
					writer.flush();
					writer.close();
				}
			} catch (Exception e) {
			}
		}
	}

	/**
	 * 
	 * @param Path
	 * @param Suffix
	 * @return
	 */
	private File getFileName() {
		File fi = null;
		String filenameDate = m_dtFmt.format(new Date());
		StringBuffer fileNameFull = new StringBuffer(filenameDate);
		int i = 0;
		while (true) {
			fileNameFull.append(m_numFmt.format(i++));
			fileNameFull.append(m_fileSuffix);
			fi = new File(m_filePath, fileNameFull.toString());
			if (!fi.exists())
				break;

			fileNameFull.delete(filenameDate.length(), fileNameFull.length());

		}
		return fi;
	}

	/**
	 * ƥȥåɤ߹
	 * 
	 * @param file
	 * @return
	 */
	public String readTxtFile(File file) {

		//
		StringBuffer msg = new StringBuffer();
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(file));
			String line;
			while ((line = reader.readLine()) != null) {
				msg.append(line);
			}
		} catch (Exception e) {
			log.error(e);
			return null;
		} finally {
			try {
				if (reader != null) {
					reader.close();
				}
			} catch (Exception e) {
			}
		}
		return msg.toString();
	}

	/**
	 * åեɤ߹
	 * 
	 * @param file
	 * @return
	 */
	public Object readMsgFile(File file) {

		Object ret = null;
		FileInputStream fileInputStream = null;
		try {
			// եѤΥȥ꡼Ǥ
			fileInputStream = new FileInputStream(file);

			// ɤ߹९饹ObjectInputStream饹ޤ
			ObjectInputStream objectInputStream = new ObjectInputStream(
					fileInputStream);

			// ǡФޤ
			ret = objectInputStream.readObject();

		} catch (IOException e) {
			log.error(e);
		} catch (ClassNotFoundException e) {
			log.error(e);
		} finally {
			try {
				if (fileInputStream != null) {
					fileInputStream.close();
				}
			} catch (IOException e) {
			}
		}
		return ret;

	}

	
	/**
	 * եꥹȼ. ꤵ줿ѥ۲ǡꤵ줿ĥҤΥեΥꥹȤ ե̾ǥȤCollection֤
	 * 
	 * @param Path
	 * @param Suffix
	 * @return FileCollection
	 */
	public Collection getFileList() {

		//ե
		File dir = new File(m_filePath);
		File[] files = dir.listFiles();

		//ե̾ΥȤȥե륿
		TreeMap<String, File> tree = new TreeMap<String, File>();
		for (int i = 0; i < files.length; i++) {
			if (!files[i].getName().endsWith(m_fileSuffix)) {
				continue;
			}
			tree.put(files[i].getName(), files[i]);
		}
		return tree.values();

	}
	


}
