/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.sql.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DB饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AccessDB{
	protected static Log m_log = LogFactory.getLog( ControlSqlInfo.class );
	
	/** Connectionؤλ */
	protected Connection m_connection = null;
	
	/** Statementؤλ */
	protected Statement m_statement = null;
	
	/** JDBCɥ饤 */
	protected String m_jdbcDriver = null;
	
	/** ³ʸ */
	protected String m_url = null;
	
	/** 桼 */
	protected String m_user = null;
	
	/** ѥ */
	protected String m_password = null;
	
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param driver JDBCɥ饤
	 * @param url ³ʸ
	 * @param user 桼
	 * @param password ѥ
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	public AccessDB(String driver, String url, String user, String password) throws SQLException, ClassNotFoundException {
		this.m_jdbcDriver = driver;
		this.m_url = url;
		this.m_user = user;
		this.m_password = password;
		
		initial();
	}
	
	/**
	 * DB³ν
	 * 
	 * @throws SQLException
	 * @throws ClassNotFoundException 
	 */
	private void initial() throws SQLException, ClassNotFoundException
	{
		//JDBCɥ饤ФΥ
		try {
			Class.forName(m_jdbcDriver);
		} catch (ClassNotFoundException e) {
			m_log.error("initialize(): ", e);
			throw e;
		}
		
		Properties prop = new Properties();
		prop.put("user", m_user);
		prop.put("password", m_password);
		
		try {
			m_connection = DriverManager.getConnection(m_url, prop);
			
			//SQLʸ¹Ԥ뤿Statement饹
			m_statement = m_connection.createStatement(
					ResultSet.TYPE_SCROLL_INSENSITIVE,
					ResultSet.CONCUR_READ_ONLY);
			
		} catch (SQLException e) {
			m_log.error("initialize(): ", e);
			
			try {
				if(m_statement != null)
					m_statement.close();
			} catch (SQLException se) {
				m_log.error("initialize(): ", se);
			}
			try {
				if(m_connection != null)
					m_connection.close();
			} catch (SQLException se) {
				m_log.error("initialize(): ", se);
			}
			throw e;
		}
	}
	
	/**
	 * ꤵ줿SQLʸ¹ԡɤ߹ߡ
	 * 
	 * @param sql SQLʸ
	 * @return
	 * @throws SQLException
	 */
	public ResultSet read(String sql) throws SQLException
	{
		ResultSet result = null;
		try
		{
			result = m_statement.executeQuery(sql);
			
		}catch (SQLException e)		{
			m_log.error("read(): ", e);
			throw e;
		}
		return result;
	}
	
	/**
	 * DB³νλ
	 * 
	 */
	public void terminate(){
		
		try {
			if(m_statement != null)
				m_statement.close();
		} catch (SQLException e) {
			m_log.error("terminate(): ", e);
		}
		
		try {
			if(m_connection != null)
				m_connection.close();
		} catch (SQLException e) {
			m_log.error("terminate(): ", e);
		}
	}
}