/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.factory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;
import com.clustercontrol.sql.util.AccessDB;
import com.clustercontrol.util.Messages;

/**
 * SQLƻ ʹƻѼ¹ԥ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class RunMonitorSql extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorSql.class );

	public static final String MESSAGE_ID_UNKNOWN = "100";
	
	/** SQLƻ */
	protected MonitorSqlInfoLocal m_sql = null;
	
	/** ³ʸ */
	protected String m_url = null;
	
	/** 桼 */
	protected String m_user = null;
	
	/** ѥ */
	protected String m_password = null;
	
	/**  */
	protected String m_query = null;
	
	/** JDBCɥ饤 */
	protected String m_jdbcDriver = null;
	
	/** å */
	protected String m_unKnownMessage = null;
	
	/** ꥸʥå */
	protected String m_messageOrg = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorSql() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * ƻ¹
	 * 
	 * @param monitorTypeId ƻƻоID
	 * @param monitorId ƻID
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws JMSException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@Override
	public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, CreateException {
		
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;
		
		m_now = new Date();
		
		
		try 
		{
			// ƻܾ
			boolean run = setMonitorInfo(m_monitorTypeId, m_monitorId);
			if(!run){
				// λ
				return;
			}
			
			// Ƚ
			setJudgementInfo();
			
			// ƻå
			setCheckInfo();

			// ƻͤ
			boolean ret = collect(null);

			// ƻͤȽ̤
			int checkResult = getCheckResult(ret);
			
			m_nodeDate = new Date().getTime();
			
			// ƻ
			notify(true, m_facilityId, checkResult, new Date(m_nodeDate));

		} catch (FinderException e) {
            m_log.error("run():" + e.getMessage());
			throw e;
		} catch (JMSException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		} catch (CreateException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		}
		finally{
			// λ
			this.terminate();
		}
	}

	/**
	 * SQL
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	public boolean collect(String facilityId) {
		boolean result = false;
		
		AccessDB access = null;
		ResultSet rSet = null;
		try {
			// DB³
			access = new AccessDB(
					m_jdbcDriver, 
					m_url, 
					m_user, 
					m_password);
			
			// SQLʸ¹Ԥ̤Ф
        	if(m_query.length() >= 6){
        		String work = m_query.substring(0, 6);
    			if( work.equalsIgnoreCase("SELECT")){
    				rSet = access.read(m_query);

    				//1쥳ܤ1ܤΥǡ
    				rSet.first();
    				float count = rSet.getFloat(1);
    				m_value = count;
    				
    				//쥳ɷ
    				rSet.last();
    				int number = rSet.getRow();
    				
    				NumberFormat numberFormat = NumberFormat.getNumberInstance();
    				m_messageOrg = Messages.getString("record.value") + " : " + numberFormat.format(m_value) + ", " + 
    					Messages.getString("records.number") + " : " + numberFormat.format(number);

    				result = true;
    			}
    			else{
    				//SELECTʸʳϥ顼
    				m_log.debug("collect(): " + Messages.getString("message.sql.5"));
    				m_unKnownMessage = Messages.getString("message.sql.5");
    				m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
    			}
        	}
        	else{
				//SELECTʸʳϥ顼
				m_log.debug("collect(): " + Messages.getString("message.sql.5"));
				m_unKnownMessage = Messages.getString("message.sql.5");
				m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
			}
		} catch (ClassNotFoundException e) {
			m_unKnownMessage = Messages.getString("message.sql.6");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
		} catch (SQLException e) {
			// SQL¹ԥ顼
			m_unKnownMessage = Messages.getString("message.sql.7");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
		} finally {
			try {
				if(rSet != null){
					rSet.close();
				}
				if(access != null){
					// DB³λ
					access.terminate();
				}
			} catch (SQLException e) {
				m_log.error("collect(): ", e);
			}
		}
		return result;
	}
	
	/* (non-Javadoc)
	 * SQLƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// SQLƻ
		MonitorSqlInfoPK pk = new MonitorSqlInfoPK(m_monitorId, m_monitorTypeId);
		m_sql = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SQLƻ
		m_url = m_sql.getConnection_url().trim();
		m_user = m_sql.getConnection_user().trim();
		m_password = m_sql.getConnection_password().trim();
		m_query = m_sql.getQuery().trim();
		m_jdbcDriver = m_sql.getJdbc_driver().trim();
	}
	
	/* ( Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {
		
		String messageId = super.getMessageId(id);
		if(messageId == null || "".equals(messageId)){
			return MESSAGE_ID_UNKNOWN;
		}
		return messageId;
	}
	
	/* ( Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		
		String message = super.getMessage(id);
		if(message == null || "".equals(message)){
			return m_unKnownMessage;
		}
		return message;
	}

	/* ( Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
}
