/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlRunManagementHome;
import com.clustercontrol.sql.util.ControlSqlInfo;

/**
 * SQLƻ ʹƻϿ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class AddMonitorSql extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorSql.class );
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// SQLƻɲ
		ControlSqlInfo sql = new ControlSqlInfo(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		return sql.add((MonitorSqlInfo)m_monitorInfo.getCheckInfo());
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorSqlRunManagementHome.JNDI_NAME;
	}
}
