/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.ejb.session.MonitorSqlControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * EJBȤΥͥ륯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class EjbConnectionManager {
    private static EjbConnectionManager m_instance = null;
    private NamingContext m_ctx = null;

    /**
     * Υ֥Ȥޤ
     * 
     * @return ConnectionManager ͥޥ͡
     */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * ProcessControllerޤ
     * 
     * @return MonitorController
     */
    public synchronized MonitorSqlController getSqlController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }

        MonitorSqlControllerHome home;
        try {
            home = (MonitorSqlControllerHome) m_ctx
                    .lookup(MonitorSqlControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}