/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.action.GetSnmpTrapModifyProperty;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ȥåѹ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapModifyDialog extends CommonDialog {
    /** ץѥƥ */
    protected PropertySheet viewer = null;

    private Shell shell = null;

    private MonitorSnmpTrapOidInfo oidInfo = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     */
    public SnmpTrapModifyDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        shell = this.getShell();

        parent.getShell().setText(Messages.getString("dialog.snmptrap.modify.definition"));

        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        Label tableTitle = new Label(parent, SWT.NONE);
        tableTitle.setText(Messages.getString("attribute") + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData(gridData);

        TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
                | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        viewer = new PropertySheet(table);

        viewer.setInput(new GetSnmpTrapModifyProperty().getProperty());

        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation(
                (display.getBounds().width - shell.getSize().x) / 2, (display
                        .getBounds().height - shell.getSize().y) / 2);

        //Ͼȿ
        reflectOidInfo();

        viewer.expandAll();
    }

    /**
     * OIDȿ
     *  
     */
    private void reflectOidInfo() {
        Property property = null;

        if (oidInfo instanceof MonitorSnmpTrapOidInfo) {
        	
            //Ƚоݤ֤ξ
            property = new GetSnmpTrapModifyProperty().getProperty();
            
            //MIB
            ArrayList propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_MIB);
            Property mib = (Property) propertyList.get(0);
            mib.setValue(oidInfo.getMib());

            //ȥå̾
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_TRAP_NAME);
            Property trapName = (Property) propertyList.get(0);
            trapName.setValue(oidInfo.getTrapName());
            
            //ȥåOID
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_TRAP_OID);
            Property trapOid = (Property) propertyList.get(0);
            trapOid.setValue(oidInfo.getTrapOid());
            
            //generic_id
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_GENERIC_ID);
            Property genericId = (Property) propertyList.get(0);
            genericId.setValue(Integer.toString(oidInfo.getGenericId()));
            
            //specific_id
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_SPRCIFIC_ID);
            Property specificId = (Property) propertyList.get(0);
            specificId.setValue(Integer.toString(oidInfo.getSpecificId()));
            
            //̵ͭ
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_VALID);
            Property valid = (Property) propertyList.get(0);
            valid.setValue(new Boolean(YesNoConstant.typeToBoolean(oidInfo.getValidFlg())));
            
            //
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_PRIORITY);
            Property priority = (Property) propertyList.get(0);
            priority.setValue(PriorityConstant.typeToString(oidInfo.getPriority()));
            
            //å
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_LOGMSG);
            Property logmsg = (Property) propertyList.get(0);
            logmsg.setValue(oidInfo.getLogmsg());
            
            //ܺ٥å
            propertyList = 
            	PropertyUtil.getProperty(
            		property, GetSnmpTrapModifyProperty.ID_DESCR);
            Property descr = (Property) propertyList.get(0);
            descr.setValue(oidInfo.getDescr());
            
            viewer.setInput(property);

            //ӥ塼
            viewer.refresh();
        }
    }

    /**
     * OID
     *  
     */
    @SuppressWarnings("unchecked")
	private ValidateResult createOidInfo() {
        ValidateResult result = null;
        
        if (oidInfo instanceof MonitorSnmpTrapOidInfo) {
	        Property property = (Property) viewer.getInput();
	
	        //̵ͭ
	        ArrayList values = PropertyUtil.getPropertyValue(
	        		property, GetSnmpTrapModifyProperty.ID_VALID);
	        Boolean valid = (Boolean) values.get(0);
	        oidInfo.setValidFlg(YesNoConstant.booleanToType(valid.booleanValue()));
	
	        //٤
	        values = PropertyUtil.getPropertyValue(
	        		property, GetSnmpTrapModifyProperty.ID_PRIORITY);
	        String priority = (String) values.get(0);
	        oidInfo.setPriority(PriorityConstant.stringToType(priority));
	
	        //å
	        values = PropertyUtil.getPropertyValue(
	        		property, GetSnmpTrapModifyProperty.ID_LOGMSG);
	        String logmsg = (String) values.get(0);
	        oidInfo.setLogmsg(logmsg);
	
	        //ܺ٥å
	        values = PropertyUtil.getPropertyValue(
	        		property, GetSnmpTrapModifyProperty.ID_DESCR);
	        String descr = (String) values.get(0);
	        oidInfo.setDescr(descr);
        }
        
        return null;
    }

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    /**
     * ͤꤹ
     * 
     * @param oidInfo
     * @return
     */
    public void setInputData(MonitorSnmpTrapOidInfo oidInfo) {
        this.oidInfo = oidInfo;
    }

    /**
     * ͤ
     * 
     * @return
     */
    public MonitorSnmpTrapOidInfo getInputData() {
        return oidInfo;
    }

    /**
     * ϣ˥ܥƥȼ
     * 
     * @return ϣ˥ܥΥƥ
     * @since 1.0.0
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥƥȼ
     * 
     * @return 󥻥ܥΥƥ
     * @since 1.0.0
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createOidInfo();
        if (result != null) {
            return result;
        }

        return null;
    }
}