/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.snmptrap.action.GetSnmpTrap;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.composite.OidListComposite;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAPƻѹ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;
	
	// ----- instance ե ----- //
	
	/** ͤݻ륪֥ */
	private MonitorSnmpTrapInfo inputData = null;
	
	/** ͤݻ륪֥ */
	private ValidateResult validateResult = null;
	
	/** ѹоݤδƻID */
	private String monitorId = null;
	
	/** ƻܾ */
	private MonitorBasicScopeComposite monitorBasicComposite = null;
	
	/** ߥ˥ƥ̾ */
	private Text textCommunityName = null;
	
	/** OIDơ֥ */
	private OidListComposite oidListComposite = null;
	
    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;
    
	/** ξ */
	private NotifyInfoComposite notifyInfoComposite = null;
	
	/** ͭˤ */
	private Button confirmValid = null;
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * ѥΥ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 * @param monitorType ƻȽ꥿
	 */
	public SnmpTrapCreateDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}
	
	/**
	 * ѹѥΥ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 * @param monitorId ѹƻID
	 * @param monitorType ƻȽ꥿
	 */
	public SnmpTrapCreateDialog(Shell parent, String monitorId) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
		
		this.monitorId = monitorId;
	}

	// ----- instance ᥽å ----- //
    
    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(750, 750);
    }
	
	/**
	 * ꥢޤ
	 * 
	 * @param parent
	 *            ƤΥ󥹥
	 */
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();
		
		// ȥ
		shell.setText(Messages.getString("dialog.snmptrap.create.modify"));
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		// 쥤
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 15;
		parent.setLayout(layout);
		
		// ƻܾ
		monitorBasicComposite = new MonitorBasicScopeComposite(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		monitorBasicComposite.setLayoutData(gridData);

		/*
		 * ȥå롼
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("trap.definition") + " : ");
		
		// 롼
		Group groupCheckRule = new Group(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 15;
		groupCheckRule.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		groupCheckRule.setLayoutData(gridData);
		
		/*
		 * ߥ˥ƥ̾
		 */
		// ٥
		label = new Label(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("community.name") + " : ");
		// ƥ
		this.textCommunityName = new Text(groupCheckRule, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.textCommunityName.setLayoutData(gridData);
		// 
		label = new Label(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
		/*
		 * OIDơ֥
		 */
		// ƥ
		this.oidListComposite = new OidListComposite(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.oidListComposite.setLayoutData(gridData);
        
		/*
		 * ξ°롼
		 */
		// ٥
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("notify.attribute") + " : ");
		
		// 롼
		Group groupNotifyAttribute = new Group(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		groupNotifyAttribute.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupNotifyAttribute.setLayoutData(gridData);
		
		// ξIDץꥱID¹ԡ
		this.notifyInfoComposite = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		notifyInfoComposite.setLayoutData(gridData);
		
		/*
		 * ̵ͭ
		 */
		this.confirmValid = new Button(parent, SWT.CHECK);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.confirmValid.setLayoutData(gridData);
		this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));
		
		// 饤
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 15;
		line.setLayoutData(gridData);
		
		// 
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
		
		// ɽ
		MonitorSnmpTrapInfo info = null; 
		if(this.monitorId == null){
			// ξ
			info = new MonitorSnmpTrapInfo();
			info.setOidInfos(new ArrayList<MonitorSnmpTrapOidInfo>());
		}
		else{
			// ѹξ硢
			info = new GetSnmpTrap().getSnmp(this.monitorId);
		}
		this.setInputData(info);
		
	}
	
	/**
	 * Ƥ֤ޤ
	 * 
	 * @return Ƥݻξ
	 */
	public MonitorSnmpTrapInfo getInputData() {
		return this.inputData;
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param monitor
	 *            ͤȤѤƻ
	 */
	protected void setInputData(MonitorSnmpTrapInfo monitor) {
		
		// ƻܾ
		monitorBasicComposite.setInputData(monitor);
		
		// ߥ˥ƥ̾
		if(monitor.getCommunityName() != null){
			textCommunityName.setText(monitor.getCommunityName());
		}
		
		//OID
		oidListComposite.setMonitorId(monitor.getMonitorId());
		oidListComposite.setOidList(monitor.getOidInfos());
		oidListComposite.update();
		
		// ξ°
		if (monitor.getNotifyId() != null) {
			this.notifyInfoComposite.setText(monitor.getNotifyId());
		}
		if (monitor.getApplication() != null) {
			this.notifyInfoComposite.setApplication(monitor.getApplication());
		}
		
		// ̵ͭ
		if (monitor.getValid() == ValidConstant.TYPE_VALID) {
			this.confirmValid.setSelection(true);
		}
	}
	
	/**
	 * ͤѤξޤ
	 * 
	 * @return ͤݻξ
	 */
	protected MonitorSnmpTrapInfo createInputData() {
		MonitorSnmpTrapInfo info = new MonitorSnmpTrapInfo();
		
		// ƻܾ
		validateResult = monitorBasicComposite.createInputData(info);
		if(validateResult != null){
			return null;
		}
		
		// ߥ˥ƥ̾
		if (this.textCommunityName.getText() != null
				&& !"".equals((this.textCommunityName.getText()).trim())) {
			info.setCommunityName(textCommunityName.getText());
		}
		else{
			this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.snmptrap.1"));
			return null;
		}
		
		//OID
		info.setOidInfos(oidListComposite.getOidList());
		for(int i = 0; i < info.getOidInfos().size(); i++){
			MonitorSnmpTrapOidInfo oidInfo = info.getOidInfos().get(i);
			if(oidInfo.getMonitorId() == null || 
					oidInfo.getMonitorId().equals(info.getMonitorId())){
				oidInfo.setMonitorId(info.getMonitorId());
			}
		}
		
		// ξ°
		if (this.notifyInfoComposite.getText() != null
				&& !"".equals((this.notifyInfoComposite.getText()).trim())) {
			info.setNotifyId(notifyInfoComposite.getText());
		}

		if (this.notifyInfoComposite.getApplication() != null
				&& !"".equals((this.notifyInfoComposite.getApplication()).trim())) {
			info.setApplication(notifyInfoComposite.getApplication());
		}
		else{
			if (this.notifyInfoComposite.getText() != null
					&& !"".equals((this.notifyInfoComposite.getText()).trim())) {
				info.setNotifyId(notifyInfoComposite.getText());
				this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
				return null;
			}
		}
		
		// ͭ/̵
		if (this.confirmValid.getSelection()) {
			info.setValid(ValidConstant.TYPE_VALID);
		} else {
			info.setValid(ValidConstant.TYPE_INVALID);
		}
		
		return info;
	}
	
	/**
	 * ͥå򤷤ޤ
	 * 
	 * @return ڷ
	 */
	protected ValidateResult validate() {
		// 
		this.inputData = this.createInputData();
		
		if (this.inputData != null && this.validateResult == null) {
			return super.validate();
		} else {
			return validateResult;
		}
	}
	
	/**
	 * ϣ˥ܥΥƥȤ֤ޤ
	 * 
	 * @return ϣ˥ܥΥƥ
	 */
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}
	
	/**
	 * 󥻥ܥΥƥȤ֤ޤ
	 * 
	 * @return 󥻥ܥΥƥ
	 */
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
	
	/**
	 * ̵ͤξꤷޤ
	 *  
	 */
	private void setValidateResult(String id, String message) {
		
		this.validateResult = new ValidateResult();
		this.validateResult.setValid(false);
		this.validateResult.setID(id);
		this.validateResult.setMessage(message);
	}
	
    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }
}