/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.snmptrap.action.GetMaster;
import com.clustercontrol.snmptrap.action.GetOidTableDefine;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.OidTabelDefine;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.dialog.SnmpTrapMasterDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapModifyDialog;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAPƻOIDݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class OidListComposite extends Composite {

	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;
	
    // ----- instance ե ----- //
	
	private ArrayList<MonitorSnmpTrapOidInfo> oidList = null;

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;
    
	/** MIB */
	private Combo comboMib = null;
	
	/** ե륿 */
	private Text textFilter = null;
	
    /** ե륿ꥢܥ */
    private Button buttonClearFilter = null;
    
    /** ɽܥ */
    private Button buttonShowOidTable = null;
    
    /** ɲåܥ */
    private Button buttonAdd = null;
    
    /** ܥ */
    private Button buttonModify = null;
    
    /** ܥ */
    private Button buttonDelete = null;
    
    private String monitorId = null;
    
    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public OidListComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        
        //ѿȤѤ٥
		Label label = null;
		
		// 롼
		Group groupFilter = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 15;
		groupFilter.setLayout(layout);
		GridData gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupFilter.setLayoutData(gridData);
		groupFilter.setText(Messages.getString("filter") + " : ");
		
		/*
		 * MIB
		 */
		// ٥
		label = new Label(groupFilter, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("mib") + " : ");
		// ܥܥå
		this.comboMib = new Combo(groupFilter, SWT.DROP_DOWN | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.comboMib.setLayoutData(gridData);
		this.comboMib.setVisibleItemCount(10);
		// MIBꥹȼ
		ArrayList<String> mibList = new GetMaster().getMibList();
		this.comboMib.add("");
		for(int i = 0; i < mibList.size(); i++){
			this.comboMib.add(mibList.get(i));
		}
		this.comboMib.select(0);
		this.comboMib.addSelectionListener(new SelectionListener(){
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
        		//ɽ
        		update();
			}

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});
		// 
		label = new Label(groupFilter, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
		/*
		 * ե륿
		 */
		// ٥
		label = new Label(groupFilter, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("trap.name") + " : ");
		// ƥ
		this.textFilter = new Text(groupFilter, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 6;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.textFilter.setLayoutData(gridData);
        // ꥢܥ
        this.buttonClearFilter = new Button(groupFilter, SWT.NONE);
        this.buttonClearFilter.setText(Messages.getString("clear"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonClearFilter.setLayoutData(gridData);
        this.buttonClearFilter.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		textFilter.setText("");
        	}
        });
        // ɽܥ
        this.buttonShowOidTable = new Button(groupFilter, SWT.NONE);
        this.buttonShowOidTable.setText(Messages.getString("show"));
        gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonShowOidTable.setLayoutData(gridData);
        this.buttonShowOidTable.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		//ɽ
        		update();
        	}
        });
        
        Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.BORDER);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.minimumHeight = 100;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);
        
		/*
		 * OIDơ֥ܥ
		 */
		// ٥
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 9;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
        // ɲåܥ
        this.buttonAdd = new Button(this, SWT.NONE);
        this.buttonAdd.setText(Messages.getString("add"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonAdd.setLayoutData(gridData);
        this.buttonAdd.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
            	// 
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

        		SnmpTrapMasterDialog dialog = new SnmpTrapMasterDialog(shell);
        		dialog.setOidList(oidList);
        		if (dialog.open() == IDialogConstants.OK_ID) {
        			
        			ArrayList<SnmpTrapMasterInfo> list = dialog.getInputData();
        			if(list != null){
        				for(int i = 0; i < list.size(); i++){
        					SnmpTrapMasterInfo master = list.get(i);
        					
        					MonitorSnmpTrapOidInfo info = new MonitorSnmpTrapOidInfo();
        					info.setMonitorId(monitorId);
        					info.setMib(master.getMib());
        					info.setTrapName(master.getUei());
        					info.setTrapOid(master.getTrapOid());
        					info.setGenericId(master.getGenericId());
        					info.setSpecificId(master.getSpecificId());
        					info.setValidFlg(YesNoConstant.TYPE_YES);
        					info.setPriority(master.getPriority());
        					info.setLogmsg(master.getLogmsg());
        					info.setDescr(master.getDescr());
        					oidList.add(info);
        				}
        			}
        		}
        		
        		//ɽ
        		update();
        	}
        });
        // ѹܥ
        this.buttonModify = new Button(this, SWT.NONE);
        this.buttonModify.setText(Messages.getString("modify"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonModify.setLayoutData(gridData);
        this.buttonModify.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
            	// 
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

        		//OID
        		ArrayList<MonitorSnmpTrapOidInfo> list = getSelectionData();
        		if (list != null && list.size() > 0) {

        			for(int index = 0; index < list.size(); index++){
        				MonitorSnmpTrapOidInfo oidInfo = list.get(index);
        				
        				SnmpTrapModifyDialog dialog = new SnmpTrapModifyDialog(shell);
        				dialog.setInputData(oidInfo);
                		dialog.open();
        			}
	        			
	            	//ɽ
	            	update();
        		}
        	}
        });
        // ܥ
        this.buttonDelete = new Button(this, SWT.NONE);
        this.buttonDelete.setText(Messages.getString("delete"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonDelete.setLayoutData(gridData);
        this.buttonDelete.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		//OID
        		ArrayList<MonitorSnmpTrapOidInfo> list = getSelectionData();
        		if (list != null && list.size() > 0) {
        			//ǧ
        			MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
        			confirmBox.setText(Messages.getString("confirmed"));
        			
        			StringBuilder trapNames = new StringBuilder();
        			for(int index = 0; index < list.size(); index++){
        				MonitorSnmpTrapOidInfo oidInfo = list.get(index);
        				if(index == 0)
        					trapNames.append(oidInfo.getTrapName());
        				else
        					trapNames.append(", " + oidInfo.getTrapName());
        			}
        			String[] args = { trapNames.toString() };
        			String message = Messages.getString("message.snmptrap.2",args);
        			
        			confirmBox.setMessage(message);
        			if (confirmBox.open() == SWT.OK) {
        				
	        			for(int index = 0; index < list.size(); index++){
	        				MonitorSnmpTrapOidInfo oidInfo = list.get(index);
	        				oidList.remove(oidInfo);
	        			}
	        			
	            		//ɽ
	            		update();
        			}
        		}
        	}
        });

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetOidTableDefine.get(),
        		OidTabelDefine.SORT_COLUMN_INDEX,
        		OidTabelDefine.SORT_ORDER);
        
        this.update();
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }
    
    /**
     * @return
     */
    public ArrayList<MonitorSnmpTrapOidInfo> getOidList() {
		return oidList;
	}

	/**
	 * @param oidList
	 */
	public void setOidList(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
		this.oidList = oidList;
	}
	
	/**
	 * @return
	 */
	public String getMonitorId() {
		return monitorId;
	}

	/**
	 * @param monitorId
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}

	/**
     * ݥåȤ򹹿ޤ
     * <p>
     * 
     */
    public void update() {

    	ArrayList list = collectionToArray(this.oidList);
    	
    	//ե륿
    	this.tableViewer.addFilter(new ViewerFilter(){

			/* (non-Javadoc)
			 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
			 */
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				boolean select = true;
				
				ArrayList info = (ArrayList)element;
				
				String mib = (String)info.get(OidTabelDefine.MIB);
				if(!comboMib.getText().equals("")){
					if(!mib.equals(comboMib.getText())){
						select = false;
					}
				}
				
				String trapName = (String)info.get(OidTabelDefine.TRAP_NAME);
				if(!textFilter.getText().equals("")){
					if(!trapName.matches(textFilter.getText())){
						select = false;
					}
				}
				
				return select;
			}
    	});
    	
        // ơ֥빹
        this.tableViewer.setInput(list);
    }
    
	/**
	 * OIDObject2˳Ǽ
	 * 
	 * @param oidList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ArrayList collectionToArray(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
		
		ArrayList list = new ArrayList();
		if(oidList != null){
			Iterator itr = oidList.iterator();
			while(itr.hasNext())
			{
				MonitorSnmpTrapOidInfo oid = (MonitorSnmpTrapOidInfo)itr.next();
	
				ArrayList info = new ArrayList();
				info.add(oid.getMonitorId());
				info.add(oid.getMib());
				info.add(oid.getTrapName());
				info.add(oid.getTrapOid());
				info.add(new Integer(oid.getGenericId()));
				info.add(new Integer(oid.getSpecificId()));
				info.add(new Integer(oid.getValidFlg()));
				info.add(new Integer(oid.getPriority()));
				info.add(oid.getLogmsg());
				list.add(info);
			}
		}
		return list;
	}
	
	/**
	 * 򤵤줿OID
	 * 
	 * @return 
	 */
	protected ArrayList<MonitorSnmpTrapOidInfo> getSelectionData() {
		
		ArrayList<MonitorSnmpTrapOidInfo> data = new ArrayList<MonitorSnmpTrapOidInfo>();
		
		//򤵤줿ƥ
		StructuredSelection selection = 
			(StructuredSelection)tableViewer.getSelection();
		List list = (List)selection.toList();
		
		if (list != null) {
			for(int index = 0; index < list.size(); index++){
				
				ArrayList info = (ArrayList)list.get(index);
				if (info != null && info.size() > 0) {
					String mib = (String)info.get(OidTabelDefine.MIB);
					String oid = (String)info.get(OidTabelDefine.TRAP_OID);
					Integer genericId = (Integer)info.get(OidTabelDefine.GENERIC_ID);
					Integer specificId = (Integer)info.get(OidTabelDefine.SPECIFIC_ID);
					
					if (oidList != null) {
						for(int i = 0; i < oidList.size(); i++){
							MonitorSnmpTrapOidInfo oidInfo = oidList.get(i);
							
							if(mib.equals(oidInfo.getMib()) && 
									oid.equals(oidInfo.getTrapOid()) && 
									genericId.equals(oidInfo.getGenericId()) && 
									specificId.equals(oidInfo.getSpecificId())){
								
								data.add(oidInfo);
								break;
							}
						}
					}
				}
			}
		}
		
		return data;
	}
}