/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.snmptrap.bean.QueueConstant;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapRunManagementLocal;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapRunManagementUtil;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.ReceiveRepositoryTopic;
import com.clustercontrol.snmptrap.util.ReceiveSnmpTrapTopic;
import com.clustercontrol.snmptrap.util.SendQueue;

/**
 * SNMPȥå׼饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class TrapSnmpManager {
	
	protected static Log m_log = LogFactory.getLog( TrapSnmpManager.class );
	
	/** ץ饰ID */
	static public final String PLUGIN_ID = "SNMPTRAP";
	
	/** åID */
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** ꥸʥå */
	public static final String REGEX_PREFIX = "%parm\\[#";
	public static final String REGEX_SUFFIX = "\\]%";
	
	/** Ρ° */
	protected static final ArrayList<String> m_attributeList = new ArrayList<String>();
	static{
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBER);
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBERV6);
		m_attributeList.add(FacilityAttributeConstant.NODENAME);
	}
	
	/** IPɥ쥹󥭥å */
	// KeyIPɥ쥹ValueեƥIDꥹ
	protected Map<String, ArrayList<String>> m_ipAddressMap = new ConcurrentHashMap<String, ArrayList<String>>();
	
	/** ۥ̾󥭥å */
	// Keyۥ̾ValueեƥIDꥹ
	protected Map<String, ArrayList<String>> m_hostNameMap = new ConcurrentHashMap<String, ArrayList<String>>();
	
	/** SNMPTRAPƻ󥭥å */
	// KeyƻIDValueSNMPTRAPƻ
	protected Map<String, SnmpTrapFacilityInfo> m_snmpTrapInfoMap = null;
	
	protected TrapSnmp m_trapSnmp = null;
	
	protected ReceiveRepositoryTopic m_receiveRepositoryTopic = null;
	
	protected ReceiveSnmpTrapTopic m_receiveSnmpTrapTopic = null;
	
	protected SendQueue m_sendQueue = null;
	
	/** ݥȥ */
	protected RepositoryControllerLocal m_repository;
	
	/**
	 * Ͻ
	 */
	public void exec() {
		
		try {
			m_sendQueue = new SendQueue(QueueConstant.QUEUE_NAME_NOTIFY);
			m_repository = RepositoryControllerUtil.getLocalHome().create();
			
			// å
			updateCache();
			
			// ȥԥå
			m_receiveRepositoryTopic = new ReceiveRepositoryTopic(this);
			m_receiveSnmpTrapTopic = new ReceiveSnmpTrapTopic(this);
			
			// SNMPȥå׼ 
			m_trapSnmp = new TrapSnmp(this);
			m_trapSnmp.exec();
			
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (JMSException e) {
			e.printStackTrace();
		} catch (CreateException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * λ
	 */
	public void terminate() {
		
		if(m_trapSnmp != null)
			m_trapSnmp.terminate();
		
		if(m_receiveRepositoryTopic != null)
			m_receiveRepositoryTopic.terminate();
		
		if(m_receiveSnmpTrapTopic != null)
			m_receiveSnmpTrapTopic.terminate();
	}
	
	/**
	 * SNMPTRAPƻоݤåоݤξ
	 * 
	 * @param trapDate SNMPȥå׼
	 * @param communityName ߥ˥ƥ̾
	 * @param trapOid OID
	 * @param genericId Generic ID
	 * @param specificId Specific ID
	 * @param varBindValue varBindValue
	 * @param facilityIdList եƥID
	 * @return 
	 */
	public boolean find(
			Date trapDate,
			String communityName,
			String trapOid, 
			int genericId, 
			int specificId, 
			String[] varBind,
			ArrayList<String> facilityIdList) {
		
		if(m_snmpTrapInfoMap == null)
			return true;
		
		Set set = m_snmpTrapInfoMap.keySet();
		for (Iterator iter = set.iterator(); iter.hasNext();) {
			String monitorId = (String) iter.next();
			
			SnmpTrapFacilityInfo info = m_snmpTrapInfoMap.get(monitorId);
			if(info == null)
				continue;
			
			// ߥ˥ƥ̾Ʊ줫
			String communityNameCache = info.getCommunityName();
			if(communityNameCache.equals(communityName)){
				
				// եƥIDޤޤƤ뤫
				ArrayList<String> facilityIdListCache = info.getFacilityIdList();
				
				ArrayList<String> targetFacilityIdList = new ArrayList<String>(facilityIdList);
				targetFacilityIdList.retainAll(facilityIdListCache);
				
				if(targetFacilityIdList.size() > 0){
					
					// פOID¸ߤ뤫
					ArrayList<SnmpTrapOidInfo> oidListCache = info.getOidList();
					for (int index = 0; index < oidListCache.size(); index++) {
						SnmpTrapOidInfo oidInfo = oidListCache.get(index);
						
						// OIDƱ줫
						if(trapOid.equals(oidInfo.getTrapOid())){
							// Generic IDƱ줫
							if(genericId == oidInfo.getGenericId()){
								// Specific IDƱ줫
								if(specificId == oidInfo.getSpecificId()){
									
									for (int j = 0; j < targetFacilityIdList.size(); j++) {
										String facilityId = targetFacilityIdList.get(j);
										SnmpTrapMessageInfo message = new SnmpTrapMessageInfo(
												monitorId,
												facilityId,
												trapDate,
												trapOid,
												genericId,
												specificId,
												varBind
										);
										
										// SNMPȥå׾
										try {
											m_sendQueue.put(message);
										} catch (JMSException e) {
											m_log.error("find() : μԡ" + e.getMessage());
											return false;
										} catch (NamingException e) {
											m_log.error("find() : μԡ" + e.getMessage());
											return false;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return true;
	}
	
	/**
	 * å󹹿
	 * 
	 * @return
	 */
	public void updateCache() {
		
		// SNMPTRAPƻ󹹿
		updateSnmpTrapInfo();
		
		// ݥȥ󹹿
		updateRepositoryInfo();
	}
	
	/**
	 * å󹹿
	 * 
	 * @param updateInfo SNMPTRAP󹹿
	 * @return
	 */
	public boolean updateCache(UpdateSnmpTrapInfo updateInfo) {
		
		// SNMPTRAPƻ󹹿
		String monitorId = updateInfo.getMonitorId();
		int type = updateInfo.getType();
		
		boolean updateRepositoryFlg = true;
		
		try {
			// Ͽ
			if(type == UpdateSnmpTrapInfo.TYPE_ADD){ 
				
				MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
				SnmpTrapFacilityInfo info = management.getSnmpTrapInfo(monitorId);
				
				// ͭʾ
				if(info != null){
					m_snmpTrapInfoMap.put(monitorId, info);
				}
				else{
					// ݥȥꥭå幹ʤ
					updateRepositoryFlg = false;
				}
			}
			// 
			else if(type == UpdateSnmpTrapInfo.TYPE_UPDATE){
				
				MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
				SnmpTrapFacilityInfo info = management.getSnmpTrapInfo(monitorId);
				
				// ͭʾ
				if(info != null){
					// եƥIDѹƤ뤫
					SnmpTrapFacilityInfo infoCache = m_snmpTrapInfoMap.get(monitorId);
					if(infoCache != null){
						String facilityIdCache = infoCache.getFacilityId();
						if(facilityIdCache.equals(info.getFacilityId())){
							// ݥȥꥭå幹ʤ
							updateRepositoryFlg = false;
						}
						m_snmpTrapInfoMap.remove(monitorId);
					}
					m_snmpTrapInfoMap.put(monitorId, info);
				}
				else{
					m_snmpTrapInfoMap.remove(monitorId);
				}
			}
			// 
			else if(type == UpdateSnmpTrapInfo.TYPE_DELETE){
				m_snmpTrapInfoMap.remove(monitorId);
			}
			
			if(updateRepositoryFlg){
				// ݥȥ󹹿
				updateRepositoryInfo();
			}
			return true;
			
		} catch (CreateException e) {
			m_log.error("updateCache(UpdateSnmpTrapInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		} catch (FinderException e) {
			m_log.error("updateCache(UpdateSnmpTrapInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		} catch (NamingException e) {
			m_log.error("updateCache(UpdateSnmpTrapInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		}
		
		m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
		return false;
	}
	
	/**
	 * å󹹿
	 * 
	 * @param updateInfo ݥȥ󹹿
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public boolean updateCache(UpdateRepositoryInfo updateInfo) {
		
		ArrayList<String> facilityIdList = new ArrayList<String>();
		
		// SNMPTRAPƻ եƥIDꥹȹ
		if(m_snmpTrapInfoMap != null){
			
			RepositoryControllerLocal repository;
			try {
				repository = RepositoryControllerUtil.getLocalHome().create();
				
				Set set = m_snmpTrapInfoMap.keySet();
				for (Iterator iter = set.iterator(); iter.hasNext();) {
					String monitorId = (String) iter.next();
					
					SnmpTrapFacilityInfo info = m_snmpTrapInfoMap.get(monitorId);
					if(info != null){
						
						String facilityId = info.getFacilityId();
						
						ArrayList<String> tmpFacilityIdList = null;
						if(repository.isNode(facilityId)){
							tmpFacilityIdList = new ArrayList<String>();
							tmpFacilityIdList.add(facilityId);
						}
						else{
							tmpFacilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
						}
						info.setFacilityIdList(tmpFacilityIdList);
						
						if(tmpFacilityIdList != null && tmpFacilityIdList.size() > 0){
							facilityIdList.addAll(tmpFacilityIdList);
						}
					} 
				}
				
				// ݥȥ󹹿
				updateRepositoryInfo(facilityIdList);
				return true;
				
			} catch (CreateException e) {
				m_log.error("updateCache(UpdateRepositoryInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
			} catch (FinderException e) {
				m_log.error("updateCache(UpdateRepositoryInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
			} catch (NamingException e) {
				m_log.error("updateCache(UpdateRepositoryInfo) : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
			}
			
			m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
			return false;
		}
		return true;
	}
	
	/**
	 * SNMPTRAPƻ󹹿
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public boolean updateSnmpTrapInfo() {
		
		m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
		
		try{
			MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
			m_snmpTrapInfoMap = management.getSnmpTrapMap();
			
			return true;
			
		} catch (CreateException e) {
			m_log.error("updateSnmpTrapInfo() : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		} catch (NamingException e) {
			m_log.error("updateSnmpTrapInfo() : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		} catch (FinderException e) {
			m_log.error("updateSnmpTrapInfo() : SNMPTRAPƻ󹹿ԡ" + e.getMessage());
		}
		return false;
	}
	
	/**
	 * ݥȥ󹹿
	 * 
	 * @return
	 */
	public boolean updateRepositoryInfo() {
		
		ArrayList<String> facilityIdList = new ArrayList<String>();
		
		// SNMPTRAPƻꤵƤեƥID
		if(m_snmpTrapInfoMap != null){
			
			Set set = m_snmpTrapInfoMap.keySet();
			for (Iterator iter = set.iterator(); iter.hasNext();) {
				String monitorId = (String) iter.next();
				
				SnmpTrapFacilityInfo info = m_snmpTrapInfoMap.get(monitorId);
				if(info != null){
					ArrayList<String> tmpFacilityIdList = info.getFacilityIdList();
					if(tmpFacilityIdList != null && tmpFacilityIdList.size() > 0){
						facilityIdList.addAll(tmpFacilityIdList);
					}
				} 
			}
		}
		
		// ݥȥ󹹿
		boolean result = updateRepositoryInfo(facilityIdList);
		return result;
	}
	
	/**
	 * ݥȥ󹹿
	 * 
	 * @return
	 */
	public boolean updateRepositoryInfo(ArrayList<String> facilityIdList) {
		
		m_ipAddressMap = new ConcurrentHashMap<String, ArrayList<String>>();
		m_hostNameMap = new ConcurrentHashMap<String, ArrayList<String>>();
		
		try {
			// Ρɤ°
			if(facilityIdList != null && facilityIdList.size() > 0){
				
				HashMap facilityAttrMap = m_repository.getNodeDetail(facilityIdList, m_attributeList);
				
				Set keySet = facilityAttrMap.keySet();
				for (Iterator iter = keySet.iterator(); iter.hasNext();) {
					String facilityId = (String) iter.next();
					
					HashMap map = (HashMap)facilityAttrMap.get(facilityId);
					String ipNetworkNumber = (String)map.get(FacilityAttributeConstant.IPNETWORKNUMBER);
					String hostName = (String)facilityAttrMap.get(FacilityAttributeConstant.NODENAME);
					
					if(ipNetworkNumber != null && !"".equals(ipNetworkNumber)){
						ArrayList<String> tmpFacilityIdList = m_ipAddressMap.get(ipNetworkNumber);
						if(tmpFacilityIdList == null){
							tmpFacilityIdList = new ArrayList<String>();
						}
						if(!tmpFacilityIdList.contains(facilityId)){
							tmpFacilityIdList.add(facilityId);
						}
						m_ipAddressMap.put(ipNetworkNumber, tmpFacilityIdList);
					}
					
					if(hostName != null && !"".equals(hostName)){
						ArrayList<String> tmpFacilityIdList = m_hostNameMap.get(hostName);
						if(tmpFacilityIdList == null){
							tmpFacilityIdList = new ArrayList<String>();
						}
						if(!tmpFacilityIdList.contains(facilityId)){
							tmpFacilityIdList.add(facilityId);
						}
						tmpFacilityIdList.add(facilityId);
						m_hostNameMap.put(hostName, tmpFacilityIdList);
					}
				}
			}
			return true;
			
		} catch (FinderException e) {
			m_log.error("updateRepositoryInfo() : ݥȥ󹹿ԡ" + e.getMessage());
		} catch (NamingException e) {
			m_log.error("updateRepositoryInfo() : ݥȥ󹹿ԡ" + e.getMessage());
		}
		return false;
	}
	
	/**
	 * ꤵ줿ۥ̾ΥեƥID
	 * 
	 * @param hostName ۥ̾
	 * @return եƥID
	 */
	public ArrayList<String> getFacilityIdListByHostName(String hostName) {
		
		if(m_hostNameMap != null){
			return m_hostNameMap.get(hostName);
		}
		return null;
	}
	
	/**
	 * ꤵ줿IPɥ쥹ΥեƥID
	 * 
	 * @param address IPɥ쥹
	 * @return եƥID
	 */
	public ArrayList<String> getFacilityIdListByIpAddress(String address) {
		
		if(m_ipAddressMap !=null){
			return m_ipAddressMap.get(address);
		}
		return null;
	}
	
	/**
	 * SNMPTRAPƻ
	 * 
	 * @return SNMPTRAPƻ
	 */
	public Map<String, SnmpTrapFacilityInfo> getSnmpTrapInfoMap() {
		
		return m_snmpTrapInfoMap;
	}
	
	/**
	 * SNMPTRAPƻ
	 * 
	 * @return SNMPTRAPƻ
	 */
	public Map<String, SnmpTrapFacilityInfo> getSnmpTrapInfoMap(String monitorId) {
		
		if(m_snmpTrapInfoMap != null){
			m_snmpTrapInfoMap.get(monitorId);
		}
		return null;
	}
}