/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.factory;

import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.TopicConstant;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ƻ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMonitorInfo {
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorInfo.class );
	
	/**
	 * ƻ
	 * 
	 * @param info ƻ
	 * @param user 桼
	 * @return 硢true
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 * @throws FinderException 
	 * @throws RemoveException 
	 */
	public boolean delete(String monitorId) throws NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException, RemoveException {
		
    	//å
    	AccessLock.lock(AccessLock.MONITOR_SNMPTRAP);
		
		TransactionManager tm = null;
		Transaction tx = null;
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManager
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// ¹Υåɤȥ󥶥˴ϢդƤϡȥ󥶥 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// ȥ󥶥󳫻
				if(tm.getTransaction() == null){
					tm.begin();	
					tx = tm.getTransaction();
				}
				
				// ƻ
				result = deleteMonitorInfo(monitorId);
				if(result){
					// ߥå
					tx.commit();
				}
				
				try {
					// 
					UpdateSnmpTrapInfo updateInfo = new UpdateSnmpTrapInfo(
							UpdateSnmpTrapInfo.TYPE_DELETE,
							monitorId);
					
					SendTopic sendTopic = new SendTopic(TopicConstant.TOPIC_NAME_UPDATE);
					sendTopic.put(updateInfo);
					
				} catch (NamingException e) {
					m_log.error("delete() : 顼" + e.getMessage() );
				} catch (JMSException e) {
					m_log.error("delete() : 顼" + e.getMessage() );
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "delete()", monitorId);
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "delete()", monitorId);
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "delete()", monitorId);
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "delete()", monitorId);
				throw e;
			} catch(SystemException e){
				outputLog(e, "delete()", monitorId);
				throw e;
			}
			finally{
				// ȥ󥶥Ϣ㳰ȯϡХå
				if(tx != null){
					if(!result){
						tx.rollback();
					}
					tx = null;
				}
			}
		}
		finally{
			
			// ߤƤȥ󥶥Ƴ
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					outputLog(e, "delete()", monitorId);
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "delete()", monitorId);
					throw e;
				} catch(SystemException e){
					outputLog(e, "delete()", monitorId);
					throw e;
				}
			}
		}
		return result;
	}

	/**
	 * ƻ
	 * 
	 * @param user 桼
	 * @return 硢true
	 * @throws NamingException
	 * @throws FinderException 
	 * @throws RemoveException 
	 */
	public boolean deleteMonitorInfo(String monitorId) throws NamingException, FinderException, RemoveException {
		boolean result = false;
		
		try 
		{
			// ƻ
			SnmpTrapInfoLocal info = 
				SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(
					new SnmpTrapInfoPK(monitorId));
			
			// ƻOID
			Collection ct = info.getSnmpTrapOidInfo();
		    if(ct != null && ct.size() > 0){
		        Object[] infoArray = ct.toArray();
		        for(int j = 0; j < infoArray.length; j++){
		        	SnmpTrapOidInfoLocal oidInfo = (SnmpTrapOidInfoLocal)infoArray[j];
		            if(oidInfo != null){
		            	oidInfo.remove();
		            }
		        }
		    }	
		    
		    // ƻ
		    info.remove();

			result = true;
			
		} catch (NamingException e) {
			outputLog(e, "deleteMonitorInfo()", monitorId);
			throw e;
		} catch (FinderException e) {
			outputLog(e, "deleteMonitorInfo()", monitorId);
			throw e;
		} catch (EJBException e) {
			outputLog(e, "deleteMonitorInfo()", monitorId);
			throw e;
		} catch (RemoveException e) {
			outputLog(e, "deleteMonitorInfo()", monitorId);
			throw e;
		}
		
		return result;
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(Exception e, String method, String monitorId){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {monitorId};
        apllog.put("SYS", "003", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
