package com.clustercontrol.snmptrap.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * @ejb.bean name="SnmpTrapMibMaster"
 *           jndi-name="SnmpTrapMibMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO"
 * impl-class="com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 */
public abstract class SnmpTrapMibMasterBean implements EntityBean {
	
	protected String mib;
	protected Integer orderNo;
	protected String description;
	protected Timestamp regDate;
	protected Timestamp updateDate;
	protected String regUser;
	protected String updateUser;
	
	/**
	 * @ejb.create-method 
	 */
	public SnmpTrapMibMasterPK ejbCreate(
			String mib, 
			Integer orderNo, 
			String description, 
			Timestamp regDate, 
			Timestamp updateDate, 
			String regUser, 
			String updateUser) throws javax.ejb.CreateException {
		
		this.mib = mib;
		this.orderNo = orderNo;
		this.description = description;
		this.regDate = regDate;
		this.updateDate = updateDate;
		this.regUser = regUser;
		this.updateUser = updateUser;
		
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public SnmpTrapMibMasterPK ejbFindByPrimaryKey(SnmpTrapMibMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * @return the mib
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMib() {
		return mib;
	}
	
	/**
	 * @param java.lang.Integer the new mib value
	 * @ejb.interface-method
	 */
	public void setMib(String mib) {
		this.mib = mib;
	}
	
	/**
	 * @return the orderNo
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getOrderNo() {
		return orderNo;
	}
	
	/**
	 * @param java.lang.String the new orderNo value
	 * @ejb.interface-method
	 */
	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}
	
	/**
	 * @return the description
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * @param java.lang.String the new description value
	 * @ejb.interface-method
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * @return the regDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getRegDate() {
		return regDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new regDate value
	 * @ejb.interface-method
	 */
	public void setRegDate(Timestamp regDate) {
		this.regDate = regDate;
	}
	
	/**
	 * @return the updateDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getUpdateDate() {
		return updateDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new updateDate value
	 * @ejb.interface-method
	 */
	public void setUpdateDate(Timestamp updateDate) {
		this.updateDate = updateDate;
	}
	
	/**
	 * @return the regUser
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getRegUser() {
		return regUser;
	}
	
	/**
	 * @param java.lang.String the new regUser value
	 * @ejb.interface-method
	 */
	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}
	
	/**
	 * @return the updateUser
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getUpdateUser() {
		return updateUser;
	}
	
	/**
	 * @param java.lang.String the new updateUser value
	 * @ejb.interface-method
	 */
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}
	
	// ==========================================
	//  CMR fields
	// ==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public Collection getSnmpTrapMaster() {
		Collection collection = null;
		try {
			collection = SnmpTrapMasterUtil.getLocalHome().findByMib(getMib());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
}
