/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAPƻ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetMaster {

    /**
     * SNMPTRAPƻ֤ޤ
     * 
     * @param monitorId ƻID
     * @return SNMPTRAPƻ
     */
    @SuppressWarnings("unchecked")
	public ArrayList<String> getMibList() {

    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

    	ArrayList<String> list = null;
        try {
        	list = snmpTrap.getMibList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return list;
    }
    
    /**
     * SNMPTRAPƻ֤ޤ
     * 
     * @return SNMPTRAPƻ
     */
    @SuppressWarnings("unchecked")
	public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) {

    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

    	ArrayList<SnmpTrapMasterInfo> list = null;
        try {
        	list = snmpTrap.getMasterList(mib);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return list;
    }
}