/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAPƻϿ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddSnmpTrap {

    /**
     * SNMPTRAPƻɲäޤ
     * 
     * @param info SNMPTRAPƻ
     * @return Ͽ硢true
     */
    public boolean add(MonitorSnmpTrapInfo info) {
    	
    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

        boolean result = false;
        try {
        	result = snmpTrap.addMonitor(info);
        	return result;
        } catch (CreateException e) {
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NotSupportedException e) {
		} catch (RollbackException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (SystemException e) {
		} catch (NamingException e) {
		} catch (FinderException e) {
		}
        return false;
    }
}