/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.util;

import java.net.InetAddress;
import java.net.SocketException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpV2Error;
import org.opennms.protocols.snmp.SnmpVarBind;

import com.clustercontrol.util.Messages;

/**
 * SNMP¹ԥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class RequestSnmp implements SnmpHandler {
	
	protected static Log m_log = LogFactory.getLog( RequestSnmp.class );
	
	/**
	 * The version of the SNMP protocol used to communicate
	 */
	private int		m_version 	= 1;
	
	/**
	 * The community string used to "authenticate" the request.
	 */
//	private String		m_community  	= "public";
	
	/**
	 * The number of retries to use.
	 */
	int		m_retries 	= -1;
	
	/**
	 * The time period to wait before considering the last transmission
	 * a failure. This should be in milliseconds.
	 */	
	int		m_timeout	= 1000;
	
	/**
	 * The port where request are sent & received from.
	 */	
	int		m_port		= -1;
	
	/** IPɥ쥹 */
	private String m_ipAddress;
	
	/** 򳫻ϤOID */
	private SnmpObjectId m_oid;
	
	/** 򳫻ϤOID */
	private String m_oidText;
	
	/**  */
	private String m_value;
	
	/**  */
	private long m_date;
	
	/** å */
    private String m_message = null;

    /** Եե饰 */
    boolean m_waitFlg;
    
	// 顼
	private int m_errorCode = 0;
	
	// 顼
	private final int Normal = 0;         // ưƤ
	private final int TimeOutError = 1;   // 䤤碌ॢȤ
	private final int InternalError = 2;  // ॢȰʳΥ顼

	/**
	 * ᥤ롼
	 * IPɥ쥹ȡHashtableꡢ
	 * ݡ󥰤̤Hashtable
	 */
	public boolean polling (
			InetAddress ipAddress,
			String community,
			String oidText
			)
	{	
		m_log.debug("polling() start :" + ipAddress.toString());
		
		m_errorCode = Normal;
		m_ipAddress = ipAddress.toString();
		m_oidText = oidText;
		m_waitFlg = true;
		
		SnmpPeer peer = new SnmpPeer(ipAddress);
		if(m_port != -1)
			peer.setPort(m_port);
		
		if(m_timeout != -1)
			peer.setTimeout(m_timeout);
		
		if(m_retries != -1)
			peer.setRetries(m_retries);
		
		//
		// Initialize the peer
		//
		SnmpParameters parms = peer.getParameters();
		parms.setVersion(m_version);
		parms.setReadCommunity(community);
		
		//
		// Now create the session, set the initial request
		// and walk the tree!
		//
		SnmpSession session = null;
		try
		{
			session = new SnmpSession(peer);
		}
		catch(SocketException e)
		{
			m_log.debug("polling():" + m_ipAddress + " SocketException creating the SNMP session");
			
			m_message = Messages.getString("message.snmp.7") + " (" + e.getMessage() + ")";
			return false;
		}
		
		session.setDefaultHandler(this);

		try
		{
			// build the first request
			SnmpPduRequest pdu = new SnmpPduRequest(SnmpPduRequest.GET);
			
			m_oid = new SnmpObjectId(m_oidText);
			pdu.addVarBind(new SnmpVarBind(m_oid));
			
			synchronized(session)
			{
				session.send(pdu);
				if(m_waitFlg){
					session.wait();
				}
			}
		}
		catch(InterruptedException e) 
		{ 
			m_log.debug("polling():" + m_ipAddress + " polling failed at InterruptedException" );
			
			m_message = Messages.getString("message.snmp.7") + " (" + e.getMessage() + ")";
			return false;
		}
		finally
		{
			session.close();
		}
		
		if(this.m_errorCode != Normal){
			return false;
		}
		return true;
		
	} 
	
	/* ( Javadoc)
	 * @see org.opennms.protocols.snmp.SnmpHandler#snmpReceivedPdu(org.opennms.protocols.snmp.SnmpSession, int, org.opennms.protocols.snmp.SnmpPduPacket)
	 */
	public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
		try{
			// 
			long time = System.currentTimeMillis();
			
			m_log.debug("snmpReceivedPdu():" +  session.toString());
			
			SnmpPduRequest req = null;
			if(pdu instanceof SnmpPduRequest)
			{
				req = (SnmpPduRequest)pdu;
			}
			
			if(pdu.getCommand() != SnmpPduPacket.RESPONSE)
			{
				m_log.debug("snmpReceivedPdu():" +  session.toString() + "  Received non-response command " + pdu.getCommand());
				synchronized(session)
				{
					m_errorCode = InternalError;
					m_message = Messages.getString("message.snmp.7") + " Received non-response command " + pdu.getCommand();
					session.notify();
				}
				return;
			}
			
			// 0:noError 	顼ʤ
			// 1:TooBig 	PDU¤ۤ
			// 2:noSuchName ׵ᤵ줿֥Ȥ¸ߤʤ
			// 3:badValue 	SetRequest̷⤹ͤޤޤƤ
			// 4:readOnly 	̤
			// 5:GenErr 	Ƥʤ顼
			if(req.getErrorStatus() != 0)
			{
				m_log.error("snmpReceivedPdu():" +  session.toString() + "  Error Status " + req.getErrorStatus());
				
				synchronized(session)
				{
					m_errorCode = InternalError;
					m_message = Messages.getString("message.snmp.7") + " Error Status:" + req.getErrorStatus();
					session.notify();
				}
				return;
			}
			
			SnmpVarBind[] vars = pdu.toVarBindArray();
			
			for(int x = 0; x < vars.length; x++)
			{
				// ǥХå
				m_log.debug(
						vars[x].getName().toString() + 
						" " + time +
						" " + vars[x].getValue().getClass().getName() + 
						" " + vars[x].getValue().toString()
				);
				
				if(m_oid.isRootOf(vars[x].getName())) {
					if(vars[x].getValue() instanceof SnmpV2Error){
						// 顼
						m_errorCode = InternalError;
						m_message = Messages.getString("message.snmp.7") + " SnmpV2Error. Value:" + vars[x].getValue().toString();
					}
					else if(vars[x].getValue() instanceof SnmpTimeTicks){
						m_value = ((SnmpUInt32)vars[x].getValue()).toString();
						m_date = time;
					}
					else{
						m_log.debug("snmpReceivedPdu():" + vars[x].getName().toString() + " ," + time + " ," + vars[x].getValue().toString());

						m_value = vars[x].getValue().toString();
						m_date = time;
					}
				}
			}
			
			// λޤ
			synchronized(session)
			{
				session.notify();
			}
			return;
			
		} catch (Exception e) { // 㳰ϼߤ

			// λޤ
			synchronized(session)
			{
				m_errorCode = InternalError;
				m_message = Messages.getString("message.snmp.7") + " (" + e.getMessage() + ")";
				session.notify();
			}
		}
		
	}

	/* ( Javadoc)
	 * @see org.opennms.protocols.snmp.SnmpHandler#snmpInternalError(org.opennms.protocols.snmp.SnmpSession, int, org.opennms.protocols.snmp.SnmpSyntax)
	 */
	public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
		m_log.warn("snmpInternalError():" + session.toString()
				+ " snmpInternalError. The error code is " + err);
		
		synchronized(session)
		{
			m_errorCode = InternalError;
			m_waitFlg = false;
			m_message = Messages.getString("message.snmp.7") + " snmpInternalError. The error code is " + err;
			session.notify();
		}
	}

	/* ( Javadoc)
	 * @see org.opennms.protocols.snmp.SnmpHandler#snmpTimeoutError(org.opennms.protocols.snmp.SnmpSession, org.opennms.protocols.snmp.SnmpSyntax)
	 */
	public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
		m_log.warn("snmpTimeoutError():" + session.getPeer().getPeer().toString()
				+ " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName()
				+ " polling failed at TimeoutError" );
		
		synchronized(session)
		{
			m_errorCode = TimeOutError;
			m_message = Messages.getString("message.snmp.7") + " snmpTimeoutError." + session.getPeer().getPeer().toString()
									+ " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName();
			session.notify();
		}
	}
	
	/**
	 * @return åᤷޤ
	 */
	public String getMessage() {
		return m_message;
	}
	
	/**
	 * @return ͤᤷޤ
	 */
	public String getValue() {
		return m_value;
	}
	
	/**
	 * @return ᤷޤ
	 */
	public long getDate() {
		return m_date;
	}
	
	public static void main(String[] args) {
		try {
			RequestSnmp test = new RequestSnmp();
			test.polling(InetAddress.getByName("10.33.19.226"),"public", ".1.3.6.1.2.1.25.4.2.1.4");
		} catch (Exception e) {
		}
	}
}
