/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.util;

import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoUtil;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * SNMPƻ Ƚ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ControlSnmpInfo {
    protected static Log m_log = LogFactory.getLog( ControlSnmpInfo.class );
    
    /** ƻоID */
	protected String m_monitorTypeId;
	
	/** ƻID */
	protected String m_monitorId;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param monitorId ƻID
	 * @param monitorTypeId ƻоID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ControlSnmpInfo(String id, String typeId) {
		m_monitorId = id;
		m_monitorTypeId = typeId;
	}
	
	/**
	 * SNMPƻ
	 * 
	 * @return SNMPƻ
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public MonitorSnmpInfo get() throws FinderException, NamingException{
		
		// SNMPƻ
		MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		MonitorSnmpInfo snmp = new MonitorSnmpInfo();
		snmp.setMonitorTypeId(m_monitorTypeId);
		snmp.setMonitorId(m_monitorId);
		snmp.setCommunityName(snmpLocal.getCommunityName());
		snmp.setSnmpOid(snmpLocal.getSnmpOid());
		snmp.setConvertFlg(snmpLocal.getConvertFlg());
		
		return snmp;
	}

	/**
	 * SNMPƻɲ
	 * 
	 * @param snmp SNMPƻ
	 * @return 硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean add(MonitorSnmpInfo snmp) throws CreateException, NamingException {
		
		// SNMPƻɲ
		MonitorSnmpInfoUtil.getLocalHome().create(
				m_monitorTypeId,
				m_monitorId,
				snmp.getCommunityName(),
				snmp.getSnmpOid(),
				snmp.getConvertFlg());
		
		return true;
	}
	
	/**
	 * SNMPƻѹ
	 * 
	 * @param snmp SNMPƻ
	 * @param deleteValueFlg ;ե饰
	 * @return 硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean modify(MonitorSnmpInfo snmp, boolean deleteValueFlg) throws CreateException, FinderException, NamingException {
		
		// SNMPƻ
		MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// OID
		String prevSnmpOid = snmpLocal.getSnmpOid();
		
		snmpLocal.setCommunityName(snmp.getCommunityName());
		snmpLocal.setSnmpOid(snmp.getSnmpOid());
		snmpLocal.setConvertFlg(snmp.getConvertFlg());
		
		// SNMP;
		if(deleteValueFlg || !prevSnmpOid.equals(snmp.getSnmpOid())){
			
			try {
				Collection ct = MonitorSnmpValueUtil.getLocalHome().findByMonitorId(m_monitorId);
				if(ct != null && ct.size() > 0){
			        Object[] infoArray = ct.toArray();
			        for(int j = 0; j < infoArray.length; j++){
			        	MonitorSnmpValueLocal value = (MonitorSnmpValueLocal)infoArray[j];
			            if(value != null){
			            	value.remove();
			            }
			        }
			    }
			} catch (RemoveException e) {
				 AplLogger apllog = new AplLogger("SNMP", "snmp");
				 String[] args = { m_monitorId };
				 apllog.put("SYS", "001", args);
		         m_log.debug("modifyCheckInfo():" + e.getMessage());

				return false;
			}
		}
		return true;
	}

	/**
	 * SNMPƻ
	 * 
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {
		
		// SNMPƻ
		MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SNMPƻ
		snmpLocal.remove();
		
		// SNMP;
		try {
			Collection ct = MonitorSnmpValueUtil.getLocalHome().findByMonitorId(m_monitorId);
			if(ct != null && ct.size() > 0){
		        Object[] infoArray = ct.toArray();
		        for(int j = 0; j < infoArray.length; j++){
		        	MonitorSnmpValueLocal value = (MonitorSnmpValueLocal)infoArray[j];
		            if(value != null){
		            	value.remove();
		            }
		        }
		    }
		} catch (Exception e) {
			AplLogger apllog = new AplLogger("SNMP", "snmp");
			String[] args = { m_monitorId };
			apllog.put("SYS", "001", args);
	        m_log.debug("deleteCheckInfo():" + e.getMessage());

			return false;
		}
		return true;
	}
}
