/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.factory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoUtil;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValuePK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueUtil;
import com.clustercontrol.snmp.util.RequestSnmp;
import com.clustercontrol.snmp.util.SnmpProperties;
import com.clustercontrol.util.Messages;

/**
 * SNMPƻ ʹƻѼ¹ԥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunMonitorSnmp extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorSnmp.class );
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** SNMPƻ */
	protected static final ArrayList<String> m_attributeList = new ArrayList<String>();
	static{
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBER);
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBERV6);
	}
	
	/** SNMPƻ */
	protected MonitorSnmpInfoLocal m_snmp = null;
	
	/** SNMP */
	protected RequestSnmp m_request = null;
	
	/** ߥ˥ƥ̾ */
	protected String m_communityName = null;
	
	/** OID */
	protected String m_snmpOid = null;
	
	/** ͤβù */
	protected int m_convertFlg = 0;
	
	/** ꥸʥå */
	protected String m_messageOrg = null;
	
	/** åID */
	protected String m_messageId = "";
	
	/** å */
	protected String m_message = "";
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorSnmp() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * OIDͤ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	public boolean collect(String facilityId) {
		
		m_nodeDate = m_now.getTime();
		m_value = 0;
		
		// å
		m_message = "";
		m_messageOrg = Messages.getString("oid") + " : " + m_snmpOid;
		
		try{
			
			// IPɥ쥹μ
			String ipNetworkNumber = null;
			try {
				// Ρɤ°
				HashMap facilityAttrMap = m_repository.getNodeDetail(facilityId, m_attributeList);
				ipNetworkNumber = (String)facilityAttrMap.get(FacilityAttributeConstant.IPNETWORKNUMBER);
			}
			catch(FinderException e){
				m_log.debug("run():" + e.getMessage());
	            
	            m_message = Messages.getString("message.snmp.6");
	            m_messageOrg = m_messageOrg + " (" + e.getMessage() + ")";
				return false;
			}
			catch(NamingException e){
				m_log.debug("run():" + e.getMessage());
	            
	            m_message = Messages.getString("message.snmp.6");
	            m_messageOrg = m_messageOrg + " (" + e.getMessage() + ")";
				return false;
			}
			
			// SNMPͼ
			RequestSnmp m_request = new RequestSnmp();
			boolean result = m_request.polling(InetAddress.getByName(ipNetworkNumber), m_communityName, m_snmpOid);
			
			if(result){
				
				// μ
				float value = -1;
				try {
					value = Float.parseFloat(m_request.getValue());
				} catch (NumberFormatException e) {
					String[] args = { m_request.getValue() };
		            m_message = Messages.getString("message.snmp.8", args);
		            return false;
				}
				long date = m_request.getDate();
				
				// ùʤ
				if(m_convertFlg == ConvertValueConstant.TYPE_NO){
					m_value = value;
					m_nodeDate = date;
				}
				// ʬȤ
				else if(m_convertFlg == ConvertValueConstant.TYPE_DELTA){
					
					// ͤ
					MonitorSnmpValueLocal valueLocal = null;
					float prevValue = 0;
					long prevDate = 0;
					try {
						MonitorSnmpValuePK pk = new MonitorSnmpValuePK(facilityId, m_monitorId);
						valueLocal = MonitorSnmpValueUtil.getLocalHome().findByPrimaryKey(pk);

						// μ
						prevValue = valueLocal.getValue().floatValue();
						prevDate = valueLocal.getGetDate().getTime();
						
						// SNMP;򺣲μͤ˹
						valueLocal.setValue(Float.valueOf(value));
						valueLocal.setGetDate(new Timestamp(date));
					}
					catch (FinderException e) {
						// ä
						try {
							valueLocal = MonitorSnmpValueUtil.getLocalHome().create(m_monitorId, facilityId, Float.valueOf(value), new Timestamp(date));
							
							prevValue = value;
							prevDate = date;
						}
						catch (CreateException ce) {
							m_log.debug("run():" + e.getMessage());
				            
				            m_message = Messages.getString("message.snmp.7");
				            m_messageOrg = m_messageOrg + " (" + e.getMessage() + ")";
							return false;
						}
					}
					
					// ͼ郎SNMPƻ֤ä硢ͼ
					int tolerance = (m_monitor.getRunInterval() + SnmpProperties.getProperties().getValidSecond()) * 1000;
					
					if(prevDate > date - tolerance){
						m_value = value - prevValue;
						m_nodeDate = m_request.getDate();
					}
					else{
						String[] args = { DateFormat.getDateTimeInstance().format(new Date(prevDate))};
						m_message = Messages.getString("message.snmp.9",args);
						return false;
					}
				}
				m_message = Messages.getString("select.value") + " : " + m_value;
			}
			else{
				m_message = m_request.getMessage();
			}
			return result;
		}
		catch (UnknownHostException e) {
			m_log.debug("run():" + e.getMessage());

			m_message = Messages.getString("message.snmp.5");
			m_messageOrg = m_messageOrg + " (" + e.getMessage() + ")";
			return false;
		}
		catch(NamingException e){
			m_log.debug("run():" + e.getMessage());
            
            m_message = Messages.getString("message.snmp.7");
            m_messageOrg = m_messageOrg + " (" + e.getMessage() + ")";
			return false;
		}
	}
	
	/* ( Javadoc)
	 * SNMPƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// SNMPƻ
		MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(m_monitorId, m_monitorTypeId);
		m_snmp = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SNMPƻ
		m_communityName = m_snmp.getCommunityName().trim();
		m_snmpOid = m_snmp.getSnmpOid().trim();
		m_convertFlg = m_snmp.getConvertFlg().intValue();
		
	}

	/* ( Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		if(id == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(id == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(id == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/* ( Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}

	/* ( Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
	
	/* ( Javadoc)
	 * ѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageIdForScope(int)
	 */
	@Override
	public String getMessageIdForScope(int priority) {
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
}
