/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.factory.AddMonitor;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.monitor.run.factory.ModifyMonitor;
import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.snmp.factory.AddMonitorSnmp;
import com.clustercontrol.snmp.factory.AddMonitorSnmpString;
import com.clustercontrol.snmp.factory.DeleteMonitorSnmp;
import com.clustercontrol.snmp.factory.DeleteMonitorSnmpString;
import com.clustercontrol.snmp.factory.ModifyMonitorSnmp;
import com.clustercontrol.snmp.factory.ModifyMonitorSnmpString;
import com.clustercontrol.snmp.factory.SelectMonitorSnmp;
import com.clustercontrol.snmp.factory.SelectMonitorSnmpString;

/**
 * @ejb.bean name="MonitorSnmpController"
 *           jndi-name="MonitorSnmpController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public abstract class MonitorSnmpControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorSnmpControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;

	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * SNMPƻϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SnmpMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ƻ
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean addSnmp(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// SNMPƻϿ
		AddMonitor snmp = null;
		if(info.getMonitorType() == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			snmp = new AddMonitorSnmp();
		}
		else if(info.getMonitorType() == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			snmp = new AddMonitorSnmpString();
		}
		else{
			return false;
		}
		return  snmp.add(info, pri.getName());
	}
	
	/**
	 * SNMPƻ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SnmpMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ƻ
	 * @return ѹ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean modifySnmp(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// SNMPƻ򹹿
		ModifyMonitor snmp = null;
		if(info.getMonitorType() == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			snmp = new ModifyMonitorSnmp();
		}
		else if(info.getMonitorType() == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			snmp = new ModifyMonitorSnmpString();
		}
		else{
			return false;
		}
		return  snmp.modify(info, pri.getName());
	}

	/**
	 * SNMPƻޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SnmpMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param monitorId ƻID
	 * @param monitorType ƻȽ꥿
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean deleteSnmp(String monitorId, int monitorType) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException{

		// SNMPƻ
		DeleteMonitor snmp = null;
		if(monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			snmp = new DeleteMonitorSnmp();
		}
		else if(monitorType == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			snmp = new DeleteMonitorSnmpString();
		}
		else{
			return false;
		}
		return  snmp.delete(MonitorConstant.STRING_SNMP, monitorId);
	}
	
	/**
	 * SNMPƻ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SnmpMonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId ִƻID
	 * @param monitorType ƻȽ꥿
	 * @return SNMPƻ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public MonitorInfo getSnmp(String monitorId, int monitorType) throws CreateException, FinderException, SchedulerException, NamingException {

		// SNMPƻ
		SelectMonitor snmp = null;
		if(monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			snmp = new SelectMonitorSnmp();
		}
		else if(monitorType == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			snmp = new SelectMonitorSnmpString();
		}
		else{
			return null;
		}
		
		MonitorInfo info = snmp.getMonitor(MonitorConstant.STRING_SNMP, monitorId);
		return info;
	}

	/**
	 * SNMPƻꥹȤ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SnmpMonitorRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public ArrayList getSnmpList() throws CreateException, FinderException, SchedulerException, NamingException {

		// SNMPƻ
		SelectMonitorSnmp snmp = new SelectMonitorSnmp();
		ArrayList list = snmp.getMonitorList(MonitorConstant.STRING_SNMP);

		return list;
	}
	
	/**
	 * SNMPƻΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getSnmpListTableDefine(Locale local) {
		
		/** ơ֥ */
		SelectMonitorSnmp snmp = new SelectMonitorSnmp();
		ArrayList tableDefine = snmp.getMonitorListTableDefine(local);

		return tableDefine;
	}
	
	/**
	 * SNMPƻ ʸƻȽΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 * 
	 * @version 2.1.0
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getSnmpStringValueListTableDefine(Locale locale) {
		
		/** ơ֥ */
		SelectMonitorSnmpString snmp = new SelectMonitorSnmpString();
		ArrayList tableDefine = snmp.getStringValueListTableDefine(locale);
		
		return tableDefine;
	}
}
