/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.ejb.entity;

import java.sql.Timestamp;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorSnmpValue"
 *           jndi-name="MonitorSnmpValue"
 *           type="CMP"
 *           schema="MonitorSnmpValue" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorId","facilityId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_snmp_value"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorSnmpValue as a"  
 *    signature="java.util.Collection findAll()"
 *      
 *  @ejb.finder
 *    query=""
 *    signature="java.util.Collection findByMonitorId(java.lang.String monitorId)"
 *  @jboss.query
 *    query="SELECT OBJECT(a) FROM MonitorSnmpValue as a WHERE a.monitorId = ?1"
 *    signature="java.util.Collection findByMonitorId(java.lang.String monitorId)"
 *
 *  @ejb.pk class="com.clustercontrol.snmp.ejb.entity.MonitorSnmpValuePK"
 *   
 */
public abstract class MonitorSnmpValueBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorSnmpValuePK ejbCreate(
			String monitorId, 
			String facilityId,
			Float value,
			Timestamp getDate			
			) throws javax.ejb.CreateException {
		
		this.setMonitorId(monitorId);
		this.setFacilityId(facilityId);
		this.setValue(value);
		this.setGetDate(getDate);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="get_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param regDate The getDate to set.
	 */
	public abstract Timestamp getGetDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param getDate The getDate to set.
	 */
	public abstract void setGetDate(Timestamp getDate);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="value"
	 *     jdbc-type="REAL"
	 *     sql-type="real"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the value.
	 */
	public abstract Float getValue();

	/**
	 * @ejb.interface-method
	 * 
	 * @param value The value to set.
	 */
	public abstract void setValue(Float value);

}
