/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.snmp.util.EjbConnectionManager;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import com.clustercontrol.util.Messages;

/**
 * SNMPƻơ֥륯饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetSnmpListTableDefine {

    /**
     * SNMPƻΥơ֥֤ޤ
     * 
     * @return SNMPƻơ֥
     */
    public static ArrayList get() {
    	MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager()
                .getSnmpController();

        ArrayList tableDefine = null;
        try {
            tableDefine = snmp.getSnmpListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}