/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpController;
import com.clustercontrol.snmp.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SNMPƻ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class GetSnmp {

    /**
     * SNMPƻ֤ޤ
     * 
     * @param monitorId ƻID
     * @param monitorType ƻȽ꥿
     * @return SNMPƻ
     */
    public MonitorInfo getSnmp(String monitorId, int monitorType) {

    	MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager().getSnmpController();

    	MonitorInfo info = null;
        try {
        	info = snmp.getSnmp(monitorId, monitorType);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * SNMPƻ֤ޤ
     * 
     * @return SNMPƻ
     */
    public ArrayList getSnmpList() {

    	MonitorSnmpController snmp = EjbConnectionManager.getConnectionManager()
                .getSnmpController();

        ArrayList records = null;
        try {
            records = snmp.getSnmpList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}