/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;


/**
 * ѥץѥƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeProperty {
	/** եƥID */
	public static final String FACILITY_ID = "facilityId";
	/** եƥ̾ */
	public static final String FACILITY_NAME = "facilityName";
	/**  */
	public static final String DESCRIPTION = "notes";

	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return ѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		Property property = getProperty(mode, local);
		
		if(facilityId != null && facilityId.compareTo("") != 0){
		    
		    //Facility
			SelectFacility select = new SelectFacility();
			FacilityLocal facility = select.getFacility(facilityId);

			if(facility != null){
			    //եƥID
				ArrayList propertyList = PropertyUtil.getProperty(property, FACILITY_ID);
				((Property)propertyList.get(0)).setValue(facility.getFacilityId());
				//եƥ̾
				propertyList = PropertyUtil.getProperty(property, FACILITY_NAME);
				((Property)propertyList.get(0)).setValue(facility.getCn());
				//
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getDescription());
				}
			}
		}
		
		return property;
	}
	
	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param mode
	 * @return ѥץѥƥ
	 */
	public Property getProperty(int mode, Locale local) {
		//եƥID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id"), PropertyConstant.EDITOR_TEXT);
		//եƥ̾
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name"), PropertyConstant.EDITOR_TEXT);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description"), PropertyConstant.EDITOR_TEXT);
		
		//ͤ
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		
		//⡼ɤˤꡢѹĤ
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		
		return property;
	}
}
