/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * Ρѥץѥƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeProperty {
	/** եƥID */
	public static final String FACILITY_ID = "facilityId";
	/** եƥ̾ */
	public static final String FACILITY_NAME = "facilityName";
	/**  */
	public static final String DESCRIPTION = "description";
//	/** PINGƻ */
//	public static final String PING_MONITOR = "pingMonitoring";
//	/** PINGƻ륹ơ */
//	public static final String PING_MONITOR_STATUS = "pingMonitoringStatus";
//	/** ȴƻ */
//	public static final String AGENT_MONITOR = "agentMonitoring";
//	/** ȴƻ륹ơ */
//	public static final String AGENT_MONITOR_STATUS = "agentMonitoringStatus";
//	/** ơƻ */
//	public static final String STATUS_MONITOR = "statusMonitoring";
//	/** ٥ȴƻ */
//	public static final String EVENT_MONITOR = "eventMonitoring";
//	/**  */
//	public static final String AGENT_CONTROL = "agentControl";
	/** DHCP饤 */
	public static final String DHCP_CLIENT = "dhcpClient";
	/** IPɥ쥹 */
	public static final String IP_ADDRESS_TYPE = "ipAddressType";
	/** IPɥ쥹ΥС */
	public static final String IP_ADDRESS_VERSION = "ipAddressVersion";
	/** IPv4Υɥ쥹 */
	public static final String IP_ADDRESS_V4 = "ipAddressV4";
	/** IPv6Υɥ쥹 */
	public static final String IP_ADDRESS_V6 = "ipAddressV6";
	/** ۥ̾ */
	public static final String HOST_NAME = "hostName";
	/** H/W */
	public static final String HARDWARE_TYPE = "hardwareType";
	/** ץåȥեեߥ̾ */
	public static final String PLATFORM_FAMILY_NAME = "platformFamilyName";
	/** OS̾ */
	public static final String OS_NAME = "osName";
	/** Ρ̾ */
	public static final String NODE_NAME = "nodeName";
	/** OS꡼ */
	public static final String OS_RELEASE = "osRelease";
	/** OSС */
	public static final String OS_VERSION = "osVersion";
	/** ʸå */
	public static final String CHARACTER_SET = "characterSet";
	/**  */
	public static final String ADMINISTRATOR = "administrator";
	/** Ϣ */
	public static final String CONTACT = "contact";
	/**  */
	public static final String CREATE_TIME = "createTimestamp";
	/**  */
	public static final String CREATOR_NAME = "creatorName";
	/**  */
	public static final String MODIFIER_NAME = "ModifierName";
	/**  */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/** ǥХ̾ */
	public static final String DEVICE_NAME = "deviceName";
	/** ǥХOID */
	public static final String DEVICE_OID = "deviceOID";
	/** ǥХǥå */
	public static final String DEVICE_INDEX = "deviceIndex";
	/** ǥХ */
	public static final String DEVICE_TYPE = "deviceType";
	/** ǥХ */
	public static final String DEVICE_DESCRIPTION = "deviceDescription";
	
	/** ͥåȥ */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** ݼ */
	public static final String MAINTENANCE = "maintenance";	
	/** ǥХ */
	public static final String DEVICE = "device";	
	
	/**
	 * Ρѥץѥƥ֤ޤ
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return Ρѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		Property property = getProperty(mode, local);
		
		if(facilityId != null && facilityId.compareTo("") != 0){
		    //Facility
			SelectFacility select = new SelectFacility();
			FacilityLocal facility = select.getFacility(facilityId);
			
			if(facility != null){
				//եƥID
				ArrayList propertyList = PropertyUtil.getProperty(property, FACILITY_ID);
				((Property)propertyList.get(0)).setValue(facility.getFacilityId());
				//եƥ̾
				propertyList = PropertyUtil.getProperty(property, FACILITY_NAME);
				((Property)propertyList.get(0)).setValue(facility.getCn());
				//
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getDescription());
				}
//				//
//				propertyList = PropertyUtil.getProperty(property, AGENT_CONTROL);
//				if(facility.getAgentControl() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentControl());
//				}
//				//ȴƻ
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR);
//				if(facility.getAgentWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatch());
//				}
//				//ȴƻ륹ơ
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR_STATUS);
//				if(facility.getAgentWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatchStatus());
//				}
				//ʸå
				propertyList = PropertyUtil.getProperty(property, CHARACTER_SET);
				if(facility.getCharSet() != null && facility.getCharSet().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCharSet());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(facility.getCreateTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getCreateTimestamp());
				}
				//Ͽ
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(facility.getCreatorsName() != null && facility.getCreatorsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCreatorsName());
				}
				//DHCP饤
				propertyList = PropertyUtil.getProperty(property, DHCP_CLIENT);
				if(facility.getDhcpClient() != null){
					((Property)propertyList.get(0)).setValue(facility.getDhcpClient());
				}
				//ۥ̾
				propertyList = PropertyUtil.getProperty(property, HOST_NAME);
				Property parent = (Property)((Property)propertyList.get(0)).getParent();
				if(facility.getHost() != null){
					int index = PropertyUtil.getPropertyIndex(parent, (Property)propertyList.get(0));
					for(int i = 0; i < facility.getHost().size(); i++){
						if(i == 0){
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
						}
						else{
							Property copy = PropertyUtil.copy((Property)propertyList.get(0));
							
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
							
							parent.addChildren(copy, index + i);
						}
					}
				}
				//IPɥ쥹V4
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V4);
				if(facility.getIpNetworkNumber() != null && facility.getIpNetworkNumber().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumber());
				}
				//IPɥ쥹V6
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V6);
				if(facility.getIpNetworkNumberV6() != null && facility.getIpNetworkNumberV6().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumberV6());
				}
				//IPС
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_VERSION);
				if(facility.getIpProtocolNumber() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpProtocolNumber());
				}
				//IP
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_TYPE);
				if(facility.getIpType() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpType());
				}
//				//٥ȴƻ
//				propertyList = PropertyUtil.getProperty(property, EVENT_MONITOR);
//				if(facility.getLogWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getLogWatch());
//				}
				//H/W
				propertyList = PropertyUtil.getProperty(property, HARDWARE_TYPE);
				if(facility.getMachine() != null && facility.getMachine().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getMachine());
				}
				//Ϣ
				propertyList = PropertyUtil.getProperty(property, CONTACT);
				if(facility.getManagerContact() != null && facility.getManagerContact().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerContact());
				}
				//
				propertyList = PropertyUtil.getProperty(property, ADMINISTRATOR);
				if(facility.getManagerName() != null && facility.getManagerName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerName());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(facility.getModifiersName() != null && facility.getModifiersName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getModifiersName());
				}
				//
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(facility.getModifyTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getModifyTimestamp());
				}
				//Ρ̾
				propertyList = PropertyUtil.getProperty(property, NODE_NAME);
				if(facility.getNodeName() != null && facility.getNodeName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getNodeName());
				}
				//OS̾
				propertyList = PropertyUtil.getProperty(property, OS_NAME);
				if(facility.getOsName() != null && facility.getOsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsName());
				}
				//OS꡼
				propertyList = PropertyUtil.getProperty(property, OS_RELEASE);
				if(facility.getOsRelease() != null && facility.getOsRelease().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsRelease());
				}
				//OSС
				propertyList = PropertyUtil.getProperty(property, OS_VERSION);
				if(facility.getOsVersion() != null && facility.getOsVersion().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsVersion());
				}
//				//PINGƻ
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR);
//				if(facility.getPingWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatch());
//				}
//				//PINGƻ륹ơ
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR_STATUS);
//				if(facility.getPingWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatchStatus());
//				}
//				if(facility.getPingWatch() != null && !facility.getPingWatch().booleanValue()){
//				    ((Property)propertyList.get(0)).setValue("");
//				}
				//ץåȥե
				propertyList = PropertyUtil.getProperty(property, PLATFORM_FAMILY_NAME);
				if(facility.getPlatform() != null && facility.getPlatform().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getPlatform());
				}
//				//ơƻ
//				propertyList = PropertyUtil.getProperty(property, STATUS_MONITOR);
//				if(facility.getStatusWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getStatusWatch());
//				}
				
				//ǥХ
				propertyList = PropertyUtil.getProperty(property, DEVICE);
				Property deviceProperty = (Property)propertyList.get(0);
				int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
				
				//ǥХ
				Collection deviceList = null;
				try {
					deviceList = facility.getDeviceInfo();
				} catch (FinderException e) {
				}
				if(deviceList != null){
					Iterator itr = deviceList.iterator();
					int i = 0;
					while(itr.hasNext()){
						DeviceInfoLocal d = (DeviceInfoLocal)itr.next();
						if(i == 0){
						    //ǥХ̾
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_NAME);
							if(d.getCn() != null && d.getCn().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getCn());
							}
							//ǥХOID
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//ǥХINDEX
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//ǥХ
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
						}
						else{
							Property copy = PropertyUtil.copy(deviceProperty);
							//ǥХ̾
							propertyList = PropertyUtil.getProperty(copy, DEVICE_NAME);
							if(d.getCn() != null && d.getCn().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getCn());
							}
							//ǥХOID
							propertyList = PropertyUtil.getProperty(copy, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//ǥХINDEX
							propertyList = PropertyUtil.getProperty(copy, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//ǥХ
							propertyList = PropertyUtil.getProperty(copy, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//
							propertyList = PropertyUtil.getProperty(copy, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
							property.addChildren(copy, index + i);
						}
						i++;
					}
				}
			}
		}
		
		return property;
	}
	
	/**
	 * Ρѥץѥƥ֤ޤ
	 * 
	 * @param mode
	 * @return Ρѥץѥƥ
	 */
	public Property getProperty(int mode, Locale local) {
	    //եƥID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", local), PropertyConstant.EDITOR_TEXT);
		//եƥ̾
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name", local), PropertyConstant.EDITOR_TEXT);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", local), PropertyConstant.EDITOR_TEXT);
//		//PINGƻ
//		Property pingMonitoring =
//			new Property(PING_MONITOR, Messages.getString("ping.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//PINGƻ륹ơ
//		Property pingMonitoringStatus =
//			new Property(PING_MONITOR_STATUS, Messages.getString("ping.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_PING_STATUS);
//		//ȴƻ
//		Property agentMonitoring =
//			new Property(AGENT_MONITOR, Messages.getString("agent.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//ȴƻ륹ơ
//		Property agentMonitoringStatus =
//			new Property(AGENT_MONITOR_STATUS, Messages.getString("agent.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_BOOL);
//		//ơƻ
//		Property statusMonitoring =
//			new Property(STATUS_MONITOR, Messages.getString("status.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//٥ȴƻ
//		Property eventMonitoring =
//			new Property(EVENT_MONITOR, Messages.getString("event.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//
//		Property agentControl =
//			new Property(AGENT_CONTROL, Messages.getString("agent.control", local), PropertyConstant.EDITOR_BOOL);
		//DHCP饤
		Property dhcpClient =
			new Property(DHCP_CLIENT, Messages.getString("dhcp.client", local), PropertyConstant.EDITOR_BOOL);
		//IP
		Property ipAddressType =
			new Property(IP_ADDRESS_TYPE, Messages.getString("ip.address.type", local), PropertyConstant.EDITOR_NUM);
		//IPС
		Property ipAddressVersion =
			new Property(IP_ADDRESS_VERSION, Messages.getString("ip.address.version", local), PropertyConstant.EDITOR_NUM);
		//IPɥ쥹V4
		Property ipAddressV4 =
			new Property(IP_ADDRESS_V4, Messages.getString("ip.address.v4", local), PropertyConstant.EDITOR_TEXT);
		//IPɥ쥹V6
		Property ipAddressV6 =
			new Property(IP_ADDRESS_V6, Messages.getString("ip.address.v6", local), PropertyConstant.EDITOR_TEXT);
		//ۥ̾
		Property hostName =
			new Property(HOST_NAME, Messages.getString("host.name", local), PropertyConstant.EDITOR_TEXT);
		//H/W
		Property hardwareType =
			new Property(HARDWARE_TYPE, Messages.getString("hardware.type", local), PropertyConstant.EDITOR_TEXT);
		//ץåȥե
		Property platformFamilyName =
			new Property(PLATFORM_FAMILY_NAME, Messages.getString("platform.family.name", local), PropertyConstant.EDITOR_TEXT);
		//OS̾
		Property osName =
			new Property(OS_NAME, Messages.getString("os.name", local), PropertyConstant.EDITOR_TEXT);
		//Ρ̾
		Property nodeName =
			new Property(NODE_NAME, Messages.getString("node.name", local), PropertyConstant.EDITOR_TEXT);
		//OS꡼
		Property osRelease =
			new Property(OS_RELEASE, Messages.getString("os.release", local), PropertyConstant.EDITOR_TEXT);
		//OSС
		Property osVersion =
			new Property(OS_VERSION, Messages.getString("os.version", local), PropertyConstant.EDITOR_TEXT);
		//ʸå
		Property characterSet =
			new Property(CHARACTER_SET, Messages.getString("character.set", local), PropertyConstant.EDITOR_TEXT);
		//
		Property administrator =
			new Property(ADMINISTRATOR, Messages.getString("administrator", local), PropertyConstant.EDITOR_TEXT);
		//Ϣ
		Property contact =
			new Property(CONTACT, Messages.getString("contact", local), PropertyConstant.EDITOR_TEXT);
		//Ͽ
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", local), PropertyConstant.EDITOR_DATETIME);
		//Ͽ
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", local), PropertyConstant.EDITOR_TEXT);
		//
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", local), PropertyConstant.EDITOR_DATETIME);
		//
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", local), PropertyConstant.EDITOR_TEXT);

		//ǥХ
		Property deviceName =
			new Property(DEVICE_NAME, Messages.getString("device.name", local), PropertyConstant.EDITOR_TEXT);
		//ǥХOID
		Property deviceOID =
			new Property(DEVICE_OID, Messages.getString("device.oid", local), PropertyConstant.EDITOR_TEXT);
		//ǥХINDEX
		Property deviceIndex =
			new Property(DEVICE_INDEX, Messages.getString("device.index", local), PropertyConstant.EDITOR_NUM);
		//ǥХ
		Property deviceType =
			new Property(DEVICE_TYPE, Messages.getString("device.type", local), PropertyConstant.EDITOR_TEXT);
		//
		Property deviceDescription =
			new Property(DEVICE_DESCRIPTION, Messages.getString("description", local), PropertyConstant.EDITOR_TEXT);
		
		//ͥåȥ
		Property network = 
			new Property(NETWORK, Messages.getString("network", local), PropertyConstant.EDITOR_TEXT);
		//OS
		Property os = 
			new Property(OS, Messages.getString("os", local), PropertyConstant.EDITOR_TEXT);
		//ݼ
		Property maintenance =
			new Property(MAINTENANCE, Messages.getString("maintenance", local), PropertyConstant.EDITOR_TEXT);
		//ǥХ
		Property device =
			new Property(DEVICE, Messages.getString("device", local), PropertyConstant.EDITOR_TEXT);
		
		
		//ͤ
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
//		pingMonitoring.setValue(new Boolean(false));
//		pingMonitoringStatus.setValue("");
//		agentMonitoring.setValue(new Boolean(false));
//		agentMonitoringStatus.setValue(new Boolean(false));
//		statusMonitoring.setValue(new Boolean(false));
//		eventMonitoring.setValue(new Boolean(false));
//		agentControl.setValue(new Boolean(false));
		dhcpClient.setValue(new Boolean(false));
		ipAddressType.setValue("");
		ipAddressVersion.setValue("");
		ipAddressV4.setValue("");
		ipAddressV6.setValue("");
		hostName.setValue("");
		hardwareType.setValue("");
		platformFamilyName.setValue("");
		osName.setValue("");
		nodeName.setValue("");
		osRelease.setValue("");
		osVersion.setValue("");
		characterSet.setValue("");
		administrator.setValue("");
		contact.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		deviceName.setValue("");
		deviceOID.setValue("");
		deviceIndex.setValue("");
		deviceType.setValue("");
		deviceDescription.setValue("");

		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		device.setValue("");

		//⡼ɤˤꡢѹĵڤӥԡĤ
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(maintenance);
		property.addChildren(device);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		
		// ͥåȥĥ꡼
		network.removeChildren();
//		network.addChildren(pingMonitoring);
//		network.addChildren(pingMonitoringStatus);
//		network.addChildren(agentMonitoring);
//		network.addChildren(agentMonitoringStatus);
//		network.addChildren(agentControl);
//		network.addChildren(statusMonitoring);
//		network.addChildren(eventMonitoring);
		network.addChildren(dhcpClient);
		network.addChildren(ipAddressType);
		network.addChildren(ipAddressVersion);
		network.addChildren(ipAddressV4);
		network.addChildren(ipAddressV6);
		network.addChildren(hostName);

		// OSĥ꡼
		os.removeChildren();
		os.addChildren(nodeName);
		os.addChildren(osName);
		os.addChildren(osRelease);
		os.addChildren(osVersion);
		os.addChildren(platformFamilyName);
		os.addChildren(hardwareType);
		os.addChildren(characterSet);
		
		// ݼĥ꡼
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		// ǥХĥ꡼
		device.removeChildren();
		device.addChildren(deviceName);
		device.addChildren(deviceOID);
		device.addChildren(deviceIndex);
		device.addChildren(deviceType);
		device.addChildren(deviceDescription);
		
		return property;
	}
}
