/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * Ρɥե륿ѥץѥƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeFilterProperty {
	/** եƥID */
	public static final String FACILITY_ID = "facilityId";
	/** եƥ̾ */
	public static final String FACILITY_NAME = "facilityName";
	/**  */
	public static final String DESCRIPTION = "description";
	/** IPɥ쥹 */
	public static final String IP_ADDRESS = "ipAddress";
	/** OS̾ */
	public static final String OS_NAME = "osName";
	/** OS꡼ */
	public static final String OS_RELEASE = "osRelease";
	/**  */
	public static final String ADMINISTRATOR = "administrator";
	/** Ϣ */
	public static final String CONTACT = "contact";
	
	/** ͥåȥ */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** ݼ */
	public static final String MAINTENANCE = "maintenance";
	
	/**
	 * Ρɥե륿ѥץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return Ρɥե륿ѥץѥƥ
	 */
	public Property getProperty(Locale local) {
		//եƥID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", local), PropertyConstant.EDITOR_TEXT);
		//եƥ̾
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name", local), PropertyConstant.EDITOR_TEXT);
		//
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", local), PropertyConstant.EDITOR_TEXT);
		//IPɥ쥹
		Property ipAddress =
			new Property(IP_ADDRESS, Messages.getString("ip.address.v4", local), PropertyConstant.EDITOR_TEXT);
		//OS̾
		Property osName =
			new Property(OS_NAME, Messages.getString("os.name", local), PropertyConstant.EDITOR_TEXT);
		//OS꡼
		Property osRelease =
			new Property(OS_RELEASE, Messages.getString("os.release", local), PropertyConstant.EDITOR_TEXT);
		//
		Property administrator =
			new Property(ADMINISTRATOR, Messages.getString("administrator", local), PropertyConstant.EDITOR_TEXT);
		//Ϣ
		Property contact =
			new Property(CONTACT, Messages.getString("contact", local), PropertyConstant.EDITOR_TEXT);

		//ͥåȥ
		Property network = 
			new Property(NETWORK, Messages.getString("network", local), PropertyConstant.EDITOR_TEXT);
		//OS
		Property os = 
			new Property(OS, Messages.getString("os", local), PropertyConstant.EDITOR_TEXT);
		//ݼ
		Property maintenance =
			new Property(MAINTENANCE, Messages.getString("maintenance", local), PropertyConstant.EDITOR_TEXT);

		//ͤ
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		ipAddress.setValue("");
		osName.setValue("");
		osRelease.setValue("");
		administrator.setValue("");
		contact.setValue("");

		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		
		//ѹβ/ԲĤ
		facilityId.setModify(PropertyConstant.MODIFY_OK);
		facilityName.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		ipAddress.setModify(PropertyConstant.MODIFY_OK);
		osName.setModify(PropertyConstant.MODIFY_OK);
		osRelease.setModify(PropertyConstant.MODIFY_OK);
		administrator.setModify(PropertyConstant.MODIFY_OK);
		contact.setModify(PropertyConstant.MODIFY_OK);

		os.setModify(PropertyConstant.MODIFY_NG);
		network.setModify(PropertyConstant.MODIFY_NG);
		maintenance.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(maintenance);
		
		// ͥåȥĥ꡼
		network.removeChildren();
		network.addChildren(ipAddress);

		// OSĥ꡼
		os.removeChildren();
		os.addChildren(osName);
		os.addChildren(osRelease);
		
		// ݼĥ꡼
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		return property;
	}
}
