/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.bean.TopicConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.repository.util.SendTopic;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * եƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifyFacility {
	protected static Log m_log = LogFactory.getLog(ModifyFacility.class);
	
	/**
	 * ɲ
	 * 
	 * @param parentFacilityId
	 * @param property
	 * @throws RemoveException
	 * @throws CreateException
	 * @throws NamingException
	 */
	public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
		
		//եƥID
		ArrayList facilityId = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_ID);
		//եƥ̾
		ArrayList facilityName = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_NAME);
		//
		ArrayList description = PropertyUtil.getPropertyValue(property, ScopeProperty.DESCRIPTION);

		//Facility
		FacilityLocal facility;
		try {
			facility = FacilityUtil.getLocalHome().create(
					(String)facilityId.get(0), 
					(String)facilityName.get(0), 
					FacilityConstant.TYPE_SCOPE);
					
			//Facility
			facility.setDescription(checkString(description.get(0)));

		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            
            m_log.debug("addScope() : " + e.getMessage());
			throw e;
		}
		
		try {
			//FacilityTree
			FacilityTreeLocal facilityTree = FacilityTreeUtil.getLocalHome().create(
					(String)facilityId.get(0), 
					FacilityConstant.TYPE_SCOPE, 
					parentFacilityId);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            
			try {
				//Facility
				facility.remove();
			} catch (EJBException e1) {
			    m_log.debug("addScope() : " + e.getMessage());
				throw e1;
			}
			m_log.debug("addScope() : " + e.getMessage());
			throw e;
		}
		
		try {
			//Topic
			SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
			send.put(new UpdateRepositoryInfo());
		} catch (Exception e) {
			m_log.debug("addScope() : 顼 : " + e.getMessage());
		}
	}
	
	/**
	 * ѹ
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyScope(Property property) throws NamingException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	ArrayList facilityId = null;
	    try {
			//եƥID
			facilityId = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_ID);
			//եƥ̾
			ArrayList facilityName = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_NAME);
			//
			ArrayList description = PropertyUtil.getPropertyValue(property, ScopeProperty.DESCRIPTION);
			
			//Facility
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(
					(String)facilityId.get(0));
			
			//եƥ̾
			facility.setCn(checkString(facilityName.get(0)));
			//
			facility.setDescription(checkString(description.get(0)));
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            
            m_log.debug("modifyScope() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            
            m_log.debug("modifyScope() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * פؤΥΡɳ
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException  {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	String facilityId = null;
	    try {
		    //ƥեƥIDFacilityTree(Ρ)
			for(int i = 0; i < facilityIds.length; i++){
			    facilityId = facilityIds[i];
			    FacilityTreeLocal facilityTree = 
			        FacilityTreeUtil.getLocalHome().create(
			                facilityId, FacilityConstant.TYPE_NODE, parentFacilityId);
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId, parentFacilityId};
            apllog.put("SYS", "015", args);
            
            m_log.debug("assignNodeScope() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Ρɲ
	 * 
	 * @param property
	 * @param user
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void addNode(Property property, String user) throws NamingException, CreateException  {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
		
		String facilityId = null;
	    try {
			ArrayList values = null;
			//
			Date now = new Date();
			
			//եƥID
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_ID);
			facilityId = (String)values.get(0);
			//եƥ̾
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
			String facilityName = (String)values.get(0);
			
			//Facility
			FacilityLocal facility = FacilityUtil.getLocalHome().create(
					facilityId, 
					facilityName, 
					FacilityConstant.TYPE_NODE);
			
//			//Facility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//			facility.setAgentControl((Boolean)values.get(0));
//			//ȴƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//			facility.setAgentWatch((Boolean)values.get(0));
//			//ȴƻ륹ơFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//			facility.setAgentWatchStatus((Boolean)values.get(0));
			//ʸåȤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
			facility.setCharSet(checkString(values.get(0)));
			//ϿFacility
			facility.setCreateTimestamp(now);
			//ϿԤFacility
			facility.setCreatorsName(user);
			//Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
			facility.setDescription(checkString(values.get(0)));
			//DHCP饤ȤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
			facility.setDhcpClient((Boolean)values.get(0));
			//ۥ̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
			facility.setHost(checkArrayList(values));
			//IPɥ쥹V4Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
			facility.setIpNetworkNumber(checkString(values.get(0)));
			//IPɥ쥹V6Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
			facility.setIpNetworkNumberV6(checkString(values.get(0)));
			//IPСFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
			facility.setIpProtocolNumber(checkInteger(values.get(0)));
			//IPפFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
			facility.setIpType(checkInteger(values.get(0)));
//			//٥ȴƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//			facility.setLogWatch((Boolean)values.get(0));
			//H/WפFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
			facility.setMachine(checkString(values.get(0)));
			//ԤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
			facility.setManagerName(checkString(values.get(0)));
			//ϢFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
			facility.setManagerContact(checkString(values.get(0)));
			//ԤFacility
			facility.setModifiersName(user);
			//Facility
			facility.setModifyTimestamp(now);
			//Ρ̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
			facility.setNodeName(checkString(values.get(0)));
			//OS̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
			facility.setOsName(checkString(values.get(0)));
			//OS꡼Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
			facility.setOsRelease(checkString(values.get(0)));
			//OSСFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
			facility.setOsVersion(checkString(values.get(0)));
//			//PINGƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//			facility.setPingWatch((Boolean)values.get(0));
			//ץåȥեFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
			facility.setPlatform(checkString(values.get(0)));
//			//ơƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//			facility.setStatusWatch((Boolean)values.get(0));

			//null򥻥åȤ뤳Ȥstore()ƤӽФ
			facility = null;

			//ǥХ
			ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
			for(int i = 0; i < deviceList.size(); i++){
			    //ǥХ̾
				Property deviceProperty= (Property)deviceList.get(i);
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
				String cn = (String)values.get(0);
				
				if(cn != null && cn.compareTo("") != 0){
					//DeviceInfo
					DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
							cn, 
							facilityId);
				
					if(device != null){
					    //ǥХINDEXDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
						device.setDeviceIndex(checkInteger(values.get(0)));
						//ǥХOIDDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
						device.setSnmpOID(checkString(values.get(0)));
						//ǥХפDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
						device.setDeviceType(checkString(values.get(0)));
						//DeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
						device.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "009", args);
            
            m_log.debug("addNode() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Ρѹ
	 * 
	 * @param property
	 * @param user
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public void modifyNode(Property property, String user) throws NamingException, FinderException, CreateException  {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	String facilityId = null;
	    try {
			ArrayList values = null;
			Date now = new Date();
			
			//եƥID
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_ID);
			facilityId = (String)values.get(0);
			
			//Facility򸡺
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			//եƥ̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
			facility.setCn(checkString(values.get(0)));
//			//Facility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//			facility.setAgentControl((Boolean)values.get(0));
//			//ȴƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//			facility.setAgentWatch((Boolean)values.get(0));
//			//ȴƻ륹ơFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//			facility.setAgentWatchStatus((Boolean)values.get(0));
			//ʸåȤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
			facility.setCharSet(checkString(values.get(0)));
			//Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
			facility.setDescription(checkString(values.get(0)));
			//DHCP饤ȤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
			facility.setDhcpClient((Boolean)values.get(0));
			//ۥ̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
			facility.setHost(checkArrayList(values));
			//IPɥ쥹V4Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
			facility.setIpNetworkNumber(checkString(values.get(0)));
			//IPɥ쥹V6Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
			facility.setIpNetworkNumberV6(checkString(values.get(0)));
			//IPСFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
			facility.setIpProtocolNumber(checkInteger(values.get(0)));
			//IPפFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
			facility.setIpType(checkInteger(values.get(0)));
//			//٥ȴƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//			facility.setLogWatch((Boolean)values.get(0));
			//H/WפFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
			facility.setMachine(checkString(values.get(0)));
			//ԤFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
			facility.setManagerName(checkString(values.get(0)));
			//ϢFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
			facility.setManagerContact(checkString(values.get(0)));
			//ԤFacility
			facility.setModifiersName(user);
			//Facility
			facility.setModifyTimestamp(now);
			//Ρ̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
			facility.setNodeName(checkString(values.get(0)));
			//OS̾Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
			facility.setOsName(checkString(values.get(0)));
			//OS꡼Facility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
			facility.setOsRelease(checkString(values.get(0)));
			//OSСFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
			facility.setOsVersion(checkString(values.get(0)));
//			//PINGƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//			facility.setPingWatch((Boolean)values.get(0));
//			//PINGƻ륹ơFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR_STATUS);
//			if(values.get(0) instanceof Boolean)
//			    facility.setPingWatchStatus((Boolean)values.get(0));
			//ץåȥեFacility
			values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
			facility.setPlatform(checkString(values.get(0)));
//			//ơƻFacility
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//			facility.setStatusWatch((Boolean)values.get(0));
			
		    //FacilityȴϢƤǥХ
			try {
				//FacilityȴϢƤǥХ
				Collection ct = facility.getDeviceInfo();
				
				//DeviceInfo
				Iterator itr = ct.iterator();
				DeviceInfoLocal device = null;
				while(itr.hasNext()){
					device = (DeviceInfoLocal)itr.next();
					device.remove();
				}
			} catch (FinderException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (EJBException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (RemoveException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			}
			//null򥻥åȤ뤳Ȥstore()ƤӽФ
			facility = null;
			
			//ǥХ
			ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);

			//ǥХκ
			for(int i = 0; i < deviceList.size(); i++){
			    //ǥХ̾
				Property deviceProperty= (Property)deviceList.get(i);
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
				String cn = (String)values.get(0);
				
				if(cn != null && cn.compareTo("") != 0){
					//DeviceInfo
					DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
							cn, 
							facilityId);
	
					if(device != null){
					    //ǥХINDEXDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
						device.setDeviceIndex(checkInteger(values.get(0)));
						//ǥХOIDDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
						device.setSnmpOID(checkString(values.get(0)));
						//ǥХפDeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
						device.setDeviceType(checkString(values.get(0)));
						//DeviceInfo
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
						device.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "011", args);
            
            m_log.debug("modifyNode() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "011", args);
            
            m_log.debug("modifyNode() : " + e.getMessage());
			throw e;
		}
	}
	

	/**
	 * Ρѹ()
	 * 
	 * @param property
	 * @param parentFacilityId
	 * @param user
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyAllNode(Property property, String parentFacilityId, String user) throws NamingException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	Collection collection;
		try {
		    //եƥID۲ΥΡɤ
			collection = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);

			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				FacilityLocal facility = ft.getFacility();
				
				try {
				    //Ρѹ
				    ArrayList values = null;
					Date now = new Date();
					
					//եƥ̾Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setCn(checkString(values.get(0)));
//					//Facility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentControl((Boolean)values.get(0));
//					//ȴƻFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentWatch((Boolean)values.get(0));
//					//ȴƻ륹ơFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentWatchStatus((Boolean)values.get(0));
					//ʸåȤFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
					if(checkString(values.get(0)) != null)
					    facility.setCharSet(checkString(values.get(0)));
					//Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
					if(checkString(values.get(0)) != null)
					    facility.setDescription(checkString(values.get(0)));
					//DHCP饤ȤFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
					if(values.get(0) != null && values.get(0) instanceof Boolean)
					    facility.setDhcpClient((Boolean)values.get(0));
					//ۥ̾Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
					if(checkArrayList(values.get(0)) != null)
					    facility.setHost(checkArrayList(values));
					//IPɥ쥹V4Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
					if(checkString(values.get(0)) != null)
					    facility.setIpNetworkNumber(checkString(values.get(0)));
					//IPɥ쥹V6Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
					if(checkString(values.get(0)) != null)
					    facility.setIpNetworkNumberV6(checkString(values.get(0)));
					//IPСFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
					if(checkInteger(values.get(0)) != null)
					    facility.setIpProtocolNumber(checkInteger(values.get(0)));
					//IPפFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
					if(checkInteger(values.get(0)) != null)
					    facility.setIpType(checkInteger(values.get(0)));
//					//٥ȴƻFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setLogWatch((Boolean)values.get(0));
					//H/WפFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
					if(checkString(values.get(0)) != null)
					    facility.setMachine(checkString(values.get(0)));
					//ԤFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
					if(checkString(values.get(0)) != null)
					    facility.setManagerName(checkString(values.get(0)));
					//ϢFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
					if(checkString(values.get(0)) != null)
					    facility.setManagerContact(checkString(values.get(0)));
					//ԤFacility
					facility.setModifiersName(user);
					//Facility
					facility.setModifyTimestamp(now);
					//Ρ̾Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setNodeName(checkString(values.get(0)));
					//OS̾Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setOsName(checkString(values.get(0)));
					//OS꡼Facility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
					if(checkString(values.get(0)) != null)
					    facility.setOsRelease(checkString(values.get(0)));
					//OSСFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
					if(checkString(values.get(0)) != null)
					    facility.setOsVersion(checkString(values.get(0)));
//					//PINGƻFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setPingWatch((Boolean)values.get(0));
//					//PINGƻ륹ơFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR_STATUS);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setPingWatchStatus((Boolean)values.get(0));
					//ץåȥեFacility
					values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setPlatform(checkString(values.get(0)));
//					//ơƻFacility
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setStatusWatch((Boolean)values.get(0));
					
					//ǥХ
					ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
				    //ǥХ̾
					Property deviceProperty= (Property)deviceList.get(0);
					values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
					
					if(deviceList.size() > 0 && checkString(values.get(0)) != null){
					    //FacilityȴϢƤǥХ
						try {
							//FacilityȴϢƤǥХ
							Collection ct = facility.getDeviceInfo();
							
							//DeviceInfo
							Iterator itr1 = ct.iterator();
							DeviceInfoLocal device = null;
							while(itr.hasNext()){
								device = (DeviceInfoLocal)itr1.next();
								device.remove();
							}
						} catch (FinderException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (EJBException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (RemoveException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						}
					}

					//ǥХκ
					for(int i = 0; i < deviceList.size(); i++){
					    //ǥХ̾
						deviceProperty= (Property)deviceList.get(i);
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
						String cn = (String)values.get(0);
						
						if(cn != null && cn.compareTo("") != 0){
							//DeviceInfo
							DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
									cn, 
									facility.getFacilityId());
			
							if(device != null){
							    //ǥХINDEXDeviceInfo
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
								device.setDeviceIndex(checkInteger(values.get(0)));
								//ǥХOIDDeviceInfo
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
								device.setSnmpOID(checkString(values.get(0)));
								//ǥХפDeviceInfo
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
								device.setDeviceType(checkString(values.get(0)));
								//DeviceInfo
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
								device.setDescription(checkString(values.get(0)));
							}
						}
					}
				} catch (CreateException e) {
				    m_log.debug("modifyAllNode() : " + e.getMessage());
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
		    m_log.debug("modifyAllNode() : " + e.getMessage());
			throw e;
		}
	}
	

    /**
     * Ρɾܺ٤
     * 
     * @param facilityId
     * @param attributes °̾ͤHashMap
     * @throws FinderException
     * @throws NamingException
     */
    public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            
            if(attributes.get(FacilityAttributeConstant.CN) != null){
                //cn
                String attribute = (String)attributes.get(FacilityAttributeConstant.CN);
                facility.setCn(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.DESCRIPTION) != null){
                //description
                String attribute = (String)attributes.get(FacilityAttributeConstant.DESCRIPTION);
                facility.setDescription(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTCONTROL) != null){
                //ccAgentControl
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTCONTROL);
                facility.setAgentControl(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTWATCH) != null){
                //ccAgentWatch
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTWATCH);
                facility.setAgentWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTWATCHSTATUS) != null){
                //ccAgentWatchStatus
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTWATCHSTATUS);
                facility.setAgentWatchStatus(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CHARSET) != null){
                //ccCharSet
                String attribute = (String)attributes.get(FacilityAttributeConstant.CHARSET);
                facility.setCharSet(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CREATETIMESTAMP) != null){
                //ccCreateTimestamp
                Date attribute = (Date)attributes.get(FacilityAttributeConstant.CREATETIMESTAMP);
                facility.setCreateTimestamp(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CREATORSNAME) != null){
                //ccCreatorsName
                String attribute = (String)attributes.get(FacilityAttributeConstant.CREATORSNAME);
                facility.setCreatorsName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.DHCPCLIENT) != null){
                //ccDhcpClient
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.DHCPCLIENT);
                facility.setDhcpClient(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.HOST) != null){
                //host
                ArrayList attribute = (ArrayList)attributes.get(FacilityAttributeConstant.HOST);
                facility.setHost(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPNETWORKNUMBER) != null){
                //ipNetworkNumber
                String attribute = (String)attributes.get(FacilityAttributeConstant.IPNETWORKNUMBER);
                facility.setIpNetworkNumber(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) != null){
                //ccIpNetworkNumberV6
                String attribute = (String)attributes.get(FacilityAttributeConstant.IPNETWORKNUMBERV6);
                facility.setIpNetworkNumberV6(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) != null){
                //ipProtocolNumber
                Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.IPPROTOCOLNUMBER);
                facility.setIpProtocolNumber(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPTYPE) != null){
                //ccIpType
                Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.IPTYPE);
                facility.setIpType(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.LOGWATCH) != null){
                //ccLogWatch
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.LOGWATCH);
                facility.setLogWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MACHINE) != null){
                //ccMachine
                String attribute = (String)attributes.get(FacilityAttributeConstant.MACHINE);
                facility.setMachine(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MANAGERCONTACT) != null){
                //ccManagerContact
                String attribute = (String)attributes.get(FacilityAttributeConstant.MANAGERCONTACT);
                facility.setManagerContact(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MANAGERNAME) != null){
                //ccManagerName
                String attribute = (String)attributes.get(FacilityAttributeConstant.MANAGERNAME);
                facility.setManagerName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MODIFIERSNAME) != null){
                //ccModifiersName
                String attribute = (String)attributes.get(FacilityAttributeConstant.MODIFIERSNAME);
                facility.setModifiersName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MODIFYTIMESTAMP) != null){
                //ccModifyTimestamp
                Date attribute = (Date)attributes.get(FacilityAttributeConstant.MODIFYTIMESTAMP);
                facility.setModifyTimestamp(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.NODENAME) != null){
                //ccNodeName
                String attribute = (String)attributes.get(FacilityAttributeConstant.NODENAME);
                facility.setNodeName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSNAME) != null){
                //ccOsName
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSNAME);
                facility.setOsName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSRELEASE) != null){
                //ccOsRelease
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSRELEASE);
                facility.setOsRelease(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSVERSION) != null){
                //ccOsVersion
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSVERSION);
                facility.setOsVersion(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PINGWATCH) != null){
                //ccPingWatch
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.PINGWATCH);
                facility.setPingWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PINGWATCHSTATUS) != null){
                //ccPingWatchStatus
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.PINGWATCHSTATUS);
                facility.setPingWatchStatus(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PLATFORM) != null){
                //ccPlatform
                String attribute = (String)attributes.get(FacilityAttributeConstant.PLATFORM);
                facility.setPlatform(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.STATUSWATCH) != null){
                //ccPlatform
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.STATUSWATCH);
                facility.setStatusWatch(attribute);
            }
        } catch (FinderException e) {
            m_log.debug("setNodeDetail() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            m_log.debug("setNodeDetail() : " + e.getMessage());
            throw e;
        }
    }
	
	/**
	 * IntegerΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
    protected Integer checkInteger(Object value){
		if(value instanceof Integer){
			return (Integer)value;
		}
		else{
			return null;
		}
	}
	
	/**
	 * StringΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
	protected String checkString(Object value){
		if(value instanceof String){
			if(((String)value).compareTo("") == 0){
				return null;
			}
			else{
				return (String)value;
			}
		}
		else{
			return null;
		}
	}
	
	/**
	 * ArrayListΥ󥹥󥹤åäƤnull֤
	 * 
	 * @param value
	 * @return
	 */
	protected ArrayList checkArrayList(Object value){
		if(value instanceof ArrayList){
			boolean checkNull = true;
			ArrayList list = (ArrayList)value;
			for(int i = 0; i < list.size(); i++){
				if(checkString(list.get(i)) != null){
					list.set(i, checkString(list.get(i)));
					checkNull = false;
				}
				else if(checkInteger(list.get(i)) != null){
					list.set(i, checkInteger(list.get(i)));
					checkNull = false;
				}
				else{
					list.set(i, null);
				}
			}

			if(checkNull){
				list = null;
			}

			return list;
		}
		else{
			return null;
		}
	}
}
